/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * PRIVATE HEADER
 *
 ******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/
#ifndef _AGW_ISOBAR_OBJ_H_
#define _AGW_ISOBAR_OBJ_H_

  /**************/
 /** INCLUDES **/
/**************/

#include <stdio.h>

#include "standard.h"
#include "osal.h"

  /***************/
 /** CONSTANTS **/
/***************/

// Object Debugging:
// If DEBUG_OBJECT isn't defined
// define it locally
#ifndef DEBUG_OBJECT
#define DEBUG_OBJECT 0
#endif

// Include the debug definitions
// header, which depends on how
// DEBUG_OBJECT is defined
#include "sms_debug_definitions.h"

/* Object name prefix for objects */
#define AGW_ISOBAR_OBJECT_NAME "AGW_ISOBAR"

  /**************/
 /** TYPEDEFS **/
/**************/

typedef struct agw_isobar_object_struct
{
    // Pressure
    AGW_FIXED_OBJECT_STRUCT sPressure;

} AGW_ISOBAR_OBJECT_STRUCT;

  /************/
 /** MACROS **/
/************/

  /****************/
 /** PROTOTYPES **/
/****************/

/* Object Public Prototypes */
static SMSAPI_RETURN_CODE_ENUM ePressure (
    AGW_ISOBAR_OBJECT hAgwIsobar,
    OSAL_FIXED_OBJECT hPressure
        );

static N32 n32FPrintf (
    AGW_ISOBAR_OBJECT hAgwIsobar,
    FILE *psFile,
    SMSAPI_OUTPUT_OPTION_ENUM eOutputOption
        );

  /***************/
 /** VARIABLES **/
/***************/

// Global (re-usable) instance of an interface for this object
const AGW_ISOBAR_OBJECT_INTERFACE_STRUCT AGW_ISOBAR = {
    /* ePressure = */ ePressure,
    /* n32FPrintf = */ n32FPrintf
};

  /**********************/
 /** INLINE FUNCTIONS **/
/**********************/

#endif  // _AGW_ISOBAR_OBJ_H_
