/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * PRIVATE HEADER
 *
 ******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/
#ifndef _XMAPPID_PACKET_UTIL_H_
#define _XMAPPID_PACKET_UTIL_H_

  /**************/
 /** INCLUDES **/
/**************/

#include <stdio.h>

#include "standard.h"
#include "osal.h"

#include "sms_api.h"

  /***************/
 /** CONSTANTS **/
/***************/

// Object Debugging:
// If DEBUG_OBJECT isn't defined
// define it locally
#ifndef DEBUG_OBJECT
#define DEBUG_OBJECT 0
#endif

// Include the debug definitions
// header, which depends on how
// DEBUG_OBJECT is defined
#include "sms_debug_definitions.h"

/* XM AppID Packet Constants */
#define XM_APPID_SYNC_BYTELEN           1
#define XM_APPID_ID_BYTELEN             1
#define XM_APPID_LEN_BYTELEN            2
#define XM_APPID_SEQ_BYTELEN            1
#define XM_APPID_HDR_CRC_BYTELEN        1

#define XM_APPID_HEADER_BYTELEN         \
    (XM_APPID_SYNC_BYTELEN + XM_APPID_ID_BYTELEN + \
     XM_APPID_LEN_BYTELEN + XM_APPID_SEQ_BYTELEN + XM_APPID_HDR_CRC_BYTELEN)

#define XM_APPID_CRC_BYTELEN            2

  /**************/
 /** TYPEDEFS **/
/**************/

  /************/
 /** MACROS **/
/************/

  /****************/
 /** PROTOTYPES **/
/****************/

  /***************/
 /** VARIABLES **/
/***************/

  /**********************/
 /** INLINE FUNCTIONS **/
/**********************/

#endif	// _XMAPPID_PACKET_UTIL_H
