/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * PRIVATE HEADER
 *
 ******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/
#ifndef _SPORTS_SERVICE_HIGHBAND_H_
#define _SPORTS_SERVICE_HIGHBAND_H_

  /**************/
 /** INCLUDES **/
/**************/

#include "standard.h"
#include "osal.h"

#include "sms_api.h"
#include "sms_obj.h"
#include "sports_service_interface.h"

  /************************/
 /** CONSTANTS / MACROS **/
/************************/

// Object Debugging:
// If DEBUG_OBJECT isn't defined
// define it locally
#ifndef DEBUG_OBJECT
#define DEBUG_OBJECT 0
#endif

// Include the debug definitions
// header, which depends on how
// DEBUG_OBJECT is defined
#include "sms_debug_definitions.h"

#define SPORTS_SVC_HB_OBJ_NAME "Sports:HB"

#define SPORTS_SERVICE_HIGHBAND_MAX_NUMBER_TABLE_DEFS 1024	// size of table def lookup table
#define SPORTS_SERVICE_HIGHBAND_MAX_TNAME_SYMBOL_COUNT 48
// LBID is 8 bits in table def and 10 bits in override with table instance.
// We will range check overrides to the 8 bit value.
#define SPORTS_SERVICE_HIGHBAND_MAX_LABEL_ID 255
#define SPORTS_SERVICE_HIGHBAND_LABEL_ID_LOOKUP_SIZE \
    (SPORTS_SERVICE_HIGHBAND_MAX_LABEL_ID + 1)

// The protocol version supported
// by SMS for this interface
#define SPORTS_SERVICE_PVN (UN8)(1)
#define SPORTS_SERVICE_DSI (530)

// multi-AU group general defs
#define SPORTS_SERVICE_MAX_AU_GROUP_SIZE 16
#define SPORTS_SERVICE_MAX_AU_IMPLEMENTATION_LIMIT 32
#define SPORTS_SERVICE_CRC_BYTELEN (4)

// Maximum overhead bit size for a multi au payload.  Max au header
// size possible of all carousel types: 104(data instances(3,4)).
#define SS_AU_GROUP_OVERHEAD_BOUND_BITS \
    ((104 + (SPORTS_SERVICE_CRC_BYTELEN * 8)) \
    * SPORTS_SERVICE_MAX_AU_GROUP_SIZE)

#define SPORTS_SERVICE_MAX_AU_SIZE_BYTES (5120)

#define SS_MAX_CONFIG_PAYLOAD_SIZE_BITS (1024 * 12 * 8)
#define SS_MAX_AFFILIATE_PAYLOAD_SIZE_BITS (1024 * 12 * 8)
#define SS_MAX_DATA_PAYLOAD_SIZE_BITS (1024 * 12 * 8)
#define SS_MAX_TDEF_PAYLOAD_SIZE_BITS (1024 * 5 * 8)

#define SPORTS_SERVICE_BUFFER_BYTESIZE \
    ((SS_AU_GROUP_OVERHEAD_BOUND_BITS * 5 \
    + SS_MAX_CONFIG_PAYLOAD_SIZE_BITS \
    + SS_MAX_AFFILIATE_PAYLOAD_SIZE_BITS \
    + SS_MAX_TDEF_PAYLOAD_SIZE_BITS \
    + 2 * SS_MAX_DATA_PAYLOAD_SIZE_BITS)/8)

//
// General Carousel Definitions
//

#define SPORTS_LABEL_TYPE_HTEAM (0x00)
#define SPORTS_LABEL_TYPE_VTEAM (0x01)
#define SPORTS_LABEL_TYPE_PARTICIPANT_PARTITION (0x1c)
#define SPORTS_LABEL_TYPE_TABLEREF (0x25)

// If increased, parse destination buffers which are 32 bit values need to
// be updated to avoid memory violation.
#define SPORTS_LABEL_MAX_INTEGER_BIT_SIZE 32
#define SPORTS_LABEL_MAX_TABLEREF_BIT_SIZE 16
#define SPORTS_LABEL_INTEGER_TEAM_BIT_SIZE 10

// Carousel IDs
typedef enum carousel_id_enum {
    CAROUSEL_ID_CONFIG = 0,
    CAROUSEL_ID_AFFILIATIONS,
    CAROUSEL_ID_TABLEDEF,
    CAROUSEL_ID_DATA0,
    CAROUSEL_ID_DATA1,
    CAROUSEL_ID_COUNT
} CAROUSEL_ID_ENUM;

#define SPORTS_SERVICE_CONFIG_CAROUSEL_ID (0)
#define SPORTS_SERVICE_AFFILIATIONS_CAROUSEL_ID (1)
#define SPORTS_SERVICE_TABLEDEF_CAROUSEL_ID (2)
#define SPORTS_SERVICE_METADATA0_CAROUSEL_ID (3)
#define SPORTS_SERVICE_METADATA1_CAROUSEL_ID (4)

// General Access Unit Definitions
#define SPORTS_SERVICE_PVN_BITLEN (4)
#define SPORTS_SERVICE_CAROUSEL_BITLEN (3)
#define SPORTS_SERVICE_RFU1_BITLEN (1)
#define SPORTS_SERVICE_CFGVER_BITLEN (8)
#define SPORTS_SERVICE_CRC_BYTELEN (4)
// size of common part of data header stripped off in AU pre-qualification
#define SPORTS_SERVICE_TRIM_BITLEN ( (SPORTS_SERVICE_PVN_BITLEN+SPORTS_SERVICE_CAROUSEL_BITLEN+ \
		SPORTS_SERVICE_RFU1_BITLEN+SPORTS_SERVICE_CFGVER_BITLEN) + (8*SPORTS_SERVICE_CRC_BYTELEN))

#define SPORTS_SERVICE_CTSIZE_BITLEN (4)
#define SPORTS_SERVICE_AUAID_BITLEN (16)
#define SPORTS_SERVICE_PRESENCE_FLAG_BITLEN (1)

COMPILE_TIME_ASSERT(SPORTS_SERVICE_MAX_AU_GROUP_SIZE <=
        SPORTS_SERVICE_MAX_AU_IMPLEMENTATION_LIMIT,
        AU_GROUP_SIZE_exceeds_implimentation_limit );

// Table Def preamble macros
#define SPORTS_SERVICE_TABLEID_BITLEN (10)
#define SPORTS_SERVICE_TABVER_BITLEN (8)
#define SPORTS_SERVICE_TABCLASS_BITLEN (4)
#define SPORTS_SERVICE_TABSTUFF_BITLEN (2)
#define SPORTS_SERVICE_LBNO_BITLEN (6)

// Label Info field sizes
#define SPORTS_SERVICE_LABEL_LABELID_BITLEN (8)
#define SPORTS_SERVICE_LABEL_DTYPE_BITLEN (1)
#define SPORTS_SERVICE_LABEL_LBTYPE_BITLEN (8)
#define SPORTS_SERVICE_LABEL_DMOD_BITLEN (3)
#define SPORTS_SERVICE_LABEL_LPRIORITY_BITLEN (3)
#define SPORTS_SERVICE_LABEL_LBSIZE_BITLEN (12)
#define SPORTS_SERVICE_LABEL_EXTCNT_BITLEN (8)

// Sports Instance data field sizes (CarId=3/4)
#define SPORTS_SERVICE_AFID_BITLEN (10)
#define SPORTS_SERVICE_EPOCH_BITLEN (16)
#define SPORTS_SERVICE_SEASON_BITLEN (1)
#define SPORTS_SERVICE_TABLEID_BITLEN (10)
#define SPORTS_SERVICE_TABVER_BITLEN (8)
#define SPORTS_SERVICE_OVERRIDE_LBID_BITLEN (10)
#define SPORTS_SERVICE_OVERRIDE_LBSIZE_BITLEN (5)
#define SPORTS_SERVICE_ENTRYNO_BITLEN (8)

// Sports config table field sizes (CarId = 0)
#define SPORTS_SERVICE_SPORTCOUNT_BITLEN (8)
#define SPORTS_SERVICE_SPORTID_BITLEN (8)
#define SPORTS_SERVICE_TABLENO_BITLEN (4)

// Sports Affiliation table field sizes (CarId = 1)
#define SPORTS_SERVICE_ADVER_BITLEN (8)
#define SPORTS_SERVICE_ADNO_BITLEN (10)
#define SPORTS_SERVICE_AFID_BITLEN (10)
#define SPORTS_SERVICE_GDREF_BITLEN (7)

// CRC Calculation
#define SPORTS_SERVICE_CRC_INVERSION_VALUE (0xFFFFFFFFL)

// Label verification.

// Special integer/text labels must always specify dtype of integer.
#define SS_LABEL_DATATYPE_MIXED SS_LABEL_DATATYPE_INTEGER
#define SS_LABEL_SUPPORT_DMOD_NO (0)
#define SS_LABEL_SUPPORT_DMOD_YES (1)

/**************/
 /** TYPEDEFS **/
/**************/

typedef struct au_info_struct
{
    UN8 un8Pvn;
    UN8 un8CarouselId;
    UN8 un8CfgVer;
    UN8 un8CtSizePresent;
    UN8 un8CtSize;
    UN8 un8AdVer;
    UN8 un8Season;
    UN16 un16AuTot;
    UN16 un16AuCt;
    UN16 un16AfId;
    UN16 un16Epoch;
    UN16 un16AuId;
    UN32 un32Crc;

    size_t tOffset;
    OSAL_BUFFER_HDL hPayload;
    size_t tPayloadStartSizeBits;
} AU_INFO_STRUCT;

typedef struct au_group_struct
{
    UN16 un16AuId;
    UN16 un16Count;
    UN32 un32AuMask;
    UN8 un8CfgVer;
    UN8 un8AdVer;
    UN8 un8Season;
    UN16 un16AfId;
    UN16 un16Epoch;
    UN32 un32Crc;

    AU_INFO_STRUCT asAu[SPORTS_SERVICE_MAX_AU_GROUP_SIZE];
} AU_GROUP_STRUCT;

typedef struct sports_service_highband_object_struct
{
    // Central Sports Data Service handle
    SPORTS_SERVICE_OBJECT hSportsDataService;

    // The lookup table used to store the collection of table definition headers
    // and references to label info linked lists
    SPORTS_SERVICE_HIGHBAND_TDEF_INFO_STRUCT *hTableDefs;

    // ISO 3309 CRC32 Handler
    OSAL_OBJECT_HDL hCRC;

    SPORTS_SERVICE_DATA_INSTANCE_STRUCT *hSportsInstanceData;

    // We count on SMSO_hCreate to zero out memory.
    AU_GROUP_STRUCT asAuGroup[CAROUSEL_ID_COUNT];

    UN8 aun8LabelOverrides[SPORTS_SERVICE_HIGHBAND_LABEL_ID_LOOKUP_SIZE];

} SPORTS_SERVICE_HIGHBAND_OBJECT_STRUCT;

typedef struct tref_info_struct
{
    // Identify which row in the table set we belong to
    UN8 un8RowIndex;

    // Priority of the label in the tdef.
    UN8 un8LPriority;

    // Byte offset from start of AU to the referenced table
    UN16 un16ByteOffset;

    // Used to derive name of primary table
    UN32 un32TdefKey;

    // Column where the TREF should be stored
    UN8 un8LabelId;

    // Owner table (Primary) Instance Id
    TABLE_ID tParentInstanceId;

    // The instance ID of the secondary table
    TABLE_ID tChildInstanceId;

    // Row ID in primary table is used to ensure no
    // data clash with BitOffset and real instance id
    N64 n64PrimaryRowId;

} TREF_INFO_STRUCT;

typedef struct au_tref_mapping_struct
{
    size_t tIntervalEnd;
    size_t tOffset;
} AU_TREF_MAPPING_STRUCT;

typedef BOOLEAN (*SPORTS_SERVICE_AU_VALIDATE_FUNC)(
        AU_GROUP_STRUCT *psAuGroup,
        AU_INFO_STRUCT *psAuInfo );

typedef struct label_verification_struct
{
    UN8 un8DType;
    UN8 un8DMod;
    UN16 un16LbSize;
} LABEL_VERIFICATION_STRUCT;

typedef struct override_forward_helper
{
    SPORTS_SERVICE_HIGHBAND_OBJECT_STRUCT *psHighbandObj;
    BOOLEAN bOk;
    TABLE_ID tInstId;
} OVERRIDE_FORWARD_HELPER_STRUCT;

  /****************/
 /** PROTOTYPES **/
/****************/
static SPORTS_SERVICE_INTERFACE_OBJECT hInit (
    SPORTS_SERVICE_OBJECT hSportsDataService,
    SMS_OBJECT hParent
        );

static void vUnInit (
    SPORTS_SERVICE_INTERFACE_OBJECT hInterface
        );

static BOOLEAN bClearAllTableDefs(
		SPORTS_SERVICE_HIGHBAND_OBJECT_STRUCT *psHighbandObj
		);

static DATASERVICE_ERROR_CODE_ENUM eProcessMessage (
    SPORTS_SERVICE_INTERFACE_OBJECT hInterface,
    OSAL_BUFFER_HDL *phPayload
        );

static BOOLEAN bUnsafeAddTdef (
        SPORTS_SERVICE_INTERFACE_OBJECT hInterface,
        SPORTS_SERVICE_TDEF_ADD_STRUCT *psTdefAdd
        );

/* Object Private Prototypes */

static DATASERVICE_ERROR_CODE_ENUM eProcessConfigAu(
        SPORTS_SERVICE_HIGHBAND_OBJECT_STRUCT *psHighbandObj,
        AU_GROUP_STRUCT *psAuGroup,
        AU_INFO_STRUCT *psAuInfo
        );

static DATASERVICE_ERROR_CODE_ENUM eProcessAffiliateAu(
        SPORTS_SERVICE_HIGHBAND_OBJECT_STRUCT *psHighbandObj,
        AU_GROUP_STRUCT *psAuGroup,
        AU_INFO_STRUCT *psAuInfo
        );

static DATASERVICE_ERROR_CODE_ENUM eProcessDataAu(
        SPORTS_SERVICE_HIGHBAND_OBJECT_STRUCT *psHighbandObj,
        AU_GROUP_STRUCT *psAuGroup,
        AU_INFO_STRUCT *psAuInfo
        );

static DATASERVICE_ERROR_CODE_ENUM eProcessTableDefAu(
        SPORTS_SERVICE_HIGHBAND_OBJECT_STRUCT *psHighbandObj,
        AU_GROUP_STRUCT *psAuGroup,
        AU_INFO_STRUCT *psAuInfo
        );

static DATASERVICE_ERROR_CODE_ENUM eProcessAu(
        AU_GROUP_STRUCT *psAuGroup,
        AU_INFO_STRUCT *psAuInfo,
        SPORTS_SERVICE_AU_VALIDATE_FUNC tbIsAuValid
        );

static BOOLEAN bVerifyAu (
        SPORTS_SERVICE_HIGHBAND_OBJECT_STRUCT *psHighbandObj,
        AU_INFO_STRUCT *psAuInfo
	    );

static BOOLEAN bStartAuTransaction (
        AU_INFO_STRUCT *psAuInfo,
        AU_GROUP_STRUCT *psAuGroup
        );

static void vEndAuTransaction( AU_GROUP_STRUCT *psAuGroup );

static BOOLEAN bIsAuGroupComplete(
        AU_GROUP_STRUCT *psAuGroup,
        size_t tMaxPayloadSize );

static BOOLEAN bParseAuGroupInfo( AU_INFO_STRUCT *psAuInfo );

static BOOLEAN bIsConfigAuValid(
        AU_GROUP_STRUCT *psAuGroup,
        AU_INFO_STRUCT *psAuInfo
        );

static BOOLEAN bIsAffiliateAuValid(
        AU_GROUP_STRUCT *psAuGroup,
        AU_INFO_STRUCT *psAuInfo
        );

static BOOLEAN bIsDataAuValid(
        AU_GROUP_STRUCT *psAuGroup,
        AU_INFO_STRUCT *psAuInfo
        );

static void vPrintAuInfo(
        AU_INFO_STRUCT *psAuInfo,
        UN32 un32Level
        );

static void vPrintAuGroup(
        AU_GROUP_STRUCT *psAuGroup,
        UN32 un32Level
        );

static BOOLEAN bGetTrefAdjustment(
        AU_TREF_MAPPING_STRUCT *psTrefMap,
        UN32 un32MapEntryCount,
        size_t tTrefOffset,
        size_t *ptResult
        );

static BOOLEAN bCalcAuGroupCrc(
        SPORTS_SERVICE_HIGHBAND_OBJECT_STRUCT *psHighbandObj,
        AU_GROUP_STRUCT *psAuGroup
        );

static BOOLEAN bParseConfigAu(
        SPORTS_SERVICE_HIGHBAND_OBJECT_STRUCT *psHighbandObj,
        AU_INFO_STRUCT *psAuInfo
        );

static BOOLEAN bParseAffiliationAu(
        SPORTS_SERVICE_HIGHBAND_OBJECT_STRUCT *psHighbandObj,
        AU_INFO_STRUCT *psAuInfo
        );

static BOOLEAN bParseLabelInfoToObject(
		OSAL_BUFFER_HDL hPayload,
		SPORTS_SERVICE_HIGHBAND_LABEL_INFO_STRUCT *psLabelInfo
		);

static BOOLEAN bParseDataInstance(
        SPORTS_SERVICE_HIGHBAND_OBJECT_STRUCT *psHighbandObj,
        AU_GROUP_STRUCT *psAuGroup,
        AU_TREF_MAPPING_STRUCT *psTrefMap,
        size_t *ptBitsConsumed,
        UN8 *pun8ClassId,
        TABLE_ID *ptInstanceId,
        BOOLEAN bIsPrimaryTable
        );

static BOOLEAN bParseTableHeader(
        SPORTS_SERVICE_HIGHBAND_OBJECT_STRUCT *psHighbandObj,
        OSAL_BUFFER_HDL hPayload,
        SPORTS_SERVICE_DATA_INSTANCE_STRUCT *psDataInstanceInfo,
        size_t *ptBitsConsumed
        );

static BOOLEAN bParseLabelOverrides(
        SPORTS_SERVICE_HIGHBAND_OBJECT_STRUCT *psHighbandObj,
        OSAL_BUFFER_HDL hPayload,
        size_t *ptBitsConsumed
        );

static BOOLEAN bParseTeamLabel(
        SPORTS_SERVICE_HIGHBAND_OBJECT_STRUCT *psHighbandObj,
        OSAL_BUFFER_HDL hPayload,
        SPORTS_SERVICE_TABLE_TRANSACTION_STRUCT *psTrans,
        UN16 un16LabelSize,
        UN8 un8ColumnIndex,
        UN8 un8LPriority,
        UN8 un8LType,
        size_t *ptBitsConsumed
        );

static BOOLEAN bParseLabel(
        SPORTS_SERVICE_HIGHBAND_OBJECT_STRUCT *psHighbandObj,
        OSAL_BUFFER_HDL hPayload,
        SPORTS_SERVICE_TABLE_TRANSACTION_STRUCT *psTrans,
        UN16 un16LabelSize,
        UN8 un8ColumnIndex,
        UN8 un8LPriority,
        UN8 un8LType,
        UN8 un8Dtype,
        BOOLEAN bIgnoreLabelValue,
        size_t *ptBitsConsumed
        );

static BOOLEAN bParseTref(
        SPORTS_SERVICE_HIGHBAND_OBJECT_STRUCT *psHighbandObj,
        OSAL_BUFFER_HDL hPayload,
        OSAL_OBJECT_HDL *phTrefList,
        SPORTS_SERVICE_DATA_INSTANCE_STRUCT *psDataInstanceInfo,
        UN8 un8RowIndex,
        UN16 un16LabelSize,
        UN8 un8ColumnIndex,
        UN8 un8LPriority,
        size_t *ptBitsConsumed
        );

static BOOLEAN bForwardLabelOverrides(
        SPORTS_SERVICE_HIGHBAND_OBJECT_STRUCT *psHighbandObj,
        SPORTS_SERVICE_DATA_INSTANCE_STRUCT *psDataInfo,
        SPORTS_SERVICE_HIGHBAND_TDEF_INFO_STRUCT *hMyTdef
        );

static BOOLEAN bUnsafeForwardOverrideHandler (
        SPORTS_SERVICE_HIGHBAND_LABEL_INFO_STRUCT *psLabelInfo,
        OVERRIDE_FORWARD_HELPER_STRUCT *psHelper
        );

#if(0)
static void DEBUG_DumpList (
		SPORTS_SERVICE_HIGHBAND_OBJECT_STRUCT *psObj
		);

static void DEBUG_DumpBuffer(
		OSAL_BUFFER_HDL hPayload
			);

static void DEBUG_DumpTableDef(SPORTS_SERVICE_HIGHBAND_OBJECT_STRUCT *psObj,
		UN16 un16TableId
			);
#endif

/* Message Processors */
static BOOLEAN bProcessConfigAuGroup(
        SPORTS_SERVICE_HIGHBAND_OBJECT_STRUCT *psHighbandObj,
        AU_GROUP_STRUCT *psAuGroup
        );

static BOOLEAN bProcessTableDefAuGroup(
		SPORTS_SERVICE_HIGHBAND_OBJECT_STRUCT *psObj,
		AU_GROUP_STRUCT *psAuGroup
		);

static BOOLEAN bProcessAffiliationAuGroup(
        SPORTS_SERVICE_HIGHBAND_OBJECT_STRUCT *psHighbandObj,
        AU_GROUP_STRUCT *psAuGroup
        );

static BOOLEAN bProcessDataAuGroup(
        SPORTS_SERVICE_HIGHBAND_OBJECT_STRUCT *psObj,
        AU_GROUP_STRUCT *psAuGroup
        );

static N16 _n16CompareByteOffsets(
        void *pvObj1,
        void *pvObj2
        );

static BOOLEAN _bLLIteratorUpdateRowId (
        void *pvData,
        void *pvArg
        );

  /***************/
 /** VARIABLES **/
/***************/

const SPORTS_SERVICE_PLUGIN_INTERFACE_STRUCT GsSportsServiceIntf =
{
    /*.tDSI = */SPORTS_SERVICE_DSI,
    /*.tOTABufferByteSize = */SPORTS_SERVICE_BUFFER_BYTESIZE,
    /*.hInit = */hInit,
    /*.vUnInit = */vUnInit,
    /*.eProcessMessage = */eProcessMessage,
    /*.bUnsafeAddTdef = */bUnsafeAddTdef
};

// Per spec most other text sizes derive from the home team score text.
#define SS_HOME_TEAM_SCORE_TEXT_SYMBOL_COUNT (32)

const LABEL_VERIFICATION_STRUCT GsLabelVerificationTable[] =
{
/*0x00*/ {SS_LABEL_DATATYPE_MIXED, SS_LABEL_SUPPORT_DMOD_NO, SPORTS_SERVICE_HIGHBAND_MAX_TNAME_SYMBOL_COUNT},
/*0x01*/ {SS_LABEL_DATATYPE_MIXED, SS_LABEL_SUPPORT_DMOD_NO, SPORTS_SERVICE_HIGHBAND_MAX_TNAME_SYMBOL_COUNT},
/*0x02*/ {SS_LABEL_DATATYPE_INTEGER, SS_LABEL_SUPPORT_DMOD_NO, 8},
/*0x03*/ {SS_LABEL_DATATYPE_TEXT, SS_LABEL_SUPPORT_DMOD_NO, 8},
/*0x04*/ {SS_LABEL_DATATYPE_INTEGER, SS_LABEL_SUPPORT_DMOD_NO, 16},
/*0x05*/ {SS_LABEL_DATATYPE_INTEGER, SS_LABEL_SUPPORT_DMOD_NO, 16},
/*0x06*/ {SS_LABEL_DATATYPE_INTEGER, SS_LABEL_SUPPORT_DMOD_YES, 16},
/*0x07*/ {SS_LABEL_DATATYPE_INTEGER, SS_LABEL_SUPPORT_DMOD_YES, 16},
/*0x08*/ {SS_LABEL_DATATYPE_INTEGER, SS_LABEL_SUPPORT_DMOD_YES, 32},
/*0x09*/ {SS_LABEL_DATATYPE_TEXT, SS_LABEL_SUPPORT_DMOD_NO, SS_HOME_TEAM_SCORE_TEXT_SYMBOL_COUNT},
/*0x0a*/ {SS_LABEL_DATATYPE_INTEGER, SS_LABEL_SUPPORT_DMOD_YES, 32},
/*0x0b*/ {SS_LABEL_DATATYPE_INTEGER, SS_LABEL_SUPPORT_DMOD_YES, 32},
/*0x0c*/ {SS_LABEL_DATATYPE_INTEGER, SS_LABEL_SUPPORT_DMOD_YES, 32},
/*0x0d*/ {SS_LABEL_DATATYPE_TEXT, SS_LABEL_SUPPORT_DMOD_NO, SS_HOME_TEAM_SCORE_TEXT_SYMBOL_COUNT},
/*0x0e*/ {SS_LABEL_DATATYPE_INTEGER, SS_LABEL_SUPPORT_DMOD_YES, 16},
/*0x0f*/ {SS_LABEL_DATATYPE_INTEGER, SS_LABEL_SUPPORT_DMOD_YES, 16},
/*0x10*/ {SS_LABEL_DATATYPE_INTEGER, SS_LABEL_SUPPORT_DMOD_YES, 32},
/*0x11*/ {SS_LABEL_DATATYPE_TEXT, SS_LABEL_SUPPORT_DMOD_NO, SS_HOME_TEAM_SCORE_TEXT_SYMBOL_COUNT},
/*0x12*/ {SS_LABEL_DATATYPE_INTEGER, SS_LABEL_SUPPORT_DMOD_YES, 32},
/*0x13*/ {SS_LABEL_DATATYPE_INTEGER, SS_LABEL_SUPPORT_DMOD_YES, 32},
/*0x14*/ {SS_LABEL_DATATYPE_INTEGER, SS_LABEL_SUPPORT_DMOD_YES, 32},
/*0x15*/ {SS_LABEL_DATATYPE_TEXT, SS_LABEL_SUPPORT_DMOD_NO, SS_HOME_TEAM_SCORE_TEXT_SYMBOL_COUNT},
/*0x16*/ {SS_LABEL_DATATYPE_INTEGER, SS_LABEL_SUPPORT_DMOD_NO, 16},
/*0x17*/ {SS_LABEL_DATATYPE_INTEGER, SS_LABEL_SUPPORT_DMOD_NO, 16},
/*0x18*/ {SS_LABEL_DATATYPE_INTEGER, SS_LABEL_SUPPORT_DMOD_NO, 16},
/*0x19*/ {SS_LABEL_DATATYPE_TEXT, SS_LABEL_SUPPORT_DMOD_NO, 128},
/*0x1a*/ {SS_LABEL_DATATYPE_TEXT, SS_LABEL_SUPPORT_DMOD_NO, 6},
/*0x1b*/ {SS_LABEL_DATATYPE_INTEGER, SS_LABEL_SUPPORT_DMOD_NO, 8},
/*0x1c*/ {SS_LABEL_DATATYPE_MIXED, SS_LABEL_SUPPORT_DMOD_NO, SPORTS_SERVICE_HIGHBAND_MAX_TNAME_SYMBOL_COUNT},
/*0x1d*/ {SS_LABEL_DATATYPE_TEXT, SS_LABEL_SUPPORT_DMOD_NO, 48},
/*0x1e*/ {SS_LABEL_DATATYPE_TEXT, SS_LABEL_SUPPORT_DMOD_NO, 256},
/*0x1f*/ {SS_LABEL_DATATYPE_INTEGER, SS_LABEL_SUPPORT_DMOD_YES, 32},
/*0x20*/ {SS_LABEL_DATATYPE_INTEGER, SS_LABEL_SUPPORT_DMOD_YES, 32},
/*0x21*/ {SS_LABEL_DATATYPE_INTEGER, SS_LABEL_SUPPORT_DMOD_YES, 32},
/*0x22*/ {SS_LABEL_DATATYPE_TEXT, SS_LABEL_SUPPORT_DMOD_NO, SS_HOME_TEAM_SCORE_TEXT_SYMBOL_COUNT},
/*0x23*/ {SS_LABEL_DATATYPE_INTEGER, SS_LABEL_SUPPORT_DMOD_NO, 8},
/*0x24*/ {SS_LABEL_DATATYPE_INTEGER, SS_LABEL_SUPPORT_DMOD_NO, 8},
/*0x25*/ {SS_LABEL_DATATYPE_INTEGER, SS_LABEL_SUPPORT_DMOD_NO, 16},
};
  /**********************/
 /** INLINE FUNCTIONS **/
/**********************/

#endif	// _SPORTS_SERVICE_HIGHBAND_H_
