/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*            Licensed Materials - Property of Sirius XM Radio, Inc.          */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * PRIVATE HEADER
 *
 ******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/

#ifndef _MAPS_PVN1_H_
#define _MAPS_PVN1_H_

  /**************/
 /** INCLUDES **/
/**************/

#include "standard.h"
#include "osal.h"

#include <stdio.h>

#include "sms_api.h"
#include "sql_interface_obj.h"
#include "maps_interface.h"
#include "rfd_interface_obj.h"

  /***************/
 /** CONSTANTS **/
/***************/

// Object Debugging:
// If DEBUG_OBJECT isn't defined
// define it locally
#ifndef DEBUG_OBJECT
#define DEBUG_OBJECT 0
#endif

// Include the debug definitions
// header, which depends on how
// DEBUG_OBJECT is defined
#include "sms_debug_definitions.h"

// PVN 1 - Definitions
#define MAPS1_OBJECT_NAME "Maps1"

#define MAPS1_DSI   (405)

// The protocol version supported
// by SMS for this interface
#define MAPS1_PVN   ((PVN)1)

// As defined in rfd_receiver_config.h
#define MAPS1_RFD_CLIENT_ID (7)

// As defined in _maps_pvn1.h
#define MAPS1_MFM_CLIENT_ID (0)

// This service uses 2 RFD clients
#define MAPS1_NUM_RFD_CLIENTS (2)

// Protocol related definitions

// Maps Image File Header definitions
#define MAPS1_IMAGE_RESERVED_BITLEN (4)
#define MAPS1_IMAGE_UCOUNT_BITLEN   (4)
#define MAPS1_IMAGE_HOR_BITLEN      (16)
#define MAPS1_IMAGE_OFFSET_BITLEN   (24)

// Constant which defines the bit width of the maximum file update
// version, which is then passed to RFD_INTERFACE_hConnect.
// This is used in determining the applicability of incoming
// RFD updates.
// Note: 99 => 0110 0011 =  7 bits
#define MAPS1_MAX_VERSION_BITLEN  (7)

#define MAPS1_MAX_XML_BLOCK_BUF   (512)
#define MAPS1_MAX_XML_VALUE_BUF   (30)

#define MAPS1_RFD_METADATA_FILE_NAME_BYTELEN (11)
#define MAPS1_RFD_METADATA_FILE_VERSION_BYTELEN (3)

#define MAPS1_IMAGE_FILES_IN_UPDATE_MAX (4)

/* Max message sizes (from SX-9845-0271)
*   Section 3.3 says:
*       The Map Image Update Data Service uses multi-packet
*       SDTP Access Units to convey the data carousels.
*       The maximum size of any Access Unit is 5120 bytes.
        Each Access Unit contains data from only one carousel type.
*
*   In addition, let's make sure we have enough memory for
*   a few queued messages -- let's say 4
*/
#define MAPS1_MAX_AU_BYTESIZE (5120)
#define MAPS1_NUM_CAROUSELS   (2)
#define MAPS1_OTA_BUFFER_BYTESIZE ( \
    MAPS1_MAX_AU_BYTESIZE * \
    MAPS1_NUM_CAROUSELS * 4)

/* Max RFD Update File header size:
*
*   Reserved - 4bits (For future use)
*   UCOUNT - 4bits (MAPS1_MAX_AU_BYTESIZE)
*   HOR - 16bits (Horizontal Resolution of Image)
*   OFFSET - 24bits (File Offset to Image Update)
*   HOR and OFFSET repeats UCOUNT + 1 times
*/
#define MAPS1_MAX_RFD_UPDATE_HEADER_BYTESIZE (21)

#define MAPS1_SHARED_BUFFER_LENGTH (128)
  /**************/
 /** TYPEDEFS **/
/**************/
typedef struct maps1_rfd_image_data_struct
{
    UN16 un16HorResolution;

    UN32 un32Offset;

} MAPS1_RFD_IMAGE_DATA_STRUCT;

typedef struct maps1_mfm_ctrl_struct
{
    // Handle to the top-level maps service
    MAPS_SERVICE_OBJECT hMapsService;

    // MFM handle
    MULTIFILE_MANAGER_HANDLE hMFM;

    // Flag indicates if we've
    // connected to RFD (in order to
    // get our handles) yet
    BOOLEAN bRFDConnected;

    // The block pool used to process RFD files
    OSAL_OBJECT_HDL hBlockPool;

    // The buffer used to access the block pool
    OSAL_BUFFER_HDL hBuffer;

    // Buffer used to provide payloads to MFM 
    // as a flat memory space
    UN8 aun8PayloadBuffer[MAPS1_MAX_AU_BYTESIZE];

} MAPS1_MFM_CTRL_STRUCT;

typedef struct maps1_object_struct
{
    // Structure used to manage mfm connection
    MAPS1_MFM_CTRL_STRUCT *psMFMCtrl;

    char acBuffer[MAPS1_SHARED_BUFFER_LENGTH];
} MAPS1_OBJECT_STRUCT;

  /************/
 /** MACROS **/
/************/

  /****************/
 /** PROTOTYPES **/
/****************/

// Public interface APIs

static MAPS_INTERFACE_OBJECT hInit(
    MAPS_SERVICE_OBJECT hService,
    SMS_OBJECT hParent
        );

static void vUnInit(
    MAPS_INTERFACE_OBJECT hInterface
        );

static BOOLEAN bProcessMessage(
    MAPS_INTERFACE_OBJECT hInterface,
    OSAL_BUFFER_HDL *phPayload
        );

/* Object Private Prototypes */
static void vUninitObject(
    MAPS1_OBJECT_STRUCT *psObj
        );

static BOOLEAN bMFMInit(
    MAPS1_OBJECT_STRUCT *psObj,
    MAPS_SERVICE_OBJECT hMapsService
        );

static MAPS1_MFM_CTRL_STRUCT *psCreateMFMCtrl (
    MAPS1_OBJECT_STRUCT *psObj
        );

static void vDestroyMFMCtrl (
    MAPS1_MFM_CTRL_STRUCT *psMFMCtrl
        );

// MFM Callbacks

static BOOL bIsSubnameInService (
    TCHAR *pacSubname,
    UINT32 *pun32AppStoredFileIdentifyVersionToPtr,
    void *pvCallbackArg
        );

static BOOL bMFMFileTransfer(
    const TCHAR acFilePath[],
    RFD_CONSUMER_FILE_INFO_STRUCT *psRFDMetadataFileInfo,
    void *pvCallbackArg
        );

static BOOLEAN bParseRFDMetadataName(
    const TCHAR pacRFDMetadataName[],
    char *pacName,
    size_t tNameSize,
    UINT32 *pun32Version
        );

static BOOL bMFMParseIdentity (
    const TCHAR pacRFDMetadataName[],
    MFM_FILE_IDENTITY_STRUCT *psFileIdentityInfo,
    void *pvCallbackArg
        );

static BOOL bMFMSortBegin (
    void *pvCallbackArg
        );

static void vMFMSortEnd (
    void *pvCallbackArg
        );

static int iMFMSortUpdates (
    const TCHAR *pacSubNameA,
    const TCHAR *pacSubNameB,
    void *pvCallbackArg
        );

static BOOLEAN bParseRFDFileHeader (
    FILE *psRFDFile,
    MAPS1_RFD_IMAGE_DATA_STRUCT *pasRFDImageDataStruct,
    void *pvCallbackArg
        );

static BOOLEAN bExtractImageFiles (
    MAPS1_MFM_CTRL_STRUCT *psMFMCtrl,
    FILE *psRFDFile,
    const MAPS1_RFD_IMAGE_DATA_STRUCT *pasRFDImageDataStruct,
    const char *pacSubname,
    UN32 un32UpdateVersion
        );


  /***************/
 /** VARIABLES **/
/***************/

const MAPS_PLUGIN_INTERFACE_STRUCT GsMapsPluginIntf =
{
    /*.tOTABufferByteSize = */ MAPS1_OTA_BUFFER_BYTESIZE,
    /*.tDSI = */ MAPS1_DSI,
    /*.tMaxVersionBitlen = */MAPS1_MAX_VERSION_BITLEN,
    /*.hInit = */ hInit,
    /*.vUnInit = */ vUnInit,
    /*.bProcessMessage = */ bProcessMessage,
};

  /**********************/
  /** INLINE FUNCTIONS **/
/**********************/

#endif /* _MAPS_PVN1_H_ */
