/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
*
*
*
*
*
*	GLOBAL HEADER
*******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/
#ifndef SDTP_H_
#define SDTP_H_

  /**************/
 /** INCLUDES **/
/**************/

#include "osal.h"

  /**********************/
 /** GLOBAL CONSTANTS **/
/**********************/

  /*********************/
 /** GLOBAL TYPEDEFS **/
/*********************/
typedef UN16    PSI;       // 10-bits
#define INVALID_PSI ((PSI)UN16_MAX)

typedef void * SDTP_HDL;
#define SDTP_INVALID_HDL ((SDTP_HDL)0)

typedef void (*SDTP_LOGGING_CALLBACK) (
    const char *pacMessage,
    ...
        );

  /*****************************/
 /** GLOBAL STRUCT TEMPLATES **/
/*****************************/

  /****************************/
 /** GLOBAL UNION TEMPLATES **/
/****************************/

  /**********************/
 /** GLOBAL VARIABLES **/
/**********************/

  /*******************/
 /** GLOBAL MACROS **/
/*******************/

  /***********************/
 /** GLOBAL PROTOTYPES **/
/***********************/

SDTP_HDL SDTP_hConnect (
    SMS_OBJECT hParent
        );

void SDTP_vDisconnect (
    SDTP_HDL hSDTP
        );

OSAL_BUFFER_HDL SDTP_hReAssemble (
    SDTP_HDL hSDTP,
    OSAL_BUFFER_HDL *phPayload
        );

void SDTP_vResetConnection (
    SDTP_HDL hSDTP
        );

void SDTP_vPrintToLog (
    SDTP_HDL hSDTP,
    SDTP_LOGGING_CALLBACK vPrintLog
        );

  /*****************************/
 /** GLOBAL INLINE FUNCTIONS **/
/*****************************/

#endif	// SDTP_H_
