/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * This is the RADIO_DATA_SERVICE header file.
 *
 ******************************************************************************/
#ifndef RADIO_DATA_SERVICE_H_
#define RADIO_DATA_SERVICE_H_

#include "standard.h"
#include "osal.h"

#include "sms_api.h"
#include "radio.h"

  /**********************/
 /** GLOBAL CONSTANTS **/
/**********************/

  /*********************/
 /** GLOBAL TYPEDEFS **/
/*********************/

  /*****************************/
 /** GLOBAL STRUCT TEMPLATES **/
/*****************************/

  /****************************/
 /** GLOBAL UNION TEMPLATES **/
/****************************/

  /**********************/
 /** GLOBAL VARIABLES **/
/**********************/

  /*******************/
 /** GLOBAL MACROS **/
/*******************/

  /***********************/
 /** GLOBAL PROTOTYPES **/
/***********************/

/* Object Friend Prototypes */

SMSAPI_RETURN_CODE_ENUM RADIO_eDataServiceInit (
    RADIO_PRIVATE_DATA_OBJECT hRadioData,
    DATASERVICE_MGR_OBJECT hManager,
    DATASERVICE_ID tDataId
        );

SMSAPI_RETURN_CODE_ENUM RADIO_eDataServiceDestroy (
    DATASERVICE_MGR_OBJECT hManager
        );

SMSAPI_RETURN_CODE_ENUM RADIO_eDataServiceManageStream (
    RADIO_PRIVATE_DATA_OBJECT hDataCtrl,
    DATASERVICE_MGR_OBJECT hManager,
    DATASERVICE_DMI_CONFIG_STRUCT const *psDMIsToConfigure,
    size_t tNumDMIsToConfigure
        );

SMSAPI_RETURN_CODE_ENUM RADIO_eDataServiceControlFlow (
    RADIO_PRIVATE_DATA_OBJECT hDataCtrl,
    DATASERVICE_MGR_OBJECT hManager,
    DSI tDSI,
    BOOLEAN bEnableData
        );

SMSAPI_RETURN_CODE_ENUM RADIO_eDataServiceStop (
    RADIO_PRIVATE_DATA_OBJECT hDataCtrl,
    DATASERVICE_MGR_OBJECT hManager
        );

SMSAPI_RETURN_CODE_ENUM RADIO_eDataServiceAddDSI (
    RADIO_PRIVATE_DATA_OBJECT hDataCtrl,
    DATASERVICE_MGR_OBJECT hManager,
    DSI tServiceDSI,
    size_t tSuggestedOTABufferByteSize,
    BOOLEAN bEnableAllDMIs
        );

SMSAPI_RETURN_CODE_ENUM RADIO_eDataServiceRemoveDSI (
    RADIO_PRIVATE_DATA_OBJECT hDataCtrl,
    DATASERVICE_MGR_OBJECT hManager,
    DSI tDSI
        );

SMSAPI_RETURN_CODE_ENUM RADIO_eDataServiceGetDMIsCount (
    DATASERVICE_MGR_OBJECT hManager,
    DSI tDSI,
    UN8 *pun8DMIsCount
        );

SMSAPI_RETURN_CODE_ENUM RADIO_eDataServiceGetDMIs (
    DATASERVICE_MGR_OBJECT hManager,
    DSI tDSI,
    SXM_DMI *ptDMIs,
    UN8 un8DMIsSize
        );

RADIO_PRIVATE_DATA_OBJECT RADIO_hDataServiceInitialize(
    SMS_OBJECT hDataCtrl,
    STI_HDL hSTI
        );

void RADIO_vDataServiceUninitialize (
    RADIO_PRIVATE_DATA_OBJECT hRadioDataCtrl
        );

BOOLEAN RADIO_bDataServiceEventHandler(
    RADIO_PRIVATE_DATA_OBJECT hRadioDataCtrl,
    SMS_EVENT_TYPE_ENUM eEventType,
    const void *pvEventData
        );

#endif /* RADIO_DATA_SERVICE_H_ */
