/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 *  This module contains the SONG ID implementation for the
 *  Sirius Module Services (SMS)
 *
 ******************************************************************************/
#include "standard.h"
#include "osal.h"

// Include things I need from SMS
#include "sms_api.h"
#include "music_obj.h"

#include "cme.h"
#include "cdo_obj.h"

// Include SXI SONG ID module headers
#include "sxi_song_id.h"
#include "_sxi_song_id.h"

/*****************************************************************************
                             PUBLIC FUNCTIONS
*****************************************************************************/

/*****************************************************************************
*
*   bParseSongId
*
* Parse provided data to populate the MUSIC object. This function uses
* the data to populate the MUSIC CDO
* structure.
*
* Inputs:
*
*   hCDO - A handle to a valid CDO to populate.
*   pvData - The pointer to the source data
*
* Outputs:
*
*   BOOLEAN     FALSE if the provided SXI ID was invalid, or parsed but no
*               update was performed because it had not changed from what this
*               CDO's previous SXI ID was. -or-
*               TRUE if the parser successfully parsed the SXI ID and it
*               caused and update (or change) in the CDO's content.
*
*****************************************************************************/
static BOOLEAN bParse (
    CD_OBJECT hCDO,
    const void *pvData
        )
{
    BOOLEAN bUpdated = FALSE;

    // Verify this CDO's type is MUSIC. Anything other than MUSIC
    // makes no sense for this SXI ID.
    if(CDO.eType(hCDO) == CDO_MUSIC)
    {
        MUSIC_OBJECT_STRUCT *psObj;

        // Go get MUSIC CDO structure from provided CDO
        psObj = (MUSIC_OBJECT_STRUCT *)CDO_pvContentData(hCDO);
        if(psObj != NULL)
        {
            // Process SXI ID...

            // Update content if it exists, otherwise if not...create it
            bUpdated = CME_bUpdateContent(
                    hCDO, CID_SXI_SONG_ID, pvData, &psObj->hSongId
                        );
        }
    }

    return bUpdated;
}
