/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 *  This module contains the SONG ID implementation for the
 *  Sirius Module Services (SMS)
 *
 ******************************************************************************/

#include "standard.h"
#include "osal.h"

// Include things I need from SMS
#include "sms_api.h"
#include "music_obj.h"

#include "cme.h"
#include "cdo_obj.h"

// Include SXI ID module headers
#include "sxi_id.h"
#include "_sxi_id.h"

/*****************************************************************************
                             PUBLIC FUNCTIONS
*****************************************************************************/

/*****************************************************************************
                             PRIVATE FUNCTIONS
*****************************************************************************/

/*****************************************************************************
*
*   bInitializeTypes
*
*****************************************************************************/
static BOOLEAN bInitializeTypes ( void )
{
    size_t tIndex;

    // Initialize list of ID types and their associated parsers.
    // These help look-ups of incoming IDs to quickly locate the
    // appropriate ID parser.

    // Create a CID for each SXI ID type we support and map its interface
    for(tIndex = 0; tIndex < SXI_ID_NUM_TYPES; tIndex++)
    {
        // Create a type CID from the provided SXI ID
        gsSxiIdCtrl.asTypeMap[tIndex].hId =
            CID_hCreateConst(
                CID_SXI_ID,
                &gasSxiIdIntf[tIndex].un32Id
                    );
        if(gsSxiIdCtrl.asTypeMap[tIndex].hId == CID_INVALID_OBJECT)
        {
            // Error! Something went wrong.
            vUnInitializeTypes();
            return FALSE;
        }

        // Assign interface structure to this type
        gsSxiIdCtrl.asTypeMap[tIndex].psIntf = &gasSxiIdIntf[tIndex];

        // Apply this CID and parser to the CDO of this type
        CDO_vAssignParser(
            gsSxiIdCtrl.asTypeMap[tIndex].psIntf->eType,
            gsSxiIdCtrl.asTypeMap[tIndex].hId,
            (CDO_ID_PARSER)gsSxiIdCtrl.asTypeMap[tIndex].psIntf->bParser
                );
    }

    return TRUE;
}

/*****************************************************************************
*
*   vUnInitializeTypes
*
*****************************************************************************/
static void vUnInitializeTypes ( void )
{
    size_t tIndex;

    // Remove each known SXI ID type,
    // preventing further parsing based on SXI ID.
    for(tIndex = 0; tIndex < SXI_ID_NUM_TYPES; tIndex++)
    {
        // Re-initialize this CID and parser to the CDO of this type's default.
        if(gsSxiIdCtrl.asTypeMap[tIndex].psIntf != NULL)
        {
            CDO_vAssignParser(
                gsSxiIdCtrl.asTypeMap[tIndex].psIntf->eType,
                CID_INVALID_OBJECT,
                CDO_INVALID_ID_PARSER
                    );
        }

        // Does a CID exist?
        if(gsSxiIdCtrl.asTypeMap[tIndex].hId != CID_INVALID_OBJECT)
        {
            // Destroy CID
            CID_vDestroy(gsSxiIdCtrl.asTypeMap[tIndex].hId);
            gsSxiIdCtrl.asTypeMap[tIndex].hId = CID_INVALID_OBJECT;
        }

        // Re-initialize this entry's interface
        gsSxiIdCtrl.asTypeMap[tIndex].psIntf = NULL;
    }

    return;
}





