/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * This is the SPORTS header file.
 *
 ******************************************************************************/

#ifndef SPORTS_H_
#define SPORTS_H_

#include "sms_api.h"

#include "sports_obj.h"

  /**********************/
 /** GLOBAL VARIABLES **/
/**********************/

// Structure for mapping known PIDs to Sports names and ids
// See RX120 - Appendix B
static const SPORT_STRUCT gasSport[] =
{
    // eType, pacId, pacName
    {SPORTS_FOOTBALL, "FB", "Football"},

    {SPORTS_HOCKEY, "H", "Hockey"},

    {SPORTS_BASKETBALL, "BB", "Basketball"},

    {SPORTS_BASEBALL, "BSB", "Baseball"},

    {SPORTS_SOCCER, "S", "Soccer"},

    {SPORTS_AUTO_RACING, "AUTO", "Auto Racing"},

    {SPORTS_OTHER, "OTHER", "Other Sports"}
};

  /*******************/
 /** GLOBAL MACROS **/
/*******************/

// PID Sports Map size
#define NUM_SPORTS (sizeof(gasSport) / sizeof(SPORT_STRUCT))

#endif /* SPORTS_H_ */
