/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * PRIVATE HEADER
 *
 ******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/
#ifndef _SXI_ID_H_
#define _SXI_ID_H_

  /**************/
 /** INCLUDES **/
/**************/

#include "standard.h"
#include "osal.h"

#include "sxiapi.h"
#include "cid_obj.h"
#include "cid_integer.h"

  /***************/
 /** CONSTANTS **/
/***************/

// Object Debugging:
// If DEBUG_OBJECT isn't defined
// define it locally
#ifndef DEBUG_OBJECT
#define DEBUG_OBJECT 0
#endif

// Include the debug definitions
// header, which depends on how
// DEBUG_OBJECT is defined
#include "sms_debug_definitions.h"

/* Object name prefix for objects */
#define SXI_ID_OBJECT_NAME "SXI_SPORTS_ID"

#define SPORT_ID_OBJECT_NAME "SPORT"

  /**************/
 /** TYPEDEFS **/
/**************/

typedef struct sxi_id_league_iterator_struct
{
    UN8 un8Id;
    SPORTS_ENUM eSport;
    BOOLEAN bFound;

} SXI_ID_LEAGUE_ITERATOR_STRUCT;

  /************/
 /** MACROS **/
/************/

  /****************/
 /** PROTOTYPES **/
/****************/

/* Object Public Prototypes */

/* Object Private Prototypes */
static BOOLEAN bInitialize ( void );

static void vUnInitialize ( void );

static BOOLEAN bParse (
    CD_OBJECT hCDO,
    const void *pvData
        );

static BOOLEAN bInitializeSports( void );

static BOOLEAN bParseLeague(
    CD_OBJECT hCDO,
    const SPORTS_PARSE_STRUCT *psSports
        );

static BOOLEAN bParseTeams(
    CD_OBJECT hCDO,
    const SPORTS_PARSE_STRUCT *psSports
        );

static BOOLEAN bLeagueIterator(
    LEAGUE_OBJECT hLeague,
    void *pvContentIteratorCallbackArg
        );

  /***************/
 /** VARIABLES **/
/***************/

// Global structure defining the CID Interface for SXI SPORTS ID
// Note: The only method implemented directly by the SXI SPORTS ID module is
// the bParser(). All the other methods do not exist (NULL)
// Also note that the SXI SPORTS ID object data is a integer and thus we borrow
// the CID INTEGER interface APIs.
const CID_TYPE_INTERFACE_STRUCT GsSxiSportsId =
{
    // CID type
    /*.eType = */    CID_SXI_SPORTS_ID,

    // Init/Unit methods
    /*.bInitialize = */bInitialize,
    /*.vUnInitialize = */vUnInitialize,

    // CID Input Data Parse Method
    /*.bParse = */bParse,

    // Object Data Methods
    /*.sObjData = */{

        // Minimum Expected Size (if known, otherwise 0)
        /*.tMinSize = */MAX_INTEGER_AS_CHARS,
        // Object Data Create/Destroy Methods
        /*.pvCreate = */CIDINT_pvCreate,
        /*.vDestroy = */CIDINT_vDestroy,

        // Object Data Manipulation Methods
        /*.pvDuplicate = */CIDINT_pvDuplicate,
        /*.bModify = */CIDINT_bModify,
        /*.bCopy = */CIDINT_bCopy,
        /*.tSize = */CIDINT_tSize,
        /*.n16Compare = */CIDINT_n16Compare,

        // Object Data I/O Methods
        /*.n32FWrite = */CIDINT_n32FWrite,
        /*.n32FWriteToMemory = */CIDINT_n32FWriteToMemory,
        /*.pvRead = */CIDINT_pvRead,
        /*.bReadFromMemory = */CIDINT_bReadFromMemory,
        /*.n32FPrintf = */CIDINT_n32FPrintf,
        /*.n32GetValue = */CIDINT_n32GetValue
    }

};

  /**********************/
 /** INLINE FUNCTIONS **/
/**********************/

#endif	// _SXI_ID_H_
