/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * PRIVATE HEADER
 *
 ******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/
#ifndef _SXI_SONG_ID_H_
#define _SXI_SONG_ID_H_

  /**************/
 /** INCLUDES **/
/**************/

#include "standard.h"
#include "osal.h"

#include "sxiapi.h"
#include "cid_obj.h"
#include "cid_integer.h"

  /***************/
 /** CONSTANTS **/
/***************/

// Object Debugging:
// If DEBUG_OBJECT isn't defined
// define it locally
#ifndef DEBUG_OBJECT
#define DEBUG_OBJECT 0
#endif

// Include the debug definitions
// header, which depends on how
// DEBUG_OBJECT is defined
#include "sms_debug_definitions.h"

  /**************/
 /** TYPEDEFS **/
/**************/

  /************/
 /** MACROS **/
/************/

  /****************/
 /** PROTOTYPES **/
/****************/

/* Object Public Prototypes */

/* Object Private Prototypes */

static BOOLEAN bParse (
    CD_OBJECT hCDO,
    const void *pvData
        );

  /***************/
 /** VARIABLES **/
/***************/

// Global structure defining the CID Interface for SXI SONG ID
// Note: The only method implemented directly by the SXI SONG ID module is
// the bParser(). All the other methods do not exist (NULL)
// Also note that the SXI SONG ID object data is a integer and thus we borrow
// the CID INTEGER interface APIs.
const CID_TYPE_INTERFACE_STRUCT GsSxiSongId =
{
    // CID type
    /*.eType = */CID_SXI_SONG_ID,

    // Init/Unit methods
    /*.bInitialize = */NULL,
    /*.vUnInitialize = */NULL,

    // CID Input Data Parse Method
    /*.bParse = */bParse,

    // Object Data Methods
    /*.sObjData = */{

        // Minimum Expected Size (if known, otherwise 0)
        /*.tMinSize = */MAX_INTEGER_AS_CHARS,
        // Object Data Create/Destroy Methods
        /*.pvCreate = */CIDINT_pvCreate,
        /*.vDestroy = */CIDINT_vDestroy,

        // Object Data Manipulation Methods
        /*.pvDuplicate = */CIDINT_pvDuplicate,
        /*.bModify = */CIDINT_bModify,
        /*.bCopy = */CIDINT_bCopy,
        /*.tSize = */CIDINT_tSize,
        /*.n16Compare = */CIDINT_n16Compare,

        // Object Data I/O Methods
        /*.n32FWrite = */CIDINT_n32FWrite,
        /*.n32FWriteToMemory = */CIDINT_n32FWriteToMemory,
        /*.pvRead = */CIDINT_pvRead,
        /*.bReadFromMemory = */CIDINT_bReadFromMemory,
        /*.n32FPrintf = */CIDINT_n32FPrintf,
        /*.n32GetValue = */CIDINT_n32GetValue
    }

};

  /**********************/
 /** INLINE FUNCTIONS **/
/**********************/

#endif	// _SXI_SONG_ID_H_
