/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * PRIVATE HEADER
 *
 ******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/
#ifndef _SXI_MARKET_ID_H_
#define _SXI_MARKET_ID_H_

  /**************/
 /** INCLUDES **/
/**************/

#include "standard.h"
#include "osal.h"

#include "sxiapi.h"
#include "cid_obj.h"
#include "cid_integer.h"
#include "markets.h"

  /***************/
 /** CONSTANTS **/
/***************/

// Object Debugging:
// If DEBUG_OBJECT isn't defined
// define it locally
#ifndef DEBUG_OBJECT
#define DEBUG_OBJECT 0
#endif

// Include the debug definitions
// header, which depends on how
// DEBUG_OBJECT is defined
#include "sms_debug_definitions.h"

/* Object name prefix for objects */
#define SXI_ID_OBJECT_NAME "SXI_ID"

#define MARKET_ID_OBJECT_NAME "MKT"
#define SPORT_ID_OBJECT_NAME "SPORT"

  /**************/
 /** TYPEDEFS **/
/**************/

  /************/
 /** MACROS **/
/************/
#define SXIAPI_SXI_ID_MAX_LENGTH    sizeof(UN32)

  /****************/
 /** PROTOTYPES **/
/****************/

/* Object Public Prototypes */

/* Object Private Prototypes */
static BOOLEAN bInitialize ( void );

static void vUnInitialize ( void );

static BOOLEAN bParse (
    CD_OBJECT hCDO,
    const void *pvData
        );

static void vDestroyDiscoveredMarket (
    const MARKET_STRUCT *psMarket
        );

static BOOLEAN bInitializeReports ( void );

static void vUnInitializeReports ( void );

static CID_OBJECT hCreateCID (
    CD_OBJECT hCDO,
    CID_POOL hCidPool,
    UN32 un32MarketId
        );

  /***************/
 /** VARIABLES **/
/***************/

// SXI ID global structure which maintains pid type maps
// as well as any discovered markets.
typedef struct sxi_market_id_ctrl_struct
{
    // A dynamic market list used to hold discovered markets
    OSAL_OBJECT_HDL hDiscoveredMarkets;
} SXI_MARKET_ID_CTRL_STRUCT;

// Local global structure containing all pid type mapping.
static SXI_MARKET_ID_CTRL_STRUCT gsSxiMarketIdCtrl = {
        OSAL_INVALID_OBJECT_HDL
    };

// Global structure defining the CID Interface for SXI MARKET ID
// Note: The only method implemented directly by the SXI MARKET ID module is
// the bParser(). All the other methods do not exist (NULL)
// Also note that the SXI MARKET ID object data is a integer and thus we borrow
// the CID INTEGER interface APIs.
const CID_TYPE_INTERFACE_STRUCT GsSxiMarketId =
{
    // CID type
    /*.eType = */CID_SXI_MARKET_ID,

    // Init/Unit methods
    /*.bInitialize = */bInitialize,
    /*.vUnInitialize = */vUnInitialize,

    // CID Input Data Parse Method
    /*.bParse = */bParse,

    // Object Data Methods
    /*.sObjData = */{

        // Minimum Expected Size (if known, otherwise 0)
        /*.tMinSize = */MAX_INTEGER_AS_CHARS,
        // Object Data Create/Destroy Methods
        /*.pvCreate = */CIDINT_pvCreate,
        /*.vDestroy = */CIDINT_vDestroy,

        // Object Data Manipulation Methods
        /*.pvDuplicate = */CIDINT_pvDuplicate,
        /*.bModify = */CIDINT_bModify,
        /*.bCopy = */CIDINT_bCopy,
        /*.tSize = */CIDINT_tSize,
        /*.n16Compare = */CIDINT_n16Compare,

        // Object Data I/O Methods
        /*.n32FWrite = */CIDINT_n32FWrite,
        /*.n32FWriteToMemory = */CIDINT_n32FWriteToMemory,
        /*.pvRead = */CIDINT_pvRead,
        /*.bReadFromMemory = */CIDINT_bReadFromMemory,
        /*.n32FPrintf = */CIDINT_n32FPrintf,
        /*.n32GetValue = */CIDINT_n32GetValue
    }

};



  /**********************/
 /** INLINE FUNCTIONS **/
/**********************/

#endif	// _SXI_MARKET_ID_H_
