/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
*
* DESCRIPTION
*
* PRIVATE HEADER
*
******************************************************************************/

/*********************************/
/** PREVENT REDUNDANT INCLUSION **/
/*********************************/
#ifndef _SXI_GMD_H_
#define _SXI_GMD_H_

/**************/
/** INCLUDES **/
/**************/

#include "standard.h"
#include "osal.h"

#include "sxiapi.h"
#include "sti_api.h"

#include "tag_obj.h"
#include "presets_obj.h"

/***************/
/** CONSTANTS **/
/***************/

// Object Debugging:
// If DEBUG_OBJECT isn't defined
// define it locally
#ifndef DEBUG_OBJECT
#define DEBUG_OBJECT 0
#endif

// Include the debug definitions
// header, which depends on how
// DEBUG_OBJECT is defined
#include "sms_debug_definitions.h"

/* Object name prefix for objects */
#define OBJECT_NAME "SXI_GMD"

#define TABLE_VERSION_TAG "TableVersion"

/* Featured Favorites tag */
#define PRESETS_FF_TAG           "FeaturedFavorites"
/* Featured Favorites Table Complete Tag Name */
#define PRESETS_FEATURED_TABLE_COMPLETE       "FFTableComplete"
/* Featured Favorites Table Version Tag */
#define PRESETS_FEATURED_TABLE_VERSION        "TableVersion"

/* Service IDs offset in Featured Favorites Bank Arrangements */
#define SXI_GMD_FF_SID_OFFSET   (2)

/**************/
/** TYPEDEFS **/
/**************/

typedef struct sxi_gmd_type_struct
{
    BOOLEAN bUpdating;
    UN16 un16Expected;
    N32 n32Version;

} SXI_GMD_TYPE_STRUCT;

typedef struct sxi_gmd_managed_version_struct
{
    SXI_GMD_TYPE_STRUCT sInfo;
    BOOLEAN bVersionValid;  // whether version value is valid

} SXI_GMD_MANAGED_VERSION_STRUCT;

typedef struct sxi_gmd_ff_struct
{
    SXI_GMD_MANAGED_VERSION_STRUCT sManaged;
    BOOLEAN bComplete;          // complete flag
    BOOLEAN bCompleteFlagValid; // whether complete flag value is valid

} SXI_GMD_FF_STRUCT;

typedef struct sxi_gmd_lists_struct
{
    // the LL which contains memory blocks that are available for re-use
    OSAL_OBJECT_HDL hAvailBlocks;

    // the LL which contains memory blocks that are in use
    OSAL_OBJECT_HDL hInUseBlocks;

    // the LL which contains LLs available for re-use
    OSAL_OBJECT_HDL hAvailLists;

    // the LL which contains LLs in use
    OSAL_OBJECT_HDL hInUseLists;

} SXI_GMD_LISTS_STRUCT;

typedef struct sxi_gmd_struct
{
    // Global Metadata

    // the currently enable GMIs.
    // Access to this mask must be in an exclusive section
    UN64 un64ExtMetadataGMIMask;

    // Array used to send the GMIs
    UN8 un8ExtMetadataEmiCnt;
    SXIAPI_METADATA_IDENTIFIER atExtMetadataGID
        [SXIAPI_MAX_EXT_METADATA_EMI_COUNT];

    // Handling Markets
    SXI_GMD_MANAGED_VERSION_STRUCT sMarkets;

    // Handling Teams
    SXI_GMD_TYPE_STRUCT sTeams;

    // Handling Leagues
    SXI_GMD_TYPE_STRUCT sLeagues;

    // Handling Featured Favorities
    SXI_GMD_FF_STRUCT sFF;

    // avail/in-use lists
    SXI_GMD_LISTS_STRUCT *psLists;

    // ExtMetadataMonCmd control mutex
    OSAL_OBJECT_HDL hCmdMutex;

    // Temporary CID's for working
    CID_OBJECT hWorkingLeagueId;
    CID_OBJECT hWorkingTeamId;

} SXI_GMD_STRUCT;

typedef TAG_OBJECT (*GET_TAG_FUNCTION) (void);

typedef struct sxi_gmd_bank_iterator_struct
{
    PRESETS_OBJECT hPresets;
    FAVORITES_RECEIVER_INFO_STRUCT *psInfo;
    SXI_GMD_FF_STRUCT *psFF;
    BOOLEAN bNeedUpdate;

} SXI_GMD_BANK_ITERATOR_STRUCT;

/************/
/** MACROS **/
/************/

#define SXI_GMD_MARKETS \
    (SXIAPI_GMI_MASK_CITY_ID | \
    SXIAPI_GMI_MASK_CITY_ABBREV | \
    SXIAPI_GMI_MASK_CITY_NAME)

#define SXI_GMD_LEAGUES \
    (SXIAPI_GMI_MASK_LEAGUE_ID | \
    SXIAPI_GMI_MASK_LEAGUE_SHORT_NAME | \
    SXIAPI_GMI_MASK_LEAGUE_LONG_NAME | \
    SXIAPI_GMI_MASK_LEAGUE_TYPE | \
    SXIAPI_GMI_MASK_LEAGUE_SF_ENABLED | \
    SXIAPI_GMI_MASK_LEAGUE_SF_TIERS)

#define SXI_GMD_TEAMS \
    ( SXIAPI_GMI_MASK_TEAM_ID | \
    SXIAPI_GMI_MASK_TEAM_ABBREV | \
    SXIAPI_GMI_MASK_TEAM_NAME | \
    SXIAPI_GMI_MASK_TEAM_NICKNAME | \
    SXIAPI_GMI_MASK_TEAM_LEAGUE_IDS | \
    SXIAPI_GMI_MASK_TEAM_TIERS)

#define SXI_GMD_FF \
    (SXIAPI_GMI_MASK_FF_BANK_ORDER | \
    SXIAPI_GMI_MASK_FF_BANK_ID | \
    SXIAPI_GMI_MASK_FF_BANK_SEQ | \
    SXIAPI_GMI_MASK_FF_BANK_TTL_SHORT | \
    SXIAPI_GMI_MASK_FF_BANK_TTL_LONG | \
    SXIAPI_GMI_MASK_FF_BANK_TTL_VERBOSE | \
    SXIAPI_GMI_MASK_FF_BANK_DESCR | \
    SXIAPI_GMI_MASK_FF_BANK_PURPOSE | \
    SXIAPI_GMI_MASK_FF_BANK_ARR_1 | \
    SXIAPI_GMI_MASK_FF_BANK_ARR_2 | \
    SXIAPI_GMI_MASK_FF_BANK_ARR_3 | \
    SXIAPI_GMI_MASK_FF_BANK_ARR_4)

/****************/
/** PROTOTYPES **/
/****************/

/* Object Private Prototypes */

static void vUpdateTrafficWeather(
    SXI_GMD_STRUCT *psGMD,
    STI_HDL hControlCxn,
    SXIAPI_EXT_METADATA_TRAFFIC_STRUCT *psTrafficStruct,
    UN8 un8Fields
    );

static BOOLEAN bUpdateTWData (
    SXIAPI_EXT_METADATA_MARKET_STRUCT *psTrafficStruct
    );

static BOOLEAN bIsMoreTWDataNeeded (
    UN16 un16Expected
    );

static void vUpdateSports(
    SXI_GMD_STRUCT *psGMD,
    STI_HDL hControlCxn,
    SXIAPI_EXT_METADATA_SPORTS_STRUCT *psSportsStruct,
    UN8 un8Fields
    );

static void vUpdateLeagues(
    SXI_GMD_STRUCT *psGMD,
    STI_HDL hControlCxn,
    SXIAPI_EXT_METADATA_SPORTS_STRUCT *psSportsStruct,
    UN8 un8Fields
    );

static BOOLEAN bIsMoreLeaguesDataNeeded (
    N32 n32Version,
    UN16 un16Expected,
    UN16 *pun16Rxd
    );

static void vUpdateTeams(
    SXI_GMD_STRUCT *psGMD,
    STI_HDL hControlCxn,
    SXIAPI_EXT_METADATA_SPORTS_STRUCT *psSportsStruct,
    UN8 un8Fields
    );

static BOOLEAN bIsMoreTeamsDataNeeded (
    N32 n32Version,
    UN16 un16Expected,
    UN16 *pun16Rxd
    );

static void vUpdateFeaturedFavorites(
    DECODER_OBJECT hDecoder,
    SXI_GMD_STRUCT *psGMD,
    STI_HDL hControlCxn,
    SXIAPI_EXT_METADATA_FEATURED_FAVORITES_STRUCT *psFeaturedFavorites,
    UN8 un8Fields
    );

static BOOLEAN bInitFFTable (
    PRESETS_OBJECT hPresets,
    SXI_GMD_FF_STRUCT *psFF,
    UN16 un16Version
    );

static BOOLEAN bContinueFFTable(
    PRESETS_OBJECT hPresets,
    SXI_GMD_FF_STRUCT *psFF
    );

static BOOLEAN bUpdateFFData (
    SXIAPI_EXT_METADATA_BANK_STRUCT *psBank,
    PRESETS_OBJECT hPresets,
    FAVORITES_RECEIVER_INFO_STRUCT *psInfo
    );

static BOOLEAN bIsMoreFFDataNeeded (
    PRESETS_OBJECT hPresets,
    SXI_GMD_FF_STRUCT *psFF
    );

static void vUpdateSongTagURL(
    SXIAPI_EXT_METADATA_SONG_TAG_SERVICE_STRUCT const *psTagServiceStruct
    );

static TAG_OBJECT hGetMarketsVersionTag(void);

static TAG_OBJECT hGetFFVersionTag(void);

static BOOLEAN bIsNewTable(
    GET_TAG_FUNCTION hGetTagFunc,
    SXI_GMD_MANAGED_VERSION_STRUCT *psManaged,
    UN16 un16Version
    );

static void vSaveTableVersion(
    GET_TAG_FUNCTION hGetTagFunc,
    SXI_GMD_MANAGED_VERSION_STRUCT *psManaged,
    UN16 un16Version
    );

static BOOLEAN bIsFFTableComplete(
    SXI_GMD_FF_STRUCT *psFF
    );

static BOOLEAN bSetFFTableComplete(
    SXI_GMD_FF_STRUCT *psFF,
    BOOLEAN bComplete
    );

static TAG_OBJECT hFFGetSubTag(
    const char *pacName
    );

static BOOLEAN bGetNextLeague(
    SXI_GMD_LISTS_STRUCT const *psLists,
    OSAL_OBJECT_HDL hLL,
    SXIAPI_EXT_METADATA_SPORTS_LEAGUE_STRUCT *psLeague
    );

static BOOLEAN bGetNextTeam(
    SXI_GMD_LISTS_STRUCT const *psLists,
    OSAL_OBJECT_HDL hLL,
    SXIAPI_EXT_METADATA_SPORTS_TEAM_STRUCT  * psTeam
    );

static BOOLEAN bGetNextMarket(
    SXI_GMD_LISTS_STRUCT const *psLists,
    OSAL_OBJECT_HDL hLL,
    SXIAPI_EXT_METADATA_MARKET_STRUCT  * psMarket
    );

static void vProcessFeaturedBankState(
    PRESETS_OBJECT hPresets,
    PRESET_BAND_STATE_ENUM eState,
    FAVORITES_BAND_CAPACITY tCapacity,
    SXIAPI_EXT_METADATA_BANK_STRUCT const *psBank,
    PRESET_BAND_SEARCH_FOR_TAG_ITERATOR_STRUCT *psIteratorStruct
    );

static void vFreeStruct(
    SXI_GMD_LISTS_STRUCT const *psLists,
    SXIAPI_EXT_METADATA_STRUCT *psStruct
    );

static void vFreeLL(
    SXI_GMD_LISTS_STRUCT const *psLists,
    OSAL_OBJECT_HDL hLL
    );

static SXIAPI_EXT_METADATA_STRUCT *psGetStruct(
    SXI_GMD_LISTS_STRUCT const *psLists
    );

static OSAL_OBJECT_HDL hGetLL(
    SXI_GMD_LISTS_STRUCT const *psLists
    );

static void vFreeLLs(
    OSAL_OBJECT_HDL hLL
    );

static BOOLEAN bHandleMultipleGlobalTWEntries(
    SXI_GMD_LISTS_STRUCT const *psLists,
    OSAL_BUFFER_HDL hPayload,
    SXIAPI_EXT_METADATA_TRAFFIC_STRUCT *psStruct
    );

static BOOLEAN bHandleMultipleGlobalTEAMEntries(
    SXI_GMD_LISTS_STRUCT const *psLists,
    OSAL_BUFFER_HDL hPayload,
    SXIAPI_EXT_METADATA_SPORTS_STRUCT *psStruct
    );

static BOOLEAN bHandleMultipleGlobalLEAGUEEntries(
    SXI_GMD_LISTS_STRUCT const *psLists,
    OSAL_BUFFER_HDL hPayload,
    SXIAPI_EXT_METADATA_SPORTS_STRUCT *psStruct
    );

static BOOLEAN bHandleMultipleGlobalFFEntries(
    SXI_GMD_LISTS_STRUCT const *psLists,
    OSAL_BUFFER_HDL hPayload,
    SXIAPI_EXT_METADATA_FEATURED_FAVORITES_STRUCT *psStruct
    );

static BOOLEAN bDecodeTeam(
    OSAL_BUFFER_HDL hBuffer,
    UN8 *pun8Fields,
    SXIAPI_EXT_METADATA_SPORTS_TEAM_STRUCT *psTeam
    );

static BOOLEAN bDecodeLeague(
    OSAL_BUFFER_HDL hBuffer,
    UN8 *pun8Fields,
    SXIAPI_EXT_METADATA_SPORTS_LEAGUE_STRUCT *psLeague
    );

static BOOLEAN bDecodeMarket(
    OSAL_BUFFER_HDL hBuffer,
    UN8 *pun8Fields,
    SXIAPI_EXT_METADATA_MARKET_STRUCT *psMarket
    );

static BOOLEAN bDecodeBank (
    OSAL_BUFFER_HDL hBuffer,
    UN8 *pun8Fields,
    SXIAPI_EXT_METADATA_BANK_STRUCT *psBank
    );

static BOOLEAN bDecodeArrangement (
    OSAL_BUFFER_HDL hBuffer,
    UN16 *pun16Arrangement,
    UN8 *pun8Count
    );

static BOOLEAN bConfigureGlobalExtendedMetaDataMonitor (
    SXI_GMD_STRUCT *psGMD,
    STI_HDL hControlCxn,
    UN64 un64Mask,
    BOOLEAN bEnable
    );

static N16 n16CompareHandles(
    void *pvArg1,
    void *pvArg2
    );

static BOOLEAN bProcessBankIterator (
    SXIAPI_EXT_METADATA_STRUCT *psStruct,
    SXI_GMD_BANK_ITERATOR_STRUCT *psData
        );

static BOOLEAN bSxiDataDestroyIterator (
    SXIAPI_EXT_METADATA_STRUCT *psStruct,
    SXI_GMD_LISTS_STRUCT *psLists
        );

/***************/
/** VARIABLES **/
/***************/

typedef struct sxi_gmi_map_struct
{
    UN64 un64Mask;
    SXIAPI_GMI_ENUM eGMI;

} SXI_GMI_MAP_STRUCT;

const SXI_GMI_MAP_STRUCT gasGMIMap[SXIAPI_MAX_EXT_METADATA_GMI_COUNT] =
{
    {SXIAPI_GMI_MASK_CHAN_TABLE_VER, SXIAPI_GMI_CH_TBL_VER},
    {SXIAPI_GMI_MASK_CHAN_COUNT, SXIAPI_GMI_CH_CHAN_CNT},
    {SXIAPI_GMI_MASK_ITUNES_URL, SXIAPI_GMI_TG_ITUNES_URL},
    {SXIAPI_GMI_MASK_TRAFFIC_TABLE_VER, SXIAPI_GMI_TW_TBL_VER},
    {SXIAPI_GMI_MASK_CITY_COUNT, SXIAPI_GMI_TW_CITY_CNT},
    {SXIAPI_GMI_MASK_CITY_ID, SXIAPI_GMI_TW_CITY_ID},
    {SXIAPI_GMI_MASK_CITY_ABBREV, SXIAPI_GMI_TW_CITY_ABBREV},
    {SXIAPI_GMI_MASK_CITY_NAME, SXIAPI_GMI_TW_CITY_NAME},
    {SXIAPI_GMI_MASK_TEAM_TABLE_VER, SXIAPI_GMI_SP_TEAM_TABLE_VER},
    {SXIAPI_GMI_MASK_TEAM_CNT, SXIAPI_GMI_SP_TEAM_CNT},
    {SXIAPI_GMI_MASK_TEAM_ID, SXIAPI_GMI_SP_TEAM_ID},
    {SXIAPI_GMI_MASK_TEAM_ABBREV, SXIAPI_GMI_SP_TEAM_ABBREV},
    {SXIAPI_GMI_MASK_TEAM_NAME, SXIAPI_GMI_SP_TEAM_NAME},
    {SXIAPI_GMI_MASK_TEAM_NICKNAME, SXIAPI_GMI_SP_TEAM_NICKNAME},
    {SXIAPI_GMI_MASK_TEAM_LEAGUE_IDS, SXIAPI_GMI_SP_TEAM_LEAGUE_IDS},
    {SXIAPI_GMI_MASK_TEAM_TIERS, SXIAPI_GMI_SP_TEAM_TIERS},
    {SXIAPI_GMI_MASK_LEAGUE_TABLE_VER, SXIAPI_GMI_SP_LEAGUE_TABLE_VER},
    {SXIAPI_GMI_MASK_LEAGUE_CNT, SXIAPI_GMI_SP_LEAGUE_CNT},
    {SXIAPI_GMI_MASK_LEAGUE_ID, SXIAPI_GMI_SP_LEAGUE_ID},
    {SXIAPI_GMI_MASK_LEAGUE_SHORT_NAME, SXIAPI_GMI_SP_LEAGUE_SHORT_NAME},
    {SXIAPI_GMI_MASK_LEAGUE_LONG_NAME, SXIAPI_GMI_SP_LEAGUE_LONG_NAME},
    {SXIAPI_GMI_MASK_LEAGUE_TYPE, SXIAPI_GMI_SP_LEAGUE_TYPE},
    {SXIAPI_GMI_MASK_LEAGUE_SF_ENABLED, SXIAPI_GMI_SP_LEAGUE_SF_ENABLED},
    {SXIAPI_GMI_MASK_LEAGUE_SF_TIERS, SXIAPI_GMI_SP_LEAGUE_SF_TIERS},
    {SXIAPI_GMI_MASK_FF_TABLE_VER, SXIAPI_GMI_FF_BANK_TBL_VER},
    {SXIAPI_GMI_MASK_FF_CNT, SXIAPI_GMI_FF_BANK_CNT},
    {SXIAPI_GMI_MASK_FF_BANK_ORDER, SXIAPI_GMI_FF_BANK_ORDER},
    {SXIAPI_GMI_MASK_FF_BANK_ID, SXIAPI_GMI_FF_BANK_ID},
    {SXIAPI_GMI_MASK_FF_BANK_SEQ, SXIAPI_GMI_FF_BANK_SEQ},
    {SXIAPI_GMI_MASK_FF_BANK_TTL_SHORT, SXIAPI_GMI_FF_BANK_TTL_SHORT},
    {SXIAPI_GMI_MASK_FF_BANK_TTL_LONG, SXIAPI_GMI_FF_BANK_TTL_LONG},
    {SXIAPI_GMI_MASK_FF_BANK_TTL_VERBOSE, SXIAPI_GMI_FF_BANK_TTL_VERBOSE},
    {SXIAPI_GMI_MASK_FF_BANK_DESCR, SXIAPI_GMI_FF_BANK_DESCR},
    {SXIAPI_GMI_MASK_FF_BANK_PURPOSE, SXIAPI_GMI_FF_BANK_PURPOSE},
    {SXIAPI_GMI_MASK_FF_BANK_ARR_1, SXIAPI_GMI_FF_BANK_ARR_1},
    {SXIAPI_GMI_MASK_FF_BANK_ARR_2, SXIAPI_GMI_FF_BANK_ARR_2},
    {SXIAPI_GMI_MASK_FF_BANK_ARR_3, SXIAPI_GMI_FF_BANK_ARR_3},
    {SXIAPI_GMI_MASK_FF_BANK_ARR_4, SXIAPI_GMI_FF_BANK_ARR_4}
};

/**********************/
/** INLINE FUNCTIONS **/
/**********************/

#endif	// _SXI_GMD_H_
