/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/*                           Proprietary & Confidential                       */
/******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/
#ifndef SXIAPI_H_
#define SXIAPI_H_

  /**************/
 /** INCLUDES **/
/**************/

#include "standard.h"

#include "sti_api.h"

  /**********************/
 /** GLOBAL CONSTANTS **/
/**********************/

//****************************************************************************
//
//                 SXI UART Link Layer Op Code Definitions
//
//****************************************************************************

// SXI UART Link Layer opcodes
#define SXIAPI_MESSOP_UARTLINKSTARTCMD              0x0000
#define SXIAPI_MESSOP_UARTLINKSTARTRESP             0x0001
#define SXIAPI_MESSOP_UARTLINKERR                   0x0002
#define SXIAPI_MESSOP_UARTLINKKEEPALIVE             0x0003
#define SXIAPI_MESSOP_UARTLINKSTATSCMD              0x0004
#define SXIAPI_MESSOP_UARTLINKSTATSRESP             0x0005

//****************************************************************************
//
//                 SXI Command & Control Op Code Definitions
//
//****************************************************************************

// SXI Command & Control OpCode Flag Masks
#define SXIAPI_MESSOP_CMD                       0x0000
#define SXIAPI_MESSOP_RESP                      0xC000
#define SXIAPI_MESSOP_IND                       0x8000
#define SXIAPI_MESSOP_CFM                       0x4000

#define SXIAPI_MESSOP_TYPE_MASK                 0x3FFF

// SXI Command and Control opcodes
#define SXIAPI_MESSOP_MODULECFG                 0x0020
#define SXIAPI_MESSOP_PWRMODE                   0x0021
#define SXIAPI_MESSOP_TIME                      0x0060

#define SXIAPI_MESSOP_STATUS                    0x00A0
#define SXIAPI_MESSOP_FEATUREMON                0x00A1
#define SXIAPI_MESSOP_PINGCMD                   0x00E0

#define SXIAPI_MESSOP_EXT_METADATAMON           0x00A2

#define SXIAPI_MESSOP_EVENT                     0x0080
#define SXIAPI_MESSOP_DISPLAY                   0x00C0
#define SXIAPI_MESSOP_SUBSTATUS                 0x00C1

#define SXIAPI_MESSOP_CATINFO                   0x0201

#define SXIAPI_MESSOP_CHANBROWSE                0x0200
#define SXIAPI_MESSOP_CHANSELECT                0x0280
#define SXIAPI_MESSOP_CHANINFO                  0x0281
#define SXIAPI_MESSOP_CHAN_ATTR_CFG             0x0282
#define SXIAPI_MESSOP_CHANSELECT_CFG            0x0283
#define SXIAPI_MESSOP_CHAN_ATTR_LIST            0x0284
#define SXIAPI_MESSOP_METADATA                  0x0300
#define SXIAPI_MESSOP_CHAN_METADATA             0x0301
#define SXIAPI_MESSOP_GLOBAL_METADATA           0x0302
#define SXIAPI_MESSOP_LA_METADATA               0x0303
#define SXIAPI_MESSOP_SEEK_MON                  0x0304

#define SXIAPI_MESSOP_IRPLAYBACK_CONTROL        0x0402
#define SXIAPI_MESSOP_IRPLAYBACK_METADATA       0x0403
#define SXIAPI_MESSOP_IRRECORD                  0x0404
#define SXIAPI_MESSOP_IRRECORD_METADATA         0x0405

#define SXIAPI_MESSOP_BULLETIN_MON              0x0420
#define SXIAPI_MESSOP_FLASH                     0x0421
#define SXIAPI_MESSOP_CONTENT_BUFFERED          0x0422

#define SXIAPI_MESSOP_AUDIOMUTE                 0x0100
#define SXIAPI_MESSOP_AUDIOVOL                  0x0101
#define SXIAPI_MESSOP_AUDIOTONAL                0x0102
#define SXIAPI_MESSOP_AUDIOEQ                   0x0104
#define SXIAPI_MESSOP_EXCITER                   0x0105
#define SXIAPI_MESSOP_TONEGEN                   0x0180

#define SXIAPI_MESSOP_DATASERVICE               0x0500
#define SXIAPI_MESSOP_DATASERVICE_FILTER        0x0501

#define SXIAPI_MESSOP_PACKAGE                   0x0ED0

#define SXIAPI_MESSOP_FIRMWAREUPDATE_PROG       0x0E81
#define SXIAPI_MESSOP_FIRMWAREUPDATE_CFG        0x0E82
#define SXIAPI_MESSOP_FIRMWAREUPDATE_PACKET     0x0E83
#define SXIAPI_MESSOP_FIRMWAREUPDATE_ERASE      0x0E84

#define SXIAPI_MESSOP_INVALID                   0xFFFF


//****************************************************************************
//
//                 SXI Command & Control Common Definitions
//
//****************************************************************************

#define SXIAPI_MAX_SHORT_BDCAST_NAME_LENGTH  8
#define SXIAPI_MAX_MED_BDCAST_NAME_LENGTH    10
#define SXIAPI_MAX_LONG_BDCAST_NAME_LENGTH   16
#define SXIAPI_MAX_ARTIST_LENGTH             36
#define SXIAPI_MAX_SONG_LENGTH               36
#define SXIAPI_MAX_CONTENT_INFO_LENGTH       36
#define SXIAPI_MAX_TRACK_METADATA            13
#define SXIAPI_MAX_CHAN_METADATA             4
#define SXIAPI_MAX_CHAN_SHORT_DESC           36
#define SXIAPI_MAX_CHAN_LONG_DESC            180
#define SXIAPI_MAX_RELATED_CHAN              8

#define SXIAPI_MAX_RADIO_ID_LENGTH           8
#define SXIAPI_MAX_PHONE_NUMBER_LENGTH       10

#define SXIAPI_TRACK_METADATA_NUM_TEAMS         2
#define SXIAPI_TRACK_METADATA_ALBUM_NAME_LENGTH 37

#define SXIAPI_MAX_REASON_TEXT_LENGTH        64

#define SXIAPI_MAX_STATUS_MONITOR_COUNT      16
#define SXIAPI_MAX_FEATURE_MONITOR_COUNT     16

#define SXIAPI_CAT_ID_VECTOR_SIZE            8

#define SXIAPI_SERVICE_ID_BROADCAST_MAX      (383)
#define SXIAPI_SERVICE_ID_VECTOR_SIZE        (SXIAPI_SERVICE_ID_BROADCAST_MAX/8+1)

#define SXIAPI_SERVICEID_SERVICENOTASSIGNED  0xFFFF
#define SXIAPI_CHANNELID_SERVICENOTASSIGNED  0xFFFF
#define SXIAPI_CATEGORYID_SERVICENOTASSIGNED 0x00
#define SXIAPI_CATEGORYID_ALLCATEGORIES      0xFF

// Standard Channel Attributes/Override Definitions
#define SXIAPI_CHANNELATTR_NONE                 0x00

#define SXIAPI_CHANNELATTR_PLAY_UNRESTRICTED    0x01
#define SXIAPI_CHANNELATTR_UNSUBSCRIBED         0x02
#define SXIAPI_CHANNELATTR_MATURE               0x04
#define SXIAPI_CHANNELATTR_LOCKED               0x08
#define SXIAPI_CHANNELATTR_SKIPPED              0x10
#define SXIAPI_CHANNELATTR_FREE_TO_AIR          0x20
#define SXIAPI_CHANNELATTR_RESERVED             0xC0

// Standard Channel Attributes List Definitions
#define SXIAPI_CHANNELATTRLIST_SCAN_INCLUDE             (0x00)
#define SXIAPI_CHANNELATTRLIST_SMART_FAVORITES          (0x01)
#define SXIAPI_CHANNELATTRLIST_SMART_FAVORITES_SCAN     (0x02)
#define SXIAPI_CHANNELATTRLIST_SPORTS_FLASH             (0x20)

// Standard Channel Attributes Vector Definitions
#define SXIAPI_CHANNELATTRSIDV_SKIP             0x00
#define SXIAPI_CHANNELATTRSIDV_LOCK             0x01
#define SXIAPI_CHANNELATTRSIDV_SCAN_EXCLUDE     0x02

#define SXIAPI_DMI_CNT_MAX                      96

#define SXIAPI_MAX_URL_CHARS                    256
#define SXIAPI_MAX_TRAFFIC_MKT_ABBREV           3
#define SXIAPI_MAX_TRAFFIC_MKT_NAME             24
#define SXIAPI_MAX_SPORTS_TEAM_ABBREV           6
#define SXIAPI_MAX_SPORTS_TEAM_NAME             24
#define SXIAPI_MAX_SPORTS_TEAM_NICKNAME         16
#define SXIAPI_MAX_SPORTS_LEAGUE_SHORT_NAME     8
#define SXIAPI_MAX_SPORTS_LEAGUE_LONG_NAME      36
#define SXIAPI_MAX_SPORTS_LEAGUE_TYPE           16
#define SXIAPI_MAX_SPORTS_TEAM_LEAGUE_LIST_SIZE 8
#define SXIAPI_MAX_SPORTS_TEAM_TIER_LIST_SIZE   8
#define SXIAPI_MAX_BANK_TTL_SHORT               8
#define SXIAPI_MAX_BANK_TTL_LONG                16
#define SXIAPI_MAX_BANK_TTL_VERBOSE             36
#define SXIAPI_MAX_BANK_DESCR                   180
#define SXIAPI_MAX_BANK_ARR                     34
#define SXIAPI_MAX_BANK_ARR_CNT                 4

#define SXIAPI_PKG_ARRAY_HASH_SIZE              12
#define SXIAPI_PKG_MAC_SIZE                     12

#define SXIAPI_EVENT_IND_DATA_MAX_SIZE          10

#define SXIAPI_MODULECFG_IND_CAPABILITY_NONE                    (0x0000)
#define SXIAPI_MODULECFG_IND_CAPABILITY_IR                      (0x0001)
#define SXIAPI_MODULECFG_IND_CAPABILITY_AUDIO_REC               (0x0002)
#define SXIAPI_MODULECFG_IND_CAPABILITY_EXTD_CHAN               (0x0004)
#define SXIAPI_MODULECFG_IND_CAPABILITY_I2S_SLAVE               (0x0008)
#define SXIAPI_MODULECFG_IND_CAPABILITY_ADVANCED_IR             (0x0010)
#define SXIAPI_MODULECFG_IND_CAPABILITY_EXPANDED_SMART_FAVS     (0x0020)

// Command confirmation boundaries (SX-9845-0097 6.1)
#define SXIAPI_MODULECFG_CMD_CONFIRMATION_WAIT_TIME_MIN (0)
#define SXIAPI_MODULECFG_CMD_CONFIRMATION_WAIT_TIME_DEFAULT ( \
    SXIAPI_MODULECFG_CMD_CONFIRMATION_WAIT_TIME_MIN      \
        )
#define SXIAPI_MODULECFG_CMD_CONFIRMATION_WAIT_TIME_MAX (76)

// Bitmasks used to configure Recording functionality via ModuleCfgCmd
#define SXIAPI_RECORD_CONTROL_MASK_NONE                           (0x00)
#define SXIAPI_RECORD_CONTROL_MASK_RECORDING_MANAGED_BY_MODULE    (0x01)
#define SXIAPI_RECORD_CONTROL_MASK_RECORDING_MANAGED_BY_HOST      (0x02)
#define SXIAPI_RECORD_CONTROL_MASK_RECORD_CURRENT_CONTENT_ENABLED (0x04)
#define SXIAPI_RECORD_CONTROL_MASK_ALL ( \
    SXIAPI_RECORD_CONTROL_MASK_RECORDING_MANAGED_BY_MODULE    | \
    SXIAPI_RECORD_CONTROL_MASK_RECORDING_MANAGED_BY_HOST      | \
    SXIAPI_RECORD_CONTROL_MASK_RECORD_CURRENT_CONTENT_ENABLED   \
        )

// Bitmasks used to configure I2S parameters via ModuleCfgCmd
#define SXIAPI_I2S_CONTROL_VAL_MODE_NONE   (0x00) // Slave I2S Mode
#define SXIAPI_I2S_CONTROL_VAL_MODE_MASTER  (0x01) // Master I2S Mode
#define SXIAPI_I2S_CONTROL_VAL_MODE_CONTENT_BUFFERED  (0x02) // Content Buffered

#define SXIAPI_I2S_CONTROL_MASK_ALL ( \
    SXIAPI_I2S_CONTROL_VAL_MODE_MASTER           | \
    SXIAPI_I2S_CONTROL_VAL_MODE_CONTENT_BUFFERED   \
        )

// Min and max values must be changed when new mask values are added
#define SXIAPI_EXTENDED_CONTROL_VAL_MIN  SXIAPI_I2S_CONTROL_VAL_MODE_NONE
#define SXIAPI_EXTENDED_CONTROL_VAL_MAX  SXIAPI_I2S_CONTROL_MASK_ALL

#define SXIAPI_PRIORITY_SMART_FAV_CNT_MIN  (0)
#define SXIAPI_PRIORITY_SMART_FAV_CNT_MAX  (20)
#define SXIAPI_PRIORITY_SMART_FAV_CNT_DEFAULT ( \
    SXIAPI_PRIORITY_SMART_FAV_CNT_MIN \
        )

#define SXIAPI_SERVICE_ID_BROADCAST_MAX (383)

// Alternate Channel Order Default value
#define SXIAPI_DEFAULT_CHAN_LIST_ORDER  (0xFFFF)

// bitmasks used to indicate which channel generated tone
// will be played out of
#define SXIAPI_TONE_GEN_CHANNEL_NONE    (0x00)
#define SXIAPI_TONE_GEN_CHANNEL_RIGHT   (0x01)
#define SXIAPI_TONE_GEN_CHANNEL_LEFT    (0x02)
#define SXIAPI_TONE_GEN_ALERT           (0x04)
#define SXIAPI_TONE_GEN_OPTIONS_INVALID (0x08)

#define SXIAPI_TONE_GEN_CHANNEL_BOTH \
    ( SXIAPI_TONE_GEN_CHANNEL_RIGHT |\
      SXIAPI_TONE_GEN_CHANNEL_LEFT )

//****************************************************************************
//
//                 SXI Data Op Code Definitions
//
//****************************************************************************
#define SXIAPI_MESSOP_DATAPACKET                    0x0510

  /*********************/
 /** GLOBAL TYPEDEFS **/
/*********************/

// SXI Basic Types
typedef UN16 SXIAPI_LINK_OPCODE;
typedef UN16 SXIAPI_OPCODE;
typedef UN16 SXIAPI_OPTYPE;
typedef UN8  SXIAPI_TRANID;
typedef UN8  SXIAPI_STATUSCODE;
typedef UN8  SXIAPI_INDCODE;
typedef UN8  SXIAPI_CATEGORY_ID;
typedef UN16 SXIAPI_CHANNEL_ID;
typedef UN16 SXIAPI_SID;
typedef UN32 SXIAPI_PROGRAM_ID;
typedef UN8  SXIAPI_CH_ATTRIB;
typedef UN16 SXIAPI_DSI;
typedef UN16 SXIAPI_DMI;
typedef UN16 SXIAPI_METADATA_IDENTIFIER;
typedef UN16 SXIAPI_PLAYBACK_ID;
typedef N16  SXIAPI_PLAYBACK_TIME_OFFSET;
typedef UN16 SXIAPI_CONFIRMATION_WAIT_TIME;
typedef UN8  SXIAPI_RECORD_CONTROL_MASK;
typedef UN8  SXIAPI_EXTENDED_CONTROL_MASK;

typedef UN16 SXIAPI_SECONDARY_ID;
#define SXIAPI_SECONDARY_INVALID_ID ((SXIAPI_SECONDARY_ID)-1)

typedef UN8 SXIAPI_PRIORITY_SMART_FAV_COUNT;
typedef UN8 SXIAPI_SEEKMON_ID;
typedef UN16 SXIAPI_FLASH_EVENT_ID;

/**/

typedef enum sxiapi_statuscode_enum
{
    SXIAPI_STATUSCODE_MSG_RECEIVED =            0x00,
    SXIAPI_STATUSCODE_MSG_COMPLETE =            0x01,
    SXIAPI_STATUSCODE_MSG_FAIL =                0x02,
    SXIAPI_STATUSCODE_MSG_UNKNOWN =             0x03,

    SXIAPI_STATUSCODE_ERROR =                   0xFF

} SXIAPI_STATUSCODE_ENUM;

typedef enum sxiapi_indcode_enum
{
    SXIAPI_INDCODE_NOMINAL =                    0x00,
    SXIAPI_INDCODE_ADD_UPDATE =                 0x01,
    SXIAPI_INDCODE_DELETE =                     0x02,
    SXIAPI_INDCODE_FAIL =                       0x03,
    SXIAPI_INDCODE_NO_CHAN =                    0x04,
    SXIAPI_INDCODE_CHECK_ANTENNA =              0x05,
    SXIAPI_INDCODE_NO_SIGNAL =                  0x06,
    SXIAPI_INDCODE_SUB_UPDATE =                 0x07,
    SXIAPI_INDCODE_CHAN_UNAVAIL =               0x08,
    SXIAPI_INDCODE_CHAN_UNSUB =                 0x09,
    SXIAPI_INDCODE_CHAN_LOCKED =                0x0A,
    SXIAPI_INDCODE_CHAN_MATURE =                0x0B,

    SXIAPI_INDCODE_FA_ALREADY_SELECTED =        0x0C,
    SXIAPI_INDCODE_FA_MPA_INVALID =             0x0D,
    SXIAPI_INDCODE_FA_OTA_INVALID =             0x0E,
    SXIAPI_INDCODE_FA_INDEX_INVALID =           0x0F,
    SXIAPI_INDCODE_FA_SELECTION_REQUIRED =      0x10,
    SXIAPI_INDCODE_FA_ERROR_NORESPONSE =            0x11,
    SXIAPI_INDCODE_FA_ERROR_TIMEOUT =               0x12,
    SXIAPI_INDCODE_FA_ERROR_ABH_I2C =               0x13,
    SXIAPI_INDCODE_FA_ERROR_INVALID_IMAGE =         0x14,
    SXIAPI_INDCODE_FA_ERROR_NOT_AUTH =              0x15,
    SXIAPI_INDCODE_FA_ERROR_SUSPENDED =             0x16,
    SXIAPI_INDCODE_FA_ERROR_MPA_PRESENT =           0x17,
    SXIAPI_INDCODE_FA_ERROR_CAP_IO_ERROR =          0x18,
    SXIAPI_INDCODE_FA_ERROR_PARTITION_SIZE =        0x19,
    SXIAPI_INDCODE_FA_ERROR_NVM_INVALID =           0x1A,
    SXIAPI_INDCODE_FA_ERROR_UNBOUND =               0x1B,
    SXIAPI_INDCODE_FA_ERROR_OTP_INVALID =           0x1C,
    SXIAPI_INDCODE_FA_ERROR_CRYPTO =                0x1D,

    SXIAPI_INDCODE_RESOURCE_LIMIT =                 0x1E,
    SXIAPI_INDCODE_NO_TRACKS =                      0x1F,
    SXIAPI_INDCODE_SCAN_NOMINAL =                   0x20,
    SXIAPI_INDCODE_CHAN_AUDIO_UNAVAIL =             0x21,
    SXIAPI_INDCODE_RECORD_FAIL =                    0x22,
    SXIAPI_INDCODE_SCAN_ABORTED =                   0x23,
    SXIAPI_INDCODE_TUNEMIX_NOMINAL =                0x24,

    SXIAPI_INDCODE_BULLETIN_NOMINAL =               0x25,
    SXIAPI_INDCODE_BULLETIN_UNAVAIL =               0x26,

    SXIAPI_INDCODE_FLASH_EVENT_NOMINAL =            0x27,
    SXIAPI_INDCODE_FLASH_EVENT_UNAVAIL =            0x28,
    SXIAPI_INDCODE_SEEK_END =                       0x29,

    SXIAPI_INDCODE_ERROR =                          0xFF

} SXIAPI_INDCODE_ENUM;

typedef struct sxiapi_bdcast_name_struct
{
    char acShort [SXIAPI_MAX_SHORT_BDCAST_NAME_LENGTH+1];
    char acMed [SXIAPI_MAX_MED_BDCAST_NAME_LENGTH+1];
    char acLong [SXIAPI_MAX_LONG_BDCAST_NAME_LENGTH+1];

} SXIAPI_BDCAST_NAMES_STRUCT;

typedef enum sxiapi_uartcontrol_enum
{
    SXIAPI_UARTCONTROL_57600 = 0,
    SXIAPI_UARTCONTROL_DEFAULT = SXIAPI_UARTCONTROL_57600,
    SXIAPI_UARTCONTROL_115200 = 1,
    SXIAPI_UARTCONTROL_230400 = 2,
    SXIAPI_UARTCONTROL_460800 = 3,
    SXIAPI_UARTCONTROL_921600 = 4,
    SXIAPI_UARTCONTROL_1230769 = 5,
    SXIAPI_UARTCONTROL_1846154 = 6,
    SXIAPI_UARTCONTROL_UNKNOWN

} SXIAPI_UARTCONTROL_ENUM;

typedef enum sxiapi_fading_cfg_enum
{
    SXIAPI_FADING_CFG_RESERVED= 0,
    SXIAPI_FADING_CFG_ENABLED,
    SXIAPI_FADING_CFG_INVALID
}SXIAPI_FADING_CFG_ENUM;

typedef enum sxiapi_cat_chan_label_length_enum
{
    SXIAPI_CAT_CHAN_LABEL_LENGTH_8 = 0,
    SXIAPI_CAT_CHAN_LABEL_LENGTH_10,
    SXIAPI_CAT_CHAN_LABEL_LENGTH_16,
    SXIAPI_CAT_CHAN_LABEL_LENGTH_INVALID

}SXIAPI_CAT_CHAN_LABEL_LENGTH_ENUM;

typedef enum sxiapi_metadata_label_length_enum
{
    SXIAPI_METADATA_LABEL_LENGTH_8 = 0,
    SXIAPI_METADATA_LABEL_LENGTH_10,
    SXIAPI_METADATA_LABEL_LENGTH_16,
    SXIAPI_METADATA_LABEL_LENGTH_INVALID

}SXIAPI_METADATA_LABEL_LENGTH_ENUM;

typedef enum sxiapi_max_pending_ing_cfg_enum
{
    SXIAPI_MAX_PENDING_IND_CFG_1 = 0,
    SXIAPI_MAX_PENDING_IND_CFG_4,
    SXIAPI_MAX_PENDING_IND_CFG_INVALID

}SXIAPI_MAX_PENDING_IND_CFG_ENUM;


typedef enum sxiapi_ir_control_cfg_enum
{
    SXIAPI_IR_CONTROL_CFG_DISABLED = 0,
    SXIAPI_IR_CONTROL_CFG_MODULE = 1,
    SXIAPI_IR_CONTROL_CFG_INVALID

} SXIAPI_IR_CONTROL_CFG_ENUM;

typedef enum sxiapi_ir_delete_on_tune_cfg_enum
{
    SXIAPI_IR_DELETE_ON_TUNE_CFG_DISABLED = 0,
    SXIAPI_IR_DELETE_ON_TUNE_CFG_MODULE,
    SXIAPI_IR_DELETE_ON_TUNE_CFG_INVALID

} SXIAPI_IR_DELETE_ON_TUNE_CFG_ENUM;

typedef enum sxiapi_ir_mark_new_track_cfg_enum
{
    SXIAPI_IR_MARK_NEW_TRACK_CFG_ON_PID = 0,
    SXIAPI_IR_MARK_NEW_TRACK_CFG_ON_LABEL,
    SXIAPI_IR_MARK_NEW_TRACK_CFG_INVALID

} SXIAPI_IR_MARK_NEW_TRACK_CFG_ENUM;

typedef enum sxiapi_ir_metadata_reporting_cfg_enum
{
    SXIAPI_IR_METADATA_REPORTING_CFG_CURRENT= 0,
    SXIAPI_IR_METADATA_REPORTING_CFG_ALL,
    SXIAPI_IR_METADATA_REPORTING_CFG_INVALID

} SXIAPI_IR_METADATA_REPORTING_ENUM;

typedef struct sxiapi_modulecfgcmd_struct
{
    SXIAPI_FADING_CFG_ENUM eFading;
    SXIAPI_CAT_CHAN_LABEL_LENGTH_ENUM eMaxCatLabelLen;
    SXIAPI_CAT_CHAN_LABEL_LENGTH_ENUM eMaxChanLabelLen;
    SXIAPI_METADATA_LABEL_LENGTH_ENUM eMaxMetadataLabelLen;
    SXIAPI_MAX_PENDING_IND_CFG_ENUM eMaxPendingInds;
    SXIAPI_CONFIRMATION_WAIT_TIME tConfirmationWaitTime;
    SXIAPI_IR_CONTROL_CFG_ENUM eIRControl;
    SXIAPI_IR_DELETE_ON_TUNE_CFG_ENUM eIRDeleteOnTune;
    SXIAPI_IR_MARK_NEW_TRACK_CFG_ENUM eIRMarkNewTrack;
    SXIAPI_RECORD_CONTROL_MASK tRecordControl;
    SXIAPI_EXTENDED_CONTROL_MASK tExtendedControl;
    SXIAPI_PRIORITY_SMART_FAV_COUNT tPrioritySmartFavCnt;

} SXIAPI_MODULECFGCMD_STRUCT;

typedef enum sxiapi_adv_ir_feature_control_enum
{
    SXIAPI_ADV_IR_FEATURE_DISABLE = 0,
    SXIAPI_ADV_IR_FEATURE_ENABLE  = 1

} SXIAPI_ADV_IR_FEATURE_CONTROL_ENUM;

typedef enum sxiapi_adv_ir_playpoint_enum
{
    SXIAPI_ADV_IR_PLAYPOINT_AT_LIVE   = 0,
    SXIAPI_ADV_IR_PLAYPOINT_AT_START  = 1,
    SXIAPI_ADV_IR_PLAYPOINT_AUTOMATIC = 2

} SXIAPI_ADV_IR_PLAYPOINT_ENUM;

typedef UN8 SXIAPI_ADV_IR_SCAN_PLAY_SECONDS;

#define SXIAPI_ADV_IR_SCAN_PLAY_SECONDS_MIN 2
#define SXIAPI_ADV_IR_SCAN_PLAY_SECONDS_MAX 15
#define SXIAPI_ADV_IR_SCAN_PLAY_SECONDS_DEFAULT 6

typedef UN16 SXIAPI_ADV_IR_CHAN_SCAN_INCLUDE_MASK;

// Channel Scan Include Mask
#define SXIAPI_ADV_IR_CHAN_SCAN_INCLUDE_NONE                        (0x0000)

// Channel Scan Include Types
#define SXIAPI_ADV_IR_CHAN_SCAN_INCLUDE_INCLUDED_LIST               (0x0001)
#define SXIAPI_ADV_IR_CHAN_SCAN_INCLUDE_SMART_FAVORITES             (0x0002)
#define SXIAPI_ADV_IR_CHAN_SCAN_INCLUDE_ACTIVE_CATGEORY             (0x0004)
#define SXIAPI_ADV_IR_CHAN_SCAN_INCLUDE_USER_CATEGORY1              (0x0008)
#define SXIAPI_ADV_IR_CHAN_SCAN_INCLUDE_USER_CATEGORY2              (0x0010)
#define SXIAPI_ADV_IR_CHAN_SCAN_INCLUDE_USER_CATEGORY3              (0x0020)
#define SXIAPI_ADV_IR_CHAN_SCAN_INCLUDE_USER_CATEGORY1_OTHERS       (0x0040)
#define SXIAPI_ADV_IR_CHAN_SCAN_INCLUDE_USER_CATEGORY2_OTHERS       (0x0080)
#define SXIAPI_ADV_IR_CHAN_SCAN_INCLUDE_USER_CATEGORY3_OTHERS       (0x0100)

// Channel Scan Default Include Types
#define SXIAPI_ADV_IR_CHAN_SCAN_INCLUDE_DEFAULT                     (   \
        SXIAPI_ADV_IR_CHAN_SCAN_INCLUDE_INCLUDED_LIST           |       \
        SXIAPI_ADV_IR_CHAN_SCAN_INCLUDE_SMART_FAVORITES                     )

// Channel Scan All Include Types
#define SXIAPI_ADV_IR_CHAN_SCAN_INCLUDE_ALL                         (   \
        SXIAPI_ADV_IR_CHAN_SCAN_INCLUDE_INCLUDED_LIST           |       \
        SXIAPI_ADV_IR_CHAN_SCAN_INCLUDE_SMART_FAVORITES         |       \
        SXIAPI_ADV_IR_CHAN_SCAN_INCLUDE_ACTIVE_CATGEORY         |       \
        SXIAPI_ADV_IR_CHAN_SCAN_INCLUDE_USER_CATEGORY1          |       \
        SXIAPI_ADV_IR_CHAN_SCAN_INCLUDE_USER_CATEGORY2          |       \
        SXIAPI_ADV_IR_CHAN_SCAN_INCLUDE_USER_CATEGORY3          |       \
        SXIAPI_ADV_IR_CHAN_SCAN_INCLUDE_USER_CATEGORY1_OTHERS   |       \
        SXIAPI_ADV_IR_CHAN_SCAN_INCLUDE_USER_CATEGORY2_OTHERS   |       \
        SXIAPI_ADV_IR_CHAN_SCAN_INCLUDE_USER_CATEGORY3_OTHERS               )

typedef UN16 SXIAPI_ADV_IR_CHAN_SCAN_EXCLUDE_MASK;

#define SXIAPI_CHAN_SCAN_INC_HOST_LIST  0x0001
#define SXIAPI_CHAN_SCAN_INC_PRELOADED  0x0002

// Channel Scan Exclude Mask
#define SXIAPI_ADV_IR_CHAN_SCAN_EXCLUDE_NONE                        (0x0000)

// Channel Scan Exclude Types
#define SXIAPI_ADV_IR_CHAN_SCAN_EXCLUDE_EXCLUDED_LIST               (0x0001)

// Channel Scan Default Exclude Types
#define SXIAPI_ADV_IR_CHAN_SCAN_EXCLUDE_DEFAULT                     (   \
        SXIAPI_ADV_IR_CHAN_SCAN_EXCLUDE_EXCLUDED_LIST                       )

// Channel Scan ALl Exclude Types
#define SXIAPI_ADV_IR_CHAN_SCAN_EXCLUDE_ALL                         (   \
        SXIAPI_ADV_IR_CHAN_SCAN_EXCLUDE_EXCLUDED_LIST                       )

typedef struct sxiapi_adv_ir_cfg_cmd_struct
{
    SXIAPI_ADV_IR_FEATURE_CONTROL_ENUM eFeatureControl;
    SXIAPI_ADV_IR_PLAYPOINT_ENUM ePlayPoint;
    SXIAPI_ADV_IR_SCAN_PLAY_SECONDS tPlaySeconds;
    SXIAPI_ADV_IR_CHAN_SCAN_INCLUDE_MASK tChanScanIncludeMask;
    SXIAPI_ADV_IR_CHAN_SCAN_EXCLUDE_MASK tChanScanExcludeMask;

} SXIAPI_CHAN_SELECT_CFG_CMD_STRUCT;

typedef enum sxiapi_pwrmode_enum
{
  SXIAPI_PWRMODE_DOWN = 0,
  SXIAPI_PWRMODE_FACTORY_DEFAULT = 1,
  SXIAPI_PWRMODE_ENTER_LOW_POWER_MODE = 2,
  SXIAPI_PWRMODE_EXIT_LOW_POWER_MODE = 3,
  SXIAPI_PWRMODE_INVALID
} SXIAPI_PWRMODE_ENUM;

typedef enum sxiapi_timezone_enum
{
  SXIAPI_TIMEZONE_NT = 0,
  SXIAPI_TIMEZONE_AT,
  SXIAPI_TIMEZONE_ET,
  SXIAPI_TIMEZONE_CT,
  SXIAPI_TIMEZONE_MT,
  SXIAPI_TIMEZONE_PT,
  SXIAPI_TIMEZONE_AKT,
  SXIAPI_TIMEZONE_HAT,
  SXIAPI_TIMEZONE_INVALID,
  SXIAPI_TIMEZONE_UTC = 255
} SXIAPI_TIMEZONE_ENUM;

// These constants are used to match the SXIAPI_TIMEZONE_ENUM
// values with their minute offsets from GMT
#define SXIAPI_TIMEZONE_GMT_OFFSET_MIN_NONE (0)
#define SXIAPI_TIMEZONE_GMT_OFFSET_MIN_NT (-210)
#define SXIAPI_TIMEZONE_GMT_OFFSET_MIN_AT (-240)
#define SXIAPI_TIMEZONE_GMT_OFFSET_MIN_ET (-300)
#define SXIAPI_TIMEZONE_GMT_OFFSET_MIN_CT (-360)
#define SXIAPI_TIMEZONE_GMT_OFFSET_MIN_MT (-420)
#define SXIAPI_TIMEZONE_GMT_OFFSET_MIN_PT (-480)
#define SXIAPI_TIMEZONE_GMT_OFFSET_MIN_AKT (-540)
#define SXIAPI_TIMEZONE_GMT_OFFSET_MIN_HAT (-600)

typedef enum sxiapi_sub_status_enum
{
    SXIAPI_SUB_STATUS_NOT_SUBSCRIBED = 0,
    SXIAPI_SUB_STATUS_SUBSCRIBED,
    SXIAPI_SUB_STATUS_SUSPEND_ALERT,
    SXIAPI_SUB_STATUS_SUSPENDED,
    SXIAPI_SUB_STATUS_INVALID

} SXIAPI_SUB_STATUS_ENUM;

typedef enum sxiap_sub_status_ext_mask_enum {
    SXIAPI_SUB_STATUS_EXT_AUDIO_MASK = 1
} SXIAPI_SUB_STATUS_EXT_MASK_ENUM;

typedef struct sxiapi_substatusind_struct
{
    char acRadioID[SXIAPI_MAX_RADIO_ID_LENGTH+1];
    SXIAPI_SUB_STATUS_ENUM eStatus;
    UN8 un8ReasonCode;
    UN32 un32UTCSuspendTime;
    char acReasonText[SXIAPI_MAX_REASON_TEXT_LENGTH+1];
    char acPhoneNumber[SXIAPI_MAX_PHONE_NUMBER_LENGTH+1];
    BOOLEAN bIsAudioSubscribed;
} SXIAPI_SUBSTATUSIND_STRUCT;

typedef struct sxiapi_timeind_struct
{
    // Time as reported by the system (timestamp)
    UN32 un32Seconds;
    UN16 un16Msecs;

    // Time as reported by the chipset
    UN8 un8Minute;
    UN8 un8Hour;
    UN8 un8Day;
    UN8 un8Month;
    UN8 un8Year;

} SXIAPI_TIMEIND_STRUCT;

typedef enum sxiapi_event_code_enum
{
    // EventCodes
    SXIAPI_EVENT_CODE_INFO = 0x00,
    SXIAPI_EVENT_CODE_RESET = 0x01,
    SXIAPI_EVENT_CODE_ACTION = 0x02,
    SXIAPI_EVENT_CODE_INVALID
} SXIAPI_EVENT_CODE_ENUM;

typedef struct sxiapi_eventind_struct
{
    SXIAPI_EVENT_CODE_ENUM eEventCode;
    UN16 aun16EventData[SXIAPI_EVENT_IND_DATA_MAX_SIZE];

} SXIAPI_EVENTIND_STRUCT;

typedef struct sxiapi_dispadvisoryind_struct
{
    BOOLEAN bChanInfoValid;
    SXIAPI_CHANNEL_ID tChanID;
    SXIAPI_BDCAST_NAMES_STRUCT sChanNames;

} SXIAPI_DISPADVISORYIND_STRUCT;

typedef enum sxiapi_status_item_enum
{
    SXIAPI_STATUS_ITEM_SIGNAL = 0x00,
    SXIAPI_STATUS_ITEM_ANTENNA_AIMING = 0x03,
    SXIAPI_STATUS_ITEM_AUDIO_DECODER_BITRATE = 0x0B,
    SXIAPI_STATUS_ITEM_SIGNAL_QUALITY = 0x0C,
    SXIAPI_STATUS_ITEM_OVERLAY_SIGNAL_QUALITY = 0x0D,
    SXIAPI_STATUS_ITEM_LINK_INFORMATION = 0x11,
    SXIAPI_STATUS_ITEM_SCAN_ITEMS_AVAILABLE = 0x12,
    SXIAPI_STATUS_ITEM_AUDIO_PRESENCE = 0x13,
    SXIAPI_STATUS_ITEM_INVALID
} SXIAPI_STATUS_ITEM_ENUM;

typedef enum sxiapi_signal_enum
{
    SXIAPI_SIGNAL_0BARS = 0,
    SXIAPI_SIGNAL_1BAR,
    SXIAPI_SIGNAL_2BARS,
    SXIAPI_SIGNAL_3BARS,
    SXIAPI_SIGNAL_UNKNOWN,
} SXIAPI_SIGNAL_ENUM;

typedef enum sxiapi_antenna_enum
{
    SXIAPI_ANTENNA_OK = 0,
    SXIAPI_ANTENNA_DISCONNECTED,
    SXIAPI_ANTENNA_SHORTED,
    SXIAPI_ANTENNA_UNKNOWN

} SXIAPI_ANTENNA_ENUM;

typedef struct sxiapi_status_signal_struct
{
    SXIAPI_SIGNAL_ENUM eSignal;
    SXIAPI_ANTENNA_ENUM eAntenna;
} SXIAPI_STATUS_SIGNAL_STRUCT;

typedef enum sxiapi_audio_decoder_enum
{
    SXIAPI_AUDIO_DECODER_OUTPUT_OK = 0,
    SXIAPI_AUDIO_DECODER_NO_OUTPUT,
    SXIAPI_AUDIO_DECODER_UNKNOWN

} SXIAPI_AUDIO_DECODER_ENUM;

typedef struct sxiapi_status_antenna_aiming_struct
{
    UN8 un8SatPercentage;
    UN8 un8TerPercentage;
} SXIAPI_STATUS_ANTENNA_AIMMING_STRUCT;

typedef struct sxiapi_modulecfgind_struct
{
    UN8 un8ModuleTypeIDA;
    UN8 un8ModuleTypeIDB;
    UN8 un8ModuleTypeIDC;
    UN8 un8ModuleHWRevA;
    UN8 un8ModuleHWRevB;
    UN8 un8ModuleHWRevC;
    UN8 un8ModSWRevMajor;
    UN8 un8ModSWRevMinor;
    UN8 un8ModSWRevInc;
    UN8 un8SXIRevMajor;
    UN8 un8SXIRevMinor;
    UN8 un8SXIRevInc;
    UN8 un8BBRevMajor;
    UN8 un8BBRevMinor;
    UN8 un8BBRevInc;
    UN8 un8HDecRevMajor;
    UN8 un8HDecRevMinor;
    UN8 un8HDecRevInc;
    UN8 un8RFRevMajor;
    UN8 un8RFRevMinor;
    UN8 un8RFRevInc;
    UN32 un32Capability;
    UN16 un16DurationOfBuffer;
    UN8 un8SPLRevMajor;
    UN8 un8SPLRevMinor;
    UN8 un8SPLRevInc;

    // SXi v3.0 Features
    UN8 un8MaxSmartFavorites;
    UN8 un8MaxTuneMix;
    UN8 un8MaxSportsFlash;
    UN8 un8MaxTWNow;

} SXIAPI_MODULECFGIND_STRUCT;

typedef struct sxiapi_detailed_signal_quality_struct
{
    UN8 un8SignalStrength;
    UN8 un8TunerStatus;
    UN8 un8ENSALockStatus;
    UN8 un8ENSBLockStatus;
    UN16 un16BERS1;
    UN16 un16BERS2;
    UN16 un16BERT;
    UN8 un8CNS1A;
    UN8 un8CNS1B;
    UN8 un8CNS2A;
    UN8 un8CNS2B;
    UN16 un16RSErrsWords;
    UN16 un16RSErrsSatSymb;
    UN16 un16RRSErrsTerrSymb;
    N16 n16TunerCarrierFreqOffset;
    N16 n16RSSI;

} SXIAPI_DETAILED_SIGNAL_QUALITY_STRUCT;

typedef struct sxiapi_detailed_overlay_signal_quality_struct
{
    UN8 un8ReceiverState;
    UN16 un16OberS1A;
    UN16 un16OberS2A;
    UN16 un16OberTA;
    UN16 un16OberS1B;
    UN16 un16OberS2B;
    UN16 un16OberTB;
    UN16 un16TurboWordErrorRate0A;
    UN16 un16TurboWordErrorRate1A;
    UN16 un16TurboWordErrorRate2A;
    UN16 un16TurboWordErrorRate0B;
    UN16 un16TurboWordErrorRate1B;
    UN16 un16TurboWordErrorRate2B;

} SXIAPI_DETAILED_OVERLAY_SIGNAL_QUALITY_STRUCT;

typedef struct sxiapi_link_information_struct
{
    UN32 un32NumberConfirmTimeouts;
    UN32 un32NumberDataPacketsDropped;
    UN32 un32NumberDataPacketsTx;
    UN32 un32NumberAudioPacketsDropped;
    UN32 un32NumberAudioPacketsTx;

} SXIAPI_LINK_INFORMATION_STRUCT;

typedef struct sxiapi_scan_items_available_struct
{
    UN8 un8ScanCriteriaSource;
    UN16 un16ScannableUnplayedTrackCnt;
    UN16 un16ScannableUnscannedTrackCnt;

} SXIAPI_SCAN_ITEMS_AVAILABLE_STRUCT;

typedef enum sxiapi_audio_presence_enum
{
    SXIAPI_SIGNAL_AUDIO_NOT_PRESENT = 0,
    SXIAPI_SIGNAL_AUDIO_PRESENT = 1

} SXIAPI_AUDIO_PRESENCE_ENUM;

typedef union sxiapi_status_data_union
{
    SXIAPI_STATUS_SIGNAL_STRUCT sSignal;
    SXIAPI_STATUS_ANTENNA_AIMMING_STRUCT sAntenna;
    SXIAPI_DETAILED_SIGNAL_QUALITY_STRUCT sDetailedSignalQuality;
    SXIAPI_DETAILED_OVERLAY_SIGNAL_QUALITY_STRUCT sDetailedOverlaySignalQuality;
    SXIAPI_LINK_INFORMATION_STRUCT sLinkStatus;
    SXIAPI_SCAN_ITEMS_AVAILABLE_STRUCT sScanItems;
    UN8 un8AudioDecoderBitrate;
    SXIAPI_AUDIO_PRESENCE_ENUM eAudioPresence;

} SXIAPI_STATUS_DATA_UNION;

typedef struct sxiapi_statusind_struct
{
    BOOLEAN bEngineeringData;
    SXIAPI_STATUS_ITEM_ENUM eStatusItem;
    SXIAPI_STATUS_DATA_UNION uData;

} SXIAPI_STATUSIND_STRUCT;

typedef enum sxiapi_monitor_op_enum
{
    SXIAPI_MONITOR_OP_DISABLE = 0,
    SXIAPI_MONITOR_OP_ENABLE,
    SXIAPI_MONITOR_OP_DISABLE_ALL,
    SXIAPI_MONITOR_OP_INVALID

} SXIAPI_MONITOR_OP_ENUM;

typedef enum sxiapi_feature_monitor_enum
{
    SXIAPI_FEATURE_MONITOR_TIME = 0,
    SXIAPI_FEATURE_MONITOR_CHAN_INFO = 1,
    SXIAPI_FEATURE_MONITOR_CAT_INFO = 2,
    SXIAPI_FEATURE_MONITOR_METADATA = 3,
    SXIAPI_FEATURE_MONITOR_IR_RECORD_METADATA = 4,
    SXIAPI_FEATURE_MONITOR_INVALID

} SXIAPI_FEATURE_MONITOR_ENUM;

typedef enum sxiapi_chan_browse_type_enum
{
    SXIAPI_BROWSE_TYPE_SID = 0,
    SXIAPI_BROWSE_TYPE_CHANID,
    SXIAPI_BROWSE_TYPE_NEXT_CHAN,
    SXIAPI_BROWSE_TYPE_PREV_CHAN,
    SXIAPI_BROWSE_TYPE_NEXT_CAT,
    SXIAPI_BROWSE_TYPE_PREV_CAT,
    SXIAPI_BROWSE_TYPE_INVALID
} SXIAPI_CHAN_BROWSE_TYPE_ENUM;

typedef enum sxiapi_chan_select_type_enum
{
    SXIAPI_SELECT_TYPE_SID = 0,
    SXIAPI_SELECT_TYPE_CHANID,
    SXIAPI_SELECT_TYPE_NEXT_CHAN,
    SXIAPI_SELECT_TYPE_PREV_CHAN,
    SXIAPI_SELECT_TYPE_SCAN_CAT,
    SXIAPI_SELECT_TYPE_SCAN_LIST,
    SXIAPI_SELECT_TYPE_SCAN_CONTENT_ALL,
    SXIAPI_SELECT_TYPE_SCAN_CONTENT_MUSIC,
    SXIAPI_SELECT_TYPE_SCAN_REVERSE,
    SXIAPI_SELECT_TYPE_SCAN_SKIP_FORWARD,
    SXIAPI_SELECT_TYPE_SCAN_STOP,
    SXIAPI_SELECT_TYPE_SCAN_ABORT,
    SXIAPI_SELECT_TYPE_SCAN_SKIP_BACK,
    SXIAPI_SELECT_TYPE_SCAN_CFG_ALL,
    SXIAPI_SELECT_TYPE_SCAN_CFG_MUSIC,
    SXIAPI_SELECT_TYPE_PLAY_BULLETIN,
    SXIAPI_SELECT_TYPE_ABORT_BULLETIN,
    SXIAPI_SELECT_TYPE_PLAY_FLASH_EVENT,
    SXIAPI_SELECT_TYPE_REMAIN_FLASH_EVENT_CHANNEL,
    SXIAPI_SELECT_TYPE_ABORT_FLASH_EVENT,
    SXIAPI_SELECT_TYPE_INVALID
} SXIAPI_CHAN_SELECT_TYPE_ENUM;

// Specifies the audio routing path for the selected channel to
// be the I2S Audio Path, a Recorded Channel path or both.
#define SXIAPI_ROUTING_I2S_AUDIO_PATH           (0x01)
#define SXIAPI_ROUTING_RECORDED_CHANNEL_PATH    (0x02)
#define SXIAPI_ROUTING_ALL_PATHS (  \
    SXIAPI_ROUTING_I2S_AUDIO_PATH | \
    SXIAPI_ROUTING_RECORDED_CHANNEL_PATH \
        )

// these are used to indicate which fields in
// SXIAPI_EXT_METADATA_SONG_TAG_STRUCT were received.
// They'll be stored in un32ValidFieldMask
#define SXIAPI_VALID_TG_FIELD_NONE             (0x00000000UL)
#define SXIAPI_VALID_TG_FIELD_ITUNES_URL       (0x00000001UL)

typedef struct sxiapi_ext_metadata_song_tag_struct
{
    char acITunesURL[SXIAPI_MAX_URL_CHARS+1];
    // add additional tagging service URLs here in the future
    UN32 un32ValidFieldMask;
}SXIAPI_EXT_METADATA_SONG_TAG_SERVICE_STRUCT;

// ---- GLOBAL METADATA ----

typedef struct sxiapi_global_metadata_payload_struct
{
    OSAL_OBJECT_HDL hLL;
    UN16 un16NumBytes;
    OSAL_LINKED_LIST_ENTRY hEntry;

} SXIAPI_GLOBAL_METADATA_PAYLOAD_STRUCT;

// the max number of different GMIs defined
#define SXIAPI_MAX_EXT_METADATA_GMI_COUNT (38)

// mapping GMIs
typedef enum sxiapi_gmi_enum
{
  SXIAPI_GMI_CH_TBL_VER = 258,
  SXIAPI_GMI_CH_CHAN_CNT =  514,
  SXIAPI_GMI_TG_ITUNES_URL = 130,
  SXIAPI_GMI_TW_TBL_VER =  260,
  SXIAPI_GMI_TW_CITY_CNT = 516,
  SXIAPI_GMI_TW_CITY_ID = 141,
  SXIAPI_GMI_TW_CITY_ABBREV = 142,
  SXIAPI_GMI_TW_CITY_NAME = 143,
  SXIAPI_GMI_SP_TEAM_TABLE_VER = 261,
  SXIAPI_GMI_SP_TEAM_CNT = 517,
  SXIAPI_GMI_SP_TEAM_ID = 151,
  SXIAPI_GMI_SP_TEAM_ABBREV = 152,
  SXIAPI_GMI_SP_TEAM_NAME = 153,
  SXIAPI_GMI_SP_TEAM_NICKNAME = 154,
  SXIAPI_GMI_SP_TEAM_LEAGUE_IDS = 155,
  SXIAPI_GMI_SP_TEAM_TIERS = 156,
  SXIAPI_GMI_SP_LEAGUE_TABLE_VER = 262,
  SXIAPI_GMI_SP_LEAGUE_CNT = 518,
  SXIAPI_GMI_SP_LEAGUE_ID = 161,
  SXIAPI_GMI_SP_LEAGUE_SHORT_NAME = 162,
  SXIAPI_GMI_SP_LEAGUE_LONG_NAME = 163,
  SXIAPI_GMI_SP_LEAGUE_TYPE = 164,
  SXIAPI_GMI_SP_LEAGUE_SF_ENABLED = 165,
  SXIAPI_GMI_SP_LEAGUE_SF_TIERS = 166,
  SXIAPI_GMI_FF_BANK_TBL_VER = 263,
  SXIAPI_GMI_FF_BANK_CNT = 519,
  SXIAPI_GMI_FF_BANK_ORDER = 81,
  SXIAPI_GMI_FF_BANK_ID = 82,
  SXIAPI_GMI_FF_BANK_SEQ = 83,
  SXIAPI_GMI_FF_BANK_TTL_SHORT = 84,
  SXIAPI_GMI_FF_BANK_TTL_LONG = 85,
  SXIAPI_GMI_FF_BANK_TTL_VERBOSE = 86,
  SXIAPI_GMI_FF_BANK_DESCR = 87,
  SXIAPI_GMI_FF_BANK_PURPOSE = 88,
  SXIAPI_GMI_FF_BANK_ARR_1 = 89,
  SXIAPI_GMI_FF_BANK_ARR_2 = 90,
  SXIAPI_GMI_FF_BANK_ARR_3 = 91,
  SXIAPI_GMI_FF_BANK_ARR_4 = 92,
} SXIAPI_GMI_ENUM;

// these are used to indicate which fields in SXIAPI_EXT_METADATA_TRAFFIC_STRUCT
// were received. They'll be stored in un32ValidFieldMask
#define SXIAPI_VALID_GMI_TW_NONE             (0x00000000UL)
#define SXIAPI_VALID_GMI_TW_TABLE_VER        (0x00000001UL)
#define SXIAPI_VALID_GMI_TW_COUNT            (0x00000002UL)
#define SXIAPI_VALID_GMI_TW_CITY_ID          (0x00000004UL)
#define SXIAPI_VALID_GMI_TW_ABBREV           (0x00000008UL)
#define SXIAPI_VALID_GMI_TW_NAME             (0x00000010UL)

typedef struct sxiapi_ext_metadata_traffic_struct
{
    UN16 un16TableVersion;
    UN16 un16Count;
    OSAL_OBJECT_HDL hLL;
    UN32 un32ValidFieldMask;
    UN8 un8Fields;
}SXIAPI_EXT_METADATA_TRAFFIC_STRUCT;

typedef struct sxiapi_ext_metadata_market_struct
{
    UN8 un8CityId;
    char acAbbrev[SXIAPI_MAX_TRAFFIC_MKT_ABBREV+1];
    char acName[SXIAPI_MAX_TRAFFIC_MKT_NAME+1];
    UN32 un32ValidFieldMask;
}SXIAPI_EXT_METADATA_MARKET_STRUCT;

// these are used to indicate which fields in SXIAPI_EXT_METADATA_SPORTS_STRUCT
// were received. They'll be stored in un32ValidFieldMask
#define SXIAPI_VALID_GMI_SP_NONE              (0x00000000UL)
#define SXIAPI_VALID_GMI_SP_TEAM_TABLE_VER    (0x00000001UL)
#define SXIAPI_VALID_GMI_SP_TEAM_CNT          (0x00000002UL)
#define SXIAPI_VALID_GMI_SP_TEAM_ID           (0x00000004UL)
#define SXIAPI_VALID_GMI_SP_TEAM_ABBREV       (0x00000008UL)
#define SXIAPI_VALID_GMI_SP_TEAM_NAME         (0x00000010UL)
#define SXIAPI_VALID_GMI_SP_TEAM_NICKNAME     (0x00000020UL)
#define SXIAPI_VALID_GMI_SP_TEAM_LEAGUE_IDS   (0x00000040UL)
#define SXIAPI_VALID_GMI_SP_TEAM_TIERS        (0x00000080UL)
#define SXIAPI_VALID_GMI_SP_LEAGUE_TABLE_VER  (0x00000100UL)
#define SXIAPI_VALID_GMI_SP_LEAGUE_CNT        (0x00000200UL)
#define SXIAPI_VALID_GMI_SP_LEAGUE_ID         (0x00000400UL)
#define SXIAPI_VALID_GMI_SP_LEAGUE_SHORT_NAME (0x00000800UL)
#define SXIAPI_VALID_GMI_SP_LEAGUE_LONG_NAME  (0x00001000UL)
#define SXIAPI_VALID_GMI_SP_LEAGUE_TYPE       (0x00002000UL)
#define SXIAPI_VALID_GMI_SP_LEAGUE_SF_ENABLED (0x00004000UL)
#define SXIAPI_VALID_GMI_SP_LEAGUE_SF_TIERS   (0x00008000UL)

#define SXIAPI_VALID_GMI_SP_LEAGUE_TABLE_INFO ( \
    SXIAPI_VALID_GMI_SP_LEAGUE_TABLE_VER | \
    SXIAPI_VALID_GMI_SP_LEAGUE_CNT )

#define SXIAPI_VALID_GMI_SP_LEAGUE_INFO ( \
    SXIAPI_VALID_GMI_SP_LEAGUE_TABLE_INFO | \
    SXIAPI_VALID_GMI_SP_LEAGUE_ID | \
    SXIAPI_VALID_GMI_SP_LEAGUE_SHORT_NAME | \
    SXIAPI_VALID_GMI_SP_LEAGUE_LONG_NAME | \
    SXIAPI_VALID_GMI_SP_LEAGUE_TYPE | \
    SXIAPI_VALID_GMI_SP_LEAGUE_SF_ENABLED | \
    SXIAPI_VALID_GMI_SP_LEAGUE_SF_TIERS )

#define SXIAPI_VALID_GMI_SP_TEAM_TABLE_INFO ( \
    SXIAPI_VALID_GMI_SP_TEAM_TABLE_VER | \
    SXIAPI_VALID_GMI_SP_TEAM_CNT )

#define SXIAPI_VALID_GMI_SP_TEAM_INFO ( \
    SXIAPI_VALID_GMI_SP_TEAM_TABLE_INFO | \
    SXIAPI_VALID_GMI_SP_TEAM_ID | \
    SXIAPI_VALID_GMI_SP_TEAM_ABBREV | \
    SXIAPI_VALID_GMI_SP_TEAM_NAME | \
    SXIAPI_VALID_GMI_SP_TEAM_NICKNAME | \
    SXIAPI_VALID_GMI_SP_TEAM_LEAGUE_IDS | \
    SXIAPI_VALID_GMI_SP_TEAM_TIERS )

typedef struct sxiapi_ext_metadata_sports_team_struct
{
    UN16 un16TeamId;
    char acTeamAbbrev[SXIAPI_MAX_SPORTS_TEAM_ABBREV+1];
    char acTeamName[SXIAPI_MAX_SPORTS_TEAM_NAME+1];
    char acTeamNickname[SXIAPI_MAX_SPORTS_TEAM_NICKNAME+1];
    size_t tNumLeagues;
    UN8 aun8TeamLeagueList[SXIAPI_MAX_SPORTS_TEAM_LEAGUE_LIST_SIZE];
    size_t tNumTiers;
    UN8 aun8TeamTierList[SXIAPI_MAX_SPORTS_TEAM_TIER_LIST_SIZE];
    UN32 un32ValidFieldMask;
}SXIAPI_EXT_METADATA_SPORTS_TEAM_STRUCT;

typedef struct sxiapi_ext_metadata_sports_league_struct
{
    UN16 un16LeagueId;
    char acLeagueShortName[SXIAPI_MAX_SPORTS_LEAGUE_SHORT_NAME+1];
    char acLeagueLongName[SXIAPI_MAX_SPORTS_LEAGUE_LONG_NAME+1];
    char acLeagueType[SXIAPI_MAX_SPORTS_LEAGUE_TYPE+1];
    BOOLEAN bSportsFlashEnabled;
    UN8 un8SportsFlashTiers;
    UN32 un32ValidFieldMask;
}SXIAPI_EXT_METADATA_SPORTS_LEAGUE_STRUCT;

typedef union sxiapi_ext_metadata_sports_union
{
    SXIAPI_EXT_METADATA_SPORTS_TEAM_STRUCT sTeamStruct;
    SXIAPI_EXT_METADATA_SPORTS_LEAGUE_STRUCT sLeagueStruct;
} SXIAPI_EXT_METADATA_SPORTS_UNION;

typedef struct sxiapi_ext_metadata_sports_struct
{
    OSAL_OBJECT_HDL hLL;
    UN16 un16Version;
    UN16 un16Count;
    UN32 un32ValidFieldMask;
    UN8 un8Fields;

}SXIAPI_EXT_METADATA_SPORTS_STRUCT;

#define SXIAPI_VALID_GMI_FF_BANK_NONE        (0x00000000UL)
#define SXIAPI_VALID_GMI_FF_BANK_TBL_VER     (0x00000001UL)
#define SXIAPI_VALID_GMI_FF_BANK_CNT         (0x00000002UL)
#define SXIAPI_VALID_GMI_FF_BANK_ORDER       (0x00000004UL)
#define SXIAPI_VALID_GMI_FF_BANK_ID          (0x00000008UL)
#define SXIAPI_VALID_GMI_FF_BANK_SEQ         (0x00000010UL)
#define SXIAPI_VALID_GMI_FF_BANK_TTL_SHORT   (0x00000020UL)
#define SXIAPI_VALID_GMI_FF_BANK_TTL_LONG    (0x00000040UL)
#define SXIAPI_VALID_GMI_FF_BANK_TTL_VERBOSE (0x00000080UL)
#define SXIAPI_VALID_GMI_FF_BANK_DESCR       (0x00000100UL)
#define SXIAPI_VALID_GMI_FF_BANK_PURPOSE     (0x00000200UL)
#define SXIAPI_VALID_GMI_FF_BANK_ARR1        (0x00000400UL)
#define SXIAPI_VALID_GMI_FF_BANK_ARR2        (0x00000800UL)
#define SXIAPI_VALID_GMI_FF_BANK_ARR3        (0x00001000UL)
#define SXIAPI_VALID_GMI_FF_BANK_ARR4        (0x00002000UL)

#define SXIAPI_VALID_GMI_FF_TBL_INFO ( \
        SXIAPI_VALID_GMI_FF_BANK_TBL_VER | \
        SXIAPI_VALID_GMI_FF_BANK_CNT )

typedef struct sxiapi_ext_metadata_featured_favorites_struct
{
    UN16 un16Version;
    UN16 un16Count;
    UN32 un32ValueFieldMask;
    UN8 un8Fields;
    OSAL_OBJECT_HDL hLL;

} SXIAPI_EXT_METADATA_FEATURED_FAVORITES_STRUCT;

typedef struct sxiapi_ext_metadata_bank_struct
{
    UN8 un8Order;
    UN8 un8Id;
    UN8 un8Sequence;
    char acTitleShort[SXIAPI_MAX_BANK_TTL_SHORT+1];
    char acTitleLong[SXIAPI_MAX_BANK_TTL_LONG+1];
    char acTitleVerbose[SXIAPI_MAX_BANK_TTL_VERBOSE+1];
    char acDescription[SXIAPI_MAX_BANK_DESCR+1];
    UN8 un8Purpose;
    UN16 un16Arrangement[SXIAPI_MAX_BANK_ARR_CNT][SXIAPI_MAX_BANK_ARR];
    UN8 un8SIDCount[SXIAPI_MAX_BANK_ARR_CNT];
    UN32 un32ValueFieldMask;

} SXIAPI_EXT_METADATA_BANK_STRUCT;

typedef struct sxiapi_ext_metadata_teamleague_struct
{
    SXIAPI_EXT_METADATA_SPORTS_UNION uData;
}SXIAPI_EXT_METADATA_TEAMLEAGUE_STRUCT;

typedef struct sxiapi_ext_global_metadataind_struct
{
    UN8 un8Fields;
    SXIAPI_EXT_METADATA_SONG_TAG_SERVICE_STRUCT sSongTagServiceStruct;
    SXIAPI_EXT_METADATA_TRAFFIC_STRUCT sTrafficStruct;
    SXIAPI_EXT_METADATA_SPORTS_STRUCT sSportsStruct;
    SXIAPI_EXT_METADATA_FEATURED_FAVORITES_STRUCT sBankStruct;
    void *pvReleaseArg;

} SXIAPI_EXT_GLOBAL_METADATAIND_STRUCT;

typedef union sxiapi_ext_metadata_struct_union
{
    SXIAPI_EXT_METADATA_MARKET_STRUCT sTrafficStruct;
    SXIAPI_EXT_METADATA_TEAMLEAGUE_STRUCT sTeamLeagueStruct;
    SXIAPI_EXT_METADATA_BANK_STRUCT sBankStruct;

} SXIAPI_EXT_METADATA_STRUCT_UNION;

typedef struct sxiapi_ext_metadata_struct
{
    OSAL_LINKED_LIST_ENTRY hEntry;
    SXIAPI_EXT_METADATA_STRUCT_UNION uData;

} SXIAPI_EXT_METADATA_STRUCT;

// These defines are used to specify un8SeekControlMask parameter for
// SeekMonCmd message
#define SXIAPI_SEEK_CONTROL_END                      (0x01)
#define SXIAPI_SEEK_CONTROL_IMMEDIATE                (0x02)

#define SXIAPI_SEEK_CONTROL_ALL                      ( \
                SXIAPI_SEEK_CONTROL_END | \
                SXIAPI_SEEK_CONTROL_IMMEDIATE )

// ---- EXTENDED TRACK METADATA ----

// the max number of different TMIs defined
#define SXIAPI_MAX_EXT_METADATA_TMI_COUNT 16

// mapping TMIs
typedef enum sxiapi_tmi_enum
{
  // the tmi's map to tds. some of those fields are rx'd by the chipset but not
  // passed on to the host these are SID(= 0), SEQUENCE(= 1) and PID(= 2)
  // refer to SX-9845-0150
  SXIAPI_TMI_SONG_ID = 3,
  SXIAPI_TMI_ARTIST_ID = 4,
  SXIAPI_TMI_ALBUM_NAME = 7,
  SXIAPI_TMI_LEAGUE_BCAST_ID = 10,
  SXIAPI_TMI_TEAM_BCAST_ID = 11,
  SXIAPI_TMI_TRAFFIC_ID = 15,
  SXIAPI_TMI_ITUNES_SONG_ID = 16,
  SXIAPI_TMI_SPORT_BCAST_TYPE = 280,
} SXIAPI_TMI_ENUM;

// bitmasks used to indicate which TMIs are valid (i.e. which ones we just rx'd)
#define SXIAPI_VALID_TMI_NONE             (0x00000000UL)
#define SXIAPI_VALID_TMI_SONG_ID          (0x00000001UL)
#define SXIAPI_VALID_TMI_ARTIST_ID        (0x00000002UL)
#define SXIAPI_VALID_TMI_LEAGUE_BCAST_ID  (0x00000004UL)
#define SXIAPI_VALID_TMI_TEAM_BCAST_ID    (0x00000008UL)
#define SXIAPI_VALID_TMI_TRAFFIC_ID       (0x00000010UL)
#define SXIAPI_VALID_TMI_ITUNES_SONG_ID   (0x00000020UL)
#define SXIAPI_VALID_TMI_SPORT_BCAST_TYPE (0x00000040UL)
#define SXIAPI_VALID_TMI_ALBUM_NAME       (0x00000080UL)

// these TMIs are for music content
#define SXIAPI_VALID_TMI_MUSIC \
    ( SXIAPI_VALID_TMI_SONG_ID |\
      SXIAPI_VALID_TMI_ARTIST_ID |\
      SXIAPI_VALID_TMI_ITUNES_SONG_ID )

// these TMIs are for Sports content
#define SXIAPI_VALID_TMI_SPORTS \
    ( SXIAPI_VALID_TMI_LEAGUE_BCAST_ID |\
      SXIAPI_VALID_TMI_TEAM_BCAST_ID )

// extended metadata monitors (for use with ExtMetadataMonCmd)
typedef enum sxiapi_ext_metadata_monitor_enum
{
    SXIAPI_EXT_TRACK_METADATA_MONITOR_ACTIVE_BROWSED = 0,
    SXIAPI_EXT_TRACK_METADATA_MONITOR_ALL_AVAIL = 1,
    SXIAPI_EXT_CHANNEL_METADATA_MONITOR_ACTIVE_BROWSED = 2,
    SXIAPI_EXT_CHANNEL_METADATA_MONITOR_ALL_AVAIL = 3,
    SXIAPI_EXT_GLOBAL_METADATA_MONITOR = 4,
    SXIAPI_EXT_LA_METADATA_MONITOR_ALL_AVAIL = 5,
    SXIAPI_EXT_METADATA_MONITOR_INVALID

} SXIAPI_EXT_METADATA_MONITOR_ENUM;

// enum used for reporting broadcast type of sporting event
typedef enum sxiapi_sport_bcast_enum
{
    SXIAPI_SPORT_BCAST_NATIONAL = 0,
    SXIAPI_SPORT_BCAST_TEAM_2 = 1,
    SXIAPI_SPORT_BCAST_TEAM_1 = 2,
    SXIAPI_SPORT_BCAST_OTHER = 3,
    SXIAPI_SPORT_BCAST_INVALID

} SXIAPI_SPORT_BCAST_ENUM;


// the information sent in extended track metadata
typedef struct sxiapi_ext_track_metadata_struct
{
    UN32 un32SongId;
    UN32 un32ArtistId;
    char acAlbumName[SXIAPI_TRACK_METADATA_ALBUM_NAME_LENGTH];
    UN32 un32TrafficId;
    UN32 un32ITunesSongId;
    UN8  un8BCastLeagueId;
    UN32 aun32BCastTeamId[SXIAPI_TRACK_METADATA_NUM_TEAMS];
    UN8  un8SportBCastType;
    UN32 un32ValidFieldMask;
}SXIAPI_EXT_TRACK_METADATA_STRUCT;

// ---- EXTENDED CHANNEL METADATA ----

#define SXIAPI_MAX_EXT_METADATA_CMI_COUNT 8

// mapping CMIs
typedef enum sxiapi_cmi_enum
{
  SXIAPI_CMI_SHORT_CHAN_DESC = 64,
  SXIAPI_CMI_LONG_CHAN_DESC = 65,
  SXIAPI_CMI_RELATED_CHAN_LIST = 66,
  SXIAPI_CMI_CHAN_LIST_ORDER = 68,
  SXIAPI_CMI_PLAY_ON_SELECT = 69,
  SXIAPI_CMI_CHAN_CONTENT_TYPE = 70,
  SXIAPI_CMI_IR_NAVIGATION_CLASS = 71,
  SXIAPI_CMI_SHADOW_RECORD_CLASS = 72

} SXIAPI_CMI_ENUM;

// bitmasks used to indicate which CMIs are valid (i.e. which ones we just rx'd)
#define SXIAPI_VALID_CMI_NONE                 (0x00000000UL)
#define SXIAPI_VALID_CMI_SHORT_CHAN_DESC      (0x00000001UL)
#define SXIAPI_VALID_CMI_LONG_CHAN_DESC       (0x00000002UL)
#define SXIAPI_VALID_CMI_RELATED_CHAN_LIST    (0x00000004UL)
#define SXIAPI_VALID_CMI_CHAN_LIST_ORDER      (0x00000008UL)
#define SXIAPI_VALID_CMI_PLAY_ON_SELECT       (0x00000010UL)
#define SXIAPI_VALID_CMI_CHAN_CONTENT_TYPE    (0x00000020UL)
#define SXIAPI_VALID_CMI_IR_NAVIGATION_CLASS  (0x00000040UL)
#define SXIAPI_VALID_CMI_SHADOW_RECORD_CLASS  (0x00000080UL)

// the information sent in extended channle metadata
typedef struct sxiapi_ext_chan_metadata_struct
{
    char acShortDesc[SXIAPI_MAX_CHAN_SHORT_DESC+1];
    char acLongDesc[SXIAPI_MAX_CHAN_LONG_DESC+1];
    UN16 aun16RelatedChan[SXIAPI_MAX_RELATED_CHAN];
    UN32 un32NumChans;
    UN8  un8PlayOnSelect;
    UN8  un8ContentType;
    UN8  un8IRNavigationClass;
    UN16 un16ACO;
    UN32 un32ValidFieldMask;

}SXIAPI_EXT_CHAN_METADATA_STRUCT;

// SXIAPI_MAX_EXT_METADATA_EMI_COUNT is the largest of the three:
// SXIAPI_MAX_EXT_METADATA_GMI_COUNT
// SXIAPI_MAX_EXT_METADATA_TMI_COUNT
// SXIAPI_MAX_EXT_METADATA_CMI_COUNT
#define SXIAPI_MAX_EXT_METADATA_EMI_COUNT \
    (SXIAPI_MAX_EXT_METADATA_GMI_COUNT > SXIAPI_MAX_EXT_METADATA_TMI_COUNT ?   \
      (SXIAPI_MAX_EXT_METADATA_GMI_COUNT > SXIAPI_MAX_EXT_METADATA_CMI_COUNT ? \
       SXIAPI_MAX_EXT_METADATA_GMI_COUNT : SXIAPI_MAX_EXT_METADATA_CMI_COUNT ):\
      (SXIAPI_MAX_EXT_METADATA_TMI_COUNT > SXIAPI_MAX_EXT_METADATA_CMI_COUNT ? \
       SXIAPI_MAX_EXT_METADATA_TMI_COUNT : SXIAPI_MAX_EXT_METADATA_CMI_COUNT ))\

typedef struct sxiapi_track_info_struct
{
    SXIAPI_PROGRAM_ID tProgID;

    char acArtistBasic [SXIAPI_MAX_ARTIST_LENGTH+1];
    char acArtistExtd [SXIAPI_MAX_ARTIST_LENGTH+1];
    char acSongBasic [SXIAPI_MAX_SONG_LENGTH+1];
    char acSongExtd [SXIAPI_MAX_SONG_LENGTH+1];
    char acContentInfo [SXIAPI_MAX_CONTENT_INFO_LENGTH+1];

    UN8 un8TrackMetaDataCnt;
    SXIAPI_EXT_TRACK_METADATA_STRUCT sExtTrackMetaData;

}SXIAPI_TRACK_INFO_STRUCT;

typedef struct sxiapi_catinfoind_struct
{
    SXIAPI_CATEGORY_ID tCatID;
    SXIAPI_BDCAST_NAMES_STRUCT sCatNames;

} SXIAPI_CATINFOIND_STRUCT;

typedef struct sxiapi_chan_metadata_struct
{
    SXIAPI_CHANNEL_ID tChanID;
    SXIAPI_SID tSID;
    UN8 un8ChanMetadataCnt;
    SXIAPI_EXT_CHAN_METADATA_STRUCT sExtChanMetaData;

} SXIAPI_CHAN_METADATA_STRUCT;

typedef struct sxiapi_channel_struct
{
    SXIAPI_CHANNEL_ID tChanID;
    SXIAPI_SID tSID;
    SXIAPI_CATEGORY_ID tCatID;
    SXIAPI_CATEGORY_ID tRefCatID;

    SXIAPI_CH_ATTRIB tChanAttrib;
    SXIAPI_BDCAST_NAMES_STRUCT sChanNames;

    UN8 un8RecRes;

    SXIAPI_CHAN_METADATA_STRUCT sChanMetaData;

} SXIAPI_CHANNEL_STRUCT;

typedef struct sxiapi_chaninfoind_struct
{
    SXIAPI_CHANNEL_STRUCT sChannel;
} SXIAPI_CHANINFOIND_STRUCT;

typedef struct sxiapi_chanvectorind_struct
{
    UN8 aun8CatIDVector[SXIAPI_CAT_ID_VECTOR_SIZE];

} SXIAPI_CHANVECTORIND_STRUCT;

typedef struct sxiapi_chanbrowseselectind_struct
{
    SXIAPI_CHANNEL_STRUCT sChannel;
    SXIAPI_BDCAST_NAMES_STRUCT sCatNames;
    SXIAPI_TRACK_INFO_STRUCT sTrackInfo;
    SXIAPI_SECONDARY_ID tSecondaryID;

} SXIAPI_CHANBROWSESELECTIND_STRUCT;

typedef struct sxiapi_metadataind_struct
{
    SXIAPI_CHANNEL_STRUCT sChannel;
    UN32 un32ProgramId;
    SXIAPI_TRACK_INFO_STRUCT sTrackInfo;

} SXIAPI_METADATAIND_STRUCT;

typedef enum sxiapi_mute_enum
{
    SXIAPI_MUTE_UNMUTE = 0,
    SXIAPI_MUTE_AUDIO,
    SXIAPI_MUTE_AUDIO_AND_I2S,
    SXIAPI_MUTE_UNKNOWN

} SXIAPI_MUTE_ENUM;

typedef enum sxiapi_exciter_enum
{
    SXIAPI_EXCITER_OFF = 0,
    SXIAPI_EXCITER_ON,
    SXIAPI_EXCITER_UNKNOWN

} SXIAPI_EXCITER_ENUM;

// max freq value (UN8_MAX hHz conerted to Hz)
#define SXIAPI_TONE_GEN_MAX_FREQ_HZ (25500)

#define SXIAPI_TONE_GEN_MIN_VOL_ADJ    (-39) // dB
#define SXIAPI_TONE_GEN_MAX_VOL_ADJ      (0) // dB

// 1.5 dB steps, so to convert requested volume adj
// divide by 1.5 or like we will do:
// multiply by 2 then divide by 3
#define SXIAPI_TONE_GEN_SCALE_NUMERATOR        (2)
#define SXIAPI_TONE_GEN_SCALE_DENOMINATORATOR  (3)

#define SXIAPI_VOL_MIN (-96)
#define SXIAPI_VOL_MAX (24)

#define SXIAPI_TONAL_ADJ_MIN (-12)
#define SXIAPI_TONAL_ADJ_MAX (12)

#define SXIAPI_MAX_EQ_BANDS (10)

#define SXIAPI_IR_PLAYBACK_BEGINNING_STORED 0x08
#define SXIAPI_IR_PLAYBACK_END_STORED 0x10

typedef enum sxiapi_playback_state_enum
{
    SXIAPI_PLAYBACK_STATE_INACTIVE = 0,
    SXIAPI_PLAYBACK_STATE_PAUSED = 1,
    SXIAPI_PLAYBACK_STATE_PLAYING = 2,
    SXIAPI_PLAYBACK_STATE_FF = 3,
    SXIAPI_PLAYBACK_STATE_REW = 4,
    SXIAPI_PLAYBACK_STATE_UNKNOWN

} SXIAPI_PLAYBACK_STATE_ENUM;

typedef enum sxiapi_ir_control_enum
{
    SXIAPI_IR_CONTROL_LIVE =                        1,
    SXIAPI_IR_CONTROL_PLAY =                        2,
    SXIAPI_IR_CONTROL_PAUSE =                       3,
    SXIAPI_IR_CONTROL_NEXT =                        4,
    SXIAPI_IR_CONTROL_PREV =                        5,
    SXIAPI_IR_CONTROL_JUMP_TO_START_PAUSE =         6,
    SXIAPI_IR_CONTROL_JUMP_TO_PLAYBACK_ID_PAUSE =   7,
    SXIAPI_IR_CONTROL_JUMP_TO_TIME_OFFSET_PAUSE =   8,
    SXIAPI_IR_CONTROL_NEXT_RESUME =                 9,
    SXIAPI_IR_CONTROL_PREVIOUS_RESUME =            10,
    SXIAPI_IR_CONTROL_JUMP_TO_START_RESUME =       11,
    SXIAPI_IR_CONTROL_JUMP_TO_PLAYBACK_ID_RESUME = 12,
    SXIAPI_IR_CONTROL_JUMP_TO_TIME_OFFSET_RESUME = 13,
    SXIAPI_IR_CONTROL_UNKNOWN

} SXIAPI_IR_CONTROL_ENUM;

typedef struct sxiapi_irplaybackinfo_struct
{
    SXIAPI_PLAYBACK_STATE_ENUM eState;
    UN8 un8Position;
    UN16 un16PlaybackId;
    UN16 un16DurationOfTrack;
    UN16 un16TimeFromStartOfTrack;
    UN16 un16TracksRemaining;
    UN16 un16TimeRemaining;
    UN16 un16TimeBefore;

} SXIAPI_IRPLAYBACKINFO_STRUCT;

typedef struct sxiapi_ir_playback_metadata_ind_struct
{
    UN8 un8Status;
    UN16 un16PlaybackId;
    SXIAPI_CHANNEL_ID tChanID;
    SXIAPI_BDCAST_NAMES_STRUCT sChanNames; // chan short med long
    SXIAPI_CATINFOIND_STRUCT sCatInfo; // cat id, cat short med long
    SXIAPI_CHAN_METADATA_STRUCT sChanMetaData;  // ext chan meta
    SXIAPI_TRACK_INFO_STRUCT sTrackInfo; // prog id, artist, title, content info, ext track meta
    SXIAPI_SID tSID; // service identifier

} SXIAPI_IR_PLAYBACK_METADATA_IND_STRUCT;

typedef struct sxiapi_ir_record_metadata_ind_struct
{
    UN16 un16Duration;
    SXIAPI_IR_PLAYBACK_METADATA_IND_STRUCT sMetaData;
}
SXIAPI_IR_RECORD_METADATA_IND_STRUCT;

typedef struct sxiapi_ir_record_info_ind_struct
{
    UN8 un8RecordState;
    UN8 un8BufferUsage;
    UN16 un16NewestPlaybackId;
    UN16 un16OldestPlaybackId;
    UN16 un16DurationOfNewestTrack;
    UN16 un16DurationOfOldestTrack;
} SXIAPI_IR_RECORD_INFO_IND_STRUCT;

typedef enum sxiapi_dataservice_monitor_op_enum
{
    SXIAPI_DATASERVICE_MONITOR_OP_START=0,
    SXIAPI_DATASERVICE_MONITOR_OP_STOP,
    SXIAPI_DATASERVICE_MONITOR_OP_STOP_ALL,
    SXIAPI_DATASERVICE_MONITOR_OP_INVALID
} SXIAPI_DATASERVICE_MONITOR_OP_ENUM;

typedef enum sxiapi_dataservice_filter_update_type_enum
{
    SXIAPI_DATASERVICE_FILTER_UPDATE_TYPE_START=0,
    SXIAPI_DATASERVICE_FILTER_UPDATE_TYPE_HALT,
    SXIAPI_DATASERVICE_FILTER_UPDATE_TYPE_INVALID
} SXIAPI_DATASERVICE_FILTER_UPDATE_TYPE_ENUM;

typedef enum sxiapi_dataservice_status_enum
{
    SXIAPI_DATASERVICE_STATUS_FULLY_SUBSCRIBED = 0,
    SXIAPI_DATASERVICE_STATUS_PARTIALLY_SUBSCRIBED,
    SXIAPI_DATASERVICE_STATUS_UNSUBSCRIBED,
    SXIAPI_DATASERVICE_STATUS_INVALID_DSI,
    SXIAPI_DATASERVICE_STATUS_INSUF_SYS_RESOURCES,
    SXIAPI_DATASERVICE_STATUS_UNKNOWN   // not sent by radio, used internally by SMS

} SXIAPI_DATASERVICE_STATUS_ENUM;

typedef struct sxiapi_dataservicestatusind_struct
{
    SXIAPI_DSI tDSI;
    SXIAPI_DATASERVICE_STATUS_ENUM eStatus;
    UN8 un8DMICount;
    SXIAPI_DMI atDMIs[SXIAPI_DMI_CNT_MAX];

} SXIAPI_DATASERVICESTATUSIND_STRUCT;

typedef enum sxiapi_data_packet_type_enum
{
    SXIAPI_DATA_PACKET_TYPE_SDTP=0,
    SXIAPI_DATA_PACKET_TYPE_XMAPP,
    SXIAPI_DATA_PACKET_TYPE_RAW

} SXIAPI_DATA_PACKET_TYPE_ENUM;


typedef enum sxiapi_pkg_cmd_option_enum
{
    SXIAPI_PKG_CMD_OPTION_QUERY = 0,
    SXIAPI_PKG_CMD_OPTION_SELECT = 1,
    SXIAPI_PKG_CMD_OPTION_VALIDATE = 2,
    SXIAPI_PKG_CMD_OPTION_REPORT = 3,
    SXIAPI_PKG_CMD_OPTION_UNKNOWN
} SXIAPI_PKG_CMD_OPTION_ENUM;

typedef struct sxiapi_pkgind_struct
{
    size_t tNumBytes;
    UN8 *pun8PkgInd;

} SXIAPI_PKG_IND_STRUCT;

typedef union sxiapi_seekmon_matched_value_union
{
    UN8 un8Val;
    UN16 un16Val;
    UN32 un32Val;
} SXIAPI_SEEKMON_MATCHED_VALUE_UNION;

typedef struct sxiapi_seekmon_ind_struct
{
    SXIAPI_CHANNEL_ID tChanID;
    SXIAPI_SID tSID;
    SXIAPI_CH_ATTRIB tChanAttrib;
    UN8 un8SeekMonID;
    SXIAPI_METADATA_IDENTIFIER tMatchedTMI;
    SXIAPI_SEEKMON_MATCHED_VALUE_UNION uMatchedVal;
    SXIAPI_TRACK_INFO_STRUCT sTrackInfo;
} SXIAPI_SEEKMON_IND_STRUCT;

typedef enum sxiapi_flash_type_enum
{
    SXIAPI_FLASH_TYPE_SPORTS_FLASH = 0,

    SXIAPI_FLASH_TYPE_INVALID
} SXIAPI_FLASH_TYPE_ENUM;

typedef enum sxiapi_flash_status_enum
{
    SXIAPI_FLASH_STATUS_ALERT = 0,
    SXIAPI_FLASH_STATUS_EXPIRED = 1,
    SXIAPI_FLASH_STATUS_PLAYED = 2,

    SXIAPI_FLASH_STATUS_INVALID
} SXIAPI_FLASH_STATUS_ENUM;

#define SXIAPI_FLASH_EVENT_URGENCY_MASK       (0x07)
#define SXIAPI_SPORTS_FLASH_SUPPORTED_URGENCY (7)
#define SXIAPI_SPORTS_FLASH_EXPIRY_URGENCY    (0)

typedef struct sxiapi_flash_ind_struct
{
    SXIAPI_CHANNEL_ID tChanID;
    SXIAPI_SID tSID;
    SXIAPI_PROGRAM_ID tProgID;
    SXIAPI_CH_ATTRIB tChanAttrib;
    SXIAPI_FLASH_TYPE_ENUM eFlashType;
    SXIAPI_FLASH_STATUS_ENUM eFlashStatus;
    SXIAPI_FLASH_EVENT_ID tFlashEventID;
    UN32 un32FlashEventData;
    SXIAPI_BDCAST_NAMES_STRUCT sChanNames;
} SXIAPI_FLASH_IND_STRUCT;

typedef UN16 SXIAPI_BULLETIN_ID;

typedef enum sxiapi_bulletin_type_enum
{
    SXIAPI_BULLETIN_TYPE_TW_NOW = 0,

    SXIAPI_BULLETIN_TYPE_INVALID
} SXIAPI_BULLETIN_TYPE_ENUM;

typedef enum sxiapi_bulletin_status_enum
{
    SXIAPI_BULLETIN_STATUS_NOT_AVAILABLE = 0,
    SXIAPI_BULLETIN_STATUS_NEW_AVAILABLE = 1,
    SXIAPI_BULLETIN_STATUS_PLAYED_AVAILABLE = 2,

    SXIAPI_BULLETIN_STATUS_INVALID
} SXIAPI_BULLETIN_STATUS_ENUM;

typedef struct sxiapi_bulletin_status_ind_struct
{
    SXIAPI_BULLETIN_TYPE_ENUM eType;
    SXIAPI_BULLETIN_ID tBulletinID;
    UN16 un16Param1;
    SXIAPI_BULLETIN_STATUS_ENUM eStatus;
} SXIAPI_BULLETIN_STATUS_IND_STRUCT;

typedef struct sxiapi_content_buffered_ind_struct
{
    SXIAPI_CHANNEL_ID tChanID;
    SXIAPI_SID tSID;
    UN8 un8ProgramIDCnt;
    SXIAPI_PROGRAM_ID *ptProgramIDList;
} SXIAPI_CONTENT_BUFFERED_IND_STRUCT;

/**/

typedef union sxiapi_ind_data_union
{
    SXIAPI_MODULECFGIND_STRUCT sModCfg;

    SXIAPI_SUBSTATUSIND_STRUCT sSubStatus;
    SXIAPI_TIMEIND_STRUCT sTime;
    SXIAPI_STATUSIND_STRUCT sStatus;
    SXIAPI_EVENTIND_STRUCT sEvent;
    SXIAPI_DISPADVISORYIND_STRUCT sDisplay;

    SXIAPI_CATINFOIND_STRUCT sCatInfo;

    SXIAPI_CHANINFOIND_STRUCT sChanInfo;
    SXIAPI_CHANVECTORIND_STRUCT sChanVector;
    SXIAPI_CHANBROWSESELECTIND_STRUCT sChanBrowseSelect;
    SXIAPI_METADATAIND_STRUCT sMetaData;
    SXIAPI_CHAN_METADATA_STRUCT sChanMetaData;
    SXIAPI_EXT_GLOBAL_METADATAIND_STRUCT sGlobalMetaData;
    SXIAPI_DATASERVICESTATUSIND_STRUCT sDataStatus;
    SXIAPI_IRPLAYBACKINFO_STRUCT sIRPlayback;
    SXIAPI_IR_RECORD_INFO_IND_STRUCT sIRRecordInfo;
    SXIAPI_IR_PLAYBACK_METADATA_IND_STRUCT sIRPlaybackMetadataInfo;
    SXIAPI_IR_RECORD_METADATA_IND_STRUCT sIRRecordMetadataInfo;
    SXIAPI_PKG_IND_STRUCT sPkg;
    SXIAPI_SEEKMON_IND_STRUCT sSeekMon;
    SXIAPI_FLASH_IND_STRUCT sFlash;
    SXIAPI_BULLETIN_STATUS_IND_STRUCT sBulletinStatus;
    SXIAPI_CONTENT_BUFFERED_IND_STRUCT sContentBuffered;

} SXIAPI_IND_DATA_UNION;

typedef struct sxiapi_ind_data_struct
{
    SXIAPI_INDCODE_ENUM eIndCode;
    SXIAPI_IND_DATA_UNION uData;

}SXIAPI_IND_DATA_STRUCT;

typedef struct sxiapi_uart_link_start_resp_data_struct
{
    UN8 un8StatusCode;

} SXIAPI_UART_LINK_START_RESP_DATA_STRUCT;

typedef struct sxiapi_uart_link_stats_resp_data_struct
{
    UN32 un32NumBytesRcvd;
    UN32 un32NumBytesXmtd;
    UN32 un32NumMsgFramesRcvd;
    UN32 un32NumMsgFramesXmtd;
    UN32 un32IndicationResends;

} SXIAPI_UART_LINK_STATS_RESP_DATA_STRUCT;

typedef struct sxiapi_uart_link_error_data_struct
{
    UN8 un8ErrorCode;

} SXIAPI_UART_LINK_ERROR_DATA_STRUCT;

typedef union sxiapi_resp_data_union
{
    SXIAPI_STATUSCODE_ENUM eStatusCode;
    SXIAPI_UART_LINK_START_RESP_DATA_STRUCT sUartLinkStartResponse;
    SXIAPI_UART_LINK_STATS_RESP_DATA_STRUCT sUartLinkStatsResponse;
    SXIAPI_UART_LINK_ERROR_DATA_STRUCT sUartLinkError;

}SXIAPI_RESP_DATA_UNION;

typedef union sxiapi_rx_union
{
    SXIAPI_IND_DATA_STRUCT sInd;
    SXIAPI_RESP_DATA_UNION uResp;

} SXIAPI_RX_UNION;

typedef void (* SXIAPI_RX_RELEASE_HANDLER)(SXIAPI_RX_UNION *puData);

typedef struct sxi_instance_struct
{
    // In-use syncronization object
    OSAL_OBJECT_HDL hMutex;

    // In-use counter
    size_t tAllocationCount;

    // Rx data release handler
    SXIAPI_RX_RELEASE_HANDLER tvReleaseFunction;

} SXI_INSTANCE_STRUCT;

typedef struct sxi_msg_hdr_struct
{
    // Op-type and transaction id for this msg
    SXIAPI_OPTYPE tOpType;
    SXIAPI_TRANID tTransactionID;

} SXI_MSG_HDR_STRUCT;

typedef struct sxiapi_rx_struct
{
    // Instance
    SXI_INSTANCE_STRUCT sInstance;

    // SXi msg hdr
    SXI_MSG_HDR_STRUCT sHdr;

    // Rx parsed data
    SXIAPI_RX_UNION uData;

} SXIAPI_RX_STRUCT;

typedef struct sxiapi_rx_payload_struct
{
    // SXi msg hdr
    SXI_MSG_HDR_STRUCT sHdr;

    // rx payload
    OSAL_BUFFER_HDL hPayload;

} SXIAPI_RX_PAYLOAD_STRUCT;

typedef struct sxiapi_data_payload_event_struct
{
    SXIAPI_DSI tDSI;
    SXIAPI_DATA_PACKET_TYPE_ENUM eType;
    OSAL_BUFFER_HDL hPayload;
    OSAL_OBJECT_HDL hBlockPool;

} SXIAPI_DATA_PAYLOAD_EVENT_STRUCT;

/* Processing Global Metadata */

#ifdef OS_WINCE

#define SXIAPI_GMI_MASK_NONE                    (0x0000000000000000)
#define SXIAPI_GMI_MASK_CHAN_TABLE_VER          (0x0000000000000001)
#define SXIAPI_GMI_MASK_CHAN_COUNT              (0x0000000000000002)
#define SXIAPI_GMI_MASK_ITUNES_URL              (0x0000000000000004)
#define SXIAPI_GMI_MASK_TRAFFIC_TABLE_VER       (0x0000000000000008)
#define SXIAPI_GMI_MASK_CITY_COUNT              (0x0000000000000010)
#define SXIAPI_GMI_MASK_CITY_ID                 (0x0000000000000020)
#define SXIAPI_GMI_MASK_CITY_ABBREV             (0x0000000000000040)
#define SXIAPI_GMI_MASK_CITY_NAME               (0x0000000000000080)
#define SXIAPI_GMI_MASK_TEAM_TABLE_VER          (0x0000000000000100)
#define SXIAPI_GMI_MASK_TEAM_CNT                (0x0000000000000200)
#define SXIAPI_GMI_MASK_TEAM_ID                 (0x0000000000000400)
#define SXIAPI_GMI_MASK_TEAM_ABBREV             (0x0000000000000800)
#define SXIAPI_GMI_MASK_TEAM_NAME               (0x0000000000001000)
#define SXIAPI_GMI_MASK_TEAM_NICKNAME           (0x0000000000002000)
#define SXIAPI_GMI_MASK_TEAM_LEAGUE_IDS         (0x0000000000004000)
#define SXIAPI_GMI_MASK_TEAM_TIERS              (0x0000000000008000)
#define SXIAPI_GMI_MASK_LEAGUE_TABLE_VER        (0x0000000000010000)
#define SXIAPI_GMI_MASK_LEAGUE_CNT              (0x0000000000020000)
#define SXIAPI_GMI_MASK_LEAGUE_ID               (0x0000000000040000)
#define SXIAPI_GMI_MASK_LEAGUE_SHORT_NAME       (0x0000000000080000)
#define SXIAPI_GMI_MASK_LEAGUE_LONG_NAME        (0x0000000000100000)
#define SXIAPI_GMI_MASK_LEAGUE_TYPE             (0x0000000000200000)
#define SXIAPI_GMI_MASK_LEAGUE_SF_ENABLED       (0x0000000000400000)
#define SXIAPI_GMI_MASK_LEAGUE_SF_TIERS         (0x0000000000800000)
#define SXIAPI_GMI_MASK_FF_TABLE_VER            (0x0000000001000000)
#define SXIAPI_GMI_MASK_FF_CNT                  (0x0000000002000000)
#define SXIAPI_GMI_MASK_FF_BANK_ORDER           (0x0000000004000000)
#define SXIAPI_GMI_MASK_FF_BANK_ID              (0x0000000008000000)
#define SXIAPI_GMI_MASK_FF_BANK_SEQ             (0x0000000010000000)
#define SXIAPI_GMI_MASK_FF_BANK_TTL_SHORT       (0x0000000020000000)
#define SXIAPI_GMI_MASK_FF_BANK_TTL_LONG        (0x0000000040000000)
#define SXIAPI_GMI_MASK_FF_BANK_TTL_VERBOSE     (0x0000000080000000)
#define SXIAPI_GMI_MASK_FF_BANK_DESCR           (0x0000000100000000)
#define SXIAPI_GMI_MASK_FF_BANK_PURPOSE         (0x0000000200000000)
#define SXIAPI_GMI_MASK_FF_BANK_ARR_1           (0x0000000400000000)
#define SXIAPI_GMI_MASK_FF_BANK_ARR_2           (0x0000000800000000)
#define SXIAPI_GMI_MASK_FF_BANK_ARR_3           (0x0000001000000000)
#define SXIAPI_GMI_MASK_FF_BANK_ARR_4           (0x0000002000000000)

#else

#define SXIAPI_GMI_MASK_NONE                    (0x0000000000000000ULL)

#define SXIAPI_GMI_MASK_CHAN_TABLE_VER          (0x0000000000000001ULL)
#define SXIAPI_GMI_MASK_CHAN_COUNT              (0x0000000000000002ULL)
#define SXIAPI_GMI_MASK_ITUNES_URL              (0x0000000000000004ULL)
#define SXIAPI_GMI_MASK_TRAFFIC_TABLE_VER       (0x0000000000000008ULL)
#define SXIAPI_GMI_MASK_CITY_COUNT              (0x0000000000000010ULL)
#define SXIAPI_GMI_MASK_CITY_ID                 (0x0000000000000020ULL)
#define SXIAPI_GMI_MASK_CITY_ABBREV             (0x0000000000000040ULL)
#define SXIAPI_GMI_MASK_CITY_NAME               (0x0000000000000080ULL)
#define SXIAPI_GMI_MASK_TEAM_TABLE_VER          (0x0000000000000100ULL)
#define SXIAPI_GMI_MASK_TEAM_CNT                (0x0000000000000200ULL)
#define SXIAPI_GMI_MASK_TEAM_ID                 (0x0000000000000400ULL)
#define SXIAPI_GMI_MASK_TEAM_ABBREV             (0x0000000000000800ULL)
#define SXIAPI_GMI_MASK_TEAM_NAME               (0x0000000000001000ULL)
#define SXIAPI_GMI_MASK_TEAM_NICKNAME           (0x0000000000002000ULL)
#define SXIAPI_GMI_MASK_TEAM_LEAGUE_IDS         (0x0000000000004000ULL)
#define SXIAPI_GMI_MASK_TEAM_TIERS              (0x0000000000008000ULL)
#define SXIAPI_GMI_MASK_LEAGUE_TABLE_VER        (0x0000000000010000ULL)
#define SXIAPI_GMI_MASK_LEAGUE_CNT              (0x0000000000020000ULL)
#define SXIAPI_GMI_MASK_LEAGUE_ID               (0x0000000000040000ULL)
#define SXIAPI_GMI_MASK_LEAGUE_SHORT_NAME       (0x0000000000080000ULL)
#define SXIAPI_GMI_MASK_LEAGUE_LONG_NAME        (0x0000000000100000ULL)
#define SXIAPI_GMI_MASK_LEAGUE_TYPE             (0x0000000000200000ULL)
#define SXIAPI_GMI_MASK_LEAGUE_SF_ENABLED       (0x0000000000400000ULL)
#define SXIAPI_GMI_MASK_LEAGUE_SF_TIERS         (0x0000000000800000ULL)
#define SXIAPI_GMI_MASK_FF_TABLE_VER            (0x0000000001000000ULL)
#define SXIAPI_GMI_MASK_FF_CNT                  (0x0000000002000000ULL)
#define SXIAPI_GMI_MASK_FF_BANK_ORDER           (0x0000000004000000ULL)
#define SXIAPI_GMI_MASK_FF_BANK_ID              (0x0000000008000000ULL)
#define SXIAPI_GMI_MASK_FF_BANK_SEQ             (0x0000000010000000ULL)
#define SXIAPI_GMI_MASK_FF_BANK_TTL_SHORT       (0x0000000020000000ULL)
#define SXIAPI_GMI_MASK_FF_BANK_TTL_LONG        (0x0000000040000000ULL)
#define SXIAPI_GMI_MASK_FF_BANK_TTL_VERBOSE     (0x0000000080000000ULL)
#define SXIAPI_GMI_MASK_FF_BANK_DESCR           (0x0000000100000000ULL)
#define SXIAPI_GMI_MASK_FF_BANK_PURPOSE         (0x0000000200000000ULL)
#define SXIAPI_GMI_MASK_FF_BANK_ARR_1           (0x0000000400000000ULL)
#define SXIAPI_GMI_MASK_FF_BANK_ARR_2           (0x0000000800000000ULL)
#define SXIAPI_GMI_MASK_FF_BANK_ARR_3           (0x0000001000000000ULL)
#define SXIAPI_GMI_MASK_FF_BANK_ARR_4           (0x0000002000000000ULL)

#endif

#define SXIAPI_GMI_ALL (\
        SXIAPI_GMI_MASK_CHAN_TABLE_VER |\
        SXIAPI_GMI_MASK_CHAN_COUNT |\
        SXIAPI_GMI_MASK_ITUNES_URL |\
        SXIAPI_GMI_MASK_TRAFFIC_TABLE_VER |\
        SXIAPI_GMI_MASK_CITY_COUNT |\
        SXIAPI_GMI_MASK_CITY_ID |\
        SXIAPI_GMI_MASK_CITY_ABBREV |\
        SXIAPI_GMI_MASK_CITY_NAME |\
        SXIAPI_GMI_MASK_TEAM_TABLE_VER |\
        SXIAPI_GMI_MASK_TEAM_CNT |\
        SXIAPI_GMI_MASK_TEAM_ID |\
        SXIAPI_GMI_MASK_TEAM_ABBREV |\
        SXIAPI_GMI_MASK_TEAM_NAME |\
        SXIAPI_GMI_MASK_TEAM_NICKNAME |\
        SXIAPI_GMI_MASK_TEAM_LEAGUE_IDS |\
        SXIAPI_GMI_MASK_TEAM_TIERS |\
        SXIAPI_GMI_MASK_LEAGUE_TABLE_VER |\
        SXIAPI_GMI_MASK_LEAGUE_CNT |\
        SXIAPI_GMI_MASK_LEAGUE_ID |\
        SXIAPI_GMI_MASK_LEAGUE_SHORT_NAME |\
        SXIAPI_GMI_MASK_LEAGUE_LONG_NAME |\
        SXIAPI_GMI_MASK_LEAGUE_TYPE |\
        SXIAPI_GMI_MASK_LEAGUE_SF_ENABLED |\
        SXIAPI_GMI_MASK_LEAGUE_SF_TIERS |\
        SXIAPI_GMI_MASK_FF_TABLE_VER |\
        SXIAPI_GMI_MASK_FF_CNT   |\
        SXIAPI_GMI_MASK_FF_BANK_ORDER |\
        SXIAPI_GMI_MASK_FF_BANK_ID |\
        SXIAPI_GMI_MASK_FF_BANK_SEQ |\
        SXIAPI_GMI_MASK_FF_BANK_TTL_SHORT |\
        SXIAPI_GMI_MASK_FF_BANK_TTL_LONG |\
        SXIAPI_GMI_MASK_FF_BANK_TTL_VERBOSE |\
        SXIAPI_GMI_MASK_FF_BANK_DESCR |\
        SXIAPI_GMI_MASK_FF_BANK_PURPOSE |\
        SXIAPI_GMI_MASK_FF_BANK_ARR_1 |\
        SXIAPI_GMI_MASK_FF_BANK_ARR_2 |\
        SXIAPI_GMI_MASK_FF_BANK_ARR_3 |\
        SXIAPI_GMI_MASK_FF_BANK_ARR_4)

  /*****************************/
 /** GLOBAL STRUCT TEMPLATES **/
/*****************************/

  /****************************/
 /** GLOBAL UNION TEMPLATES **/
/****************************/

  /**********************/
 /** GLOBAL VARIABLES **/
/**********************/

  /*******************/
 /** GLOBAL MACROS **/
/*******************/

  /***********************/
 /** GLOBAL PROTOTYPES **/
/***********************/

/*
 * Link APIs
 */

SXIAPI_STATUSCODE_ENUM SXIAPI_eUARTLinkStartCmd (
    STI_HDL hSTI,
    SXIAPI_UARTCONTROL_ENUM eValue
        );

SXIAPI_STATUSCODE_ENUM SXIAPI_eUARTLinkStatsCmd (
    STI_HDL hSTI,
    UN8 un8ResetStats
        );

/*
 * Command and Control -- Config APIs
 */

SXIAPI_STATUSCODE_ENUM SXIAPI_eModuleCfgCmd (
    STI_HDL hSTI,
    SXIAPI_MODULECFGCMD_STRUCT const *psCfg
        );

SXIAPI_STATUSCODE_ENUM SXIAPI_ePwrModeCmd (
    STI_HDL hSTI,
    SXIAPI_PWRMODE_ENUM ePwrMode
        );

SXIAPI_STATUSCODE_ENUM SXIAPI_eTimeCfgCmd (
    STI_HDL hSTI,
    SXIAPI_TIMEZONE_ENUM eTimeZone,
    BOOLEAN bEnableDST
        );

/*
 * Command and Control -- Status APIs
 */

SXIAPI_STATUSCODE_ENUM SXIAPI_eStatusMonCmd (
    STI_HDL hSTI,
    SXIAPI_MONITOR_OP_ENUM eOperation,
    const UN8 un8ListCnt,
    const SXIAPI_STATUS_ITEM_ENUM *peMonitorList
        );

SXIAPI_STATUSCODE_ENUM SXIAPI_eFeatureMonCmd (
    STI_HDL hSTI,
    SXIAPI_MONITOR_OP_ENUM eOperation,
    UN8 un8ListCnt,
    const SXIAPI_FEATURE_MONITOR_ENUM *peMonitorList
        );

SXIAPI_STATUSCODE_ENUM SXIAPI_ePingCmd (
    STI_HDL hSTI
        );

/*
 * Command and Control -- Browse APIs
 */

/*
 * Command and Control -- Category APIs
 */

/*
 * Command and Control -- Channel APIs
 */

SXIAPI_STATUSCODE_ENUM SXIAPI_eChanBrowseCmd (
    STI_HDL hSTI,
    SXIAPI_CHAN_BROWSE_TYPE_ENUM eBrowseType,
    SXIAPI_SID tChanOrSID,
    SXIAPI_CATEGORY_ID tCatID,
    SXIAPI_CH_ATTRIB tOverrides
        );

SXIAPI_STATUSCODE_ENUM SXIAPI_eChanSelectCmd (
    STI_HDL hSTI,
    SXIAPI_CHAN_SELECT_TYPE_ENUM eSelType,
    SXIAPI_SID tChanOrSID,
    SXIAPI_CATEGORY_ID tCatID,
    SXIAPI_CH_ATTRIB tOverrides
        );

SXIAPI_STATUSCODE_ENUM SXIAPI_eExtMetadataMonCmd (
    STI_HDL hSTI,
    SXIAPI_EXT_METADATA_MONITOR_ENUM eMonitorSelection,
    SXIAPI_MONITOR_OP_ENUM eOperation,
    UN8 un8ListCnt,
    const SXIAPI_METADATA_IDENTIFIER *ptList
        );

BOOLEAN SXIAPI_bSendChanInfoCfm (
    STI_HDL hSTI,
    SXIAPI_TRANID tTransactionID,
    OSAL_BUFFER_HDL hIndPayload,
    SXIAPI_RX_STRUCT const *psResp
        );

SXIAPI_STATUSCODE_ENUM SXIAPI_eSeekMonCmd (
    STI_HDL hSTI,
    UN8 un8SeekMonId,
    SXIAPI_MONITOR_OP_ENUM eOperation,
    SXIAPI_TMI_ENUM eTMI,
    UN8 un8ValueCnt,
    UN8 un8ValueLen,
    const void *pvValues,
    UN8 un8ReportCnt,
    const SXIAPI_METADATA_IDENTIFIER *ptReport,
    UN8 un8SeekControlMask
        );

SXIAPI_STATUSCODE_ENUM SXIAPI_eBulletinMonCmd (
    STI_HDL hSTI,
    UN8 un8BulletinType,
    UN8 un8ParamCnt,
    const UN16 *pun16ParamList
        );

/*
 * Command and Control -- Audio APIs
 */

SXIAPI_STATUSCODE_ENUM SXIAPI_eAudioMuteCmd (
    STI_HDL hSTI,
    SXIAPI_MUTE_ENUM eMute
        );

SXIAPI_STATUSCODE_ENUM SXIAPI_eAudioExciterCmd (
    STI_HDL hSTI,
    SXIAPI_EXCITER_ENUM eExciter
        );

SXIAPI_STATUSCODE_ENUM SXIAPI_eAudioVolCmd (
    STI_HDL hSTI,
    N8 n8VolumeAdj
        );

SXIAPI_STATUSCODE_ENUM SXIAPI_eAudioTonalCmd (
    STI_HDL hSTI,
    N8 n8BassAdj,
    N8 n8TrebleAdj
        );

SXIAPI_STATUSCODE_ENUM SXIAPI_eToneGenerateCmd (
    STI_HDL hSTI,
    UN8 un8ToneFreq,
    UN8 un8AudioToneOptions,
    N8  n8ToneVolume
        );

SXIAPI_STATUSCODE_ENUM SXIAPI_eAudioEqCmd (
    STI_HDL hSTI,
    N8  *pn8BandGain
        );

SXIAPI_STATUSCODE_ENUM SXIAPI_eChanAttrListCmd (
    STI_HDL hSTI,
    SXIAPI_CH_ATTRIB tChangeAttrib,
    SXIAPI_SID tServiceId[],
    UN16 un16NumServiceIds
        );

SXIAPI_STATUSCODE_ENUM SXIAPI_eChanAttrCfgCmd (
    STI_HDL hSTI,
    SXIAPI_CH_ATTRIB tChangeAttrib,
    SXIAPI_SID tServiceId[],
    UN16 un16NumServiceIds
        );

SXIAPI_STATUSCODE_ENUM SXIAPI_eChanSelectCfgCmd (
    STI_HDL hSTI,
    SXIAPI_CHAN_SELECT_CFG_CMD_STRUCT *psCfg
        );

/*
 * Command and Control -- Playback APIs
 */
SXIAPI_STATUSCODE_ENUM SXIAPI_eIRPlaybackControlCmd (
    STI_HDL hSTI,
    SXIAPI_IR_CONTROL_ENUM eControl,
    SXIAPI_PLAYBACK_TIME_OFFSET tOffset,
    SXIAPI_PLAYBACK_ID tPlaybackId
        );


/*
 * Command and Control -- Special APIs
 */

/*
 * Command and Control -- FW Update APIs
 */

SXIAPI_STATUSCODE_ENUM SXIAPI_eFWUpdateProgCmd (
    STI_HDL hSTI
        );

SXIAPI_STATUSCODE_ENUM SXIAPI_eFWUpdateCfgCmd (
    STI_HDL hSTI,
    UN32 un32BytesInPacket,
    UN32 un32NumPackets
        );

SXIAPI_STATUSCODE_ENUM SXIAPI_eFWUpdatePacketCmd (
    STI_HDL hSTI,
    UN16 un16PacketID,
    UN8 *pun8PacketData,
    UN32 un32BytesInPacket
        );

/*
 * Command and Control -- Data Service APIs
 */

SXIAPI_STATUSCODE_ENUM SXIAPI_eDataServiceMonCmd (
    STI_HDL hSTI,
    SXIAPI_DATASERVICE_MONITOR_OP_ENUM eMonOp,
    SXIAPI_DSI tDSI
        );

SXIAPI_STATUSCODE_ENUM SXIAPI_eDataServiceFilterCmd (
    STI_HDL hSTI,
    SXIAPI_DATASERVICE_FILTER_UPDATE_TYPE_ENUM eUpdateType,
    SXIAPI_DSI tDSI,
    UN8 un8DMICnt,
    SXIAPI_DMI *ptDMIList
        );

/*
 * Command and Control -- Factory Activation APIs
 */
SXIAPI_STATUSCODE_ENUM SXIAPI_ePkgCmd (
    STI_HDL hSTI,
    SXIAPI_PKG_CMD_OPTION_ENUM ePkgCmdOption,
    UN8 un8PkgIndex
        );

/*
 * Command and Control -- Engineering APIs
 */

  /*****************************/
 /** GLOBAL INLINE FUNCTIONS **/
/*****************************/

#endif // SXIAPI_H_

