/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/*                           Proprietary & Confidential                       */
/******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/
#ifndef SXI_H_
#define SXI_H_

  /**************/
 /** INCLUDES **/
/**************/
#include <stddef.h>

#include "standard.h"
#include "osal.h"
#include "sms_api.h"

#include "sti_api.h"
#include "sxill.h"
#include "sxi_fsm.h"
#include "sxiapi.h"

#include "sms_event_types.h"

// If logging hasn't been configured already
// then only enable when we're in debug
#ifndef SMS_LOGGING
#if SMS_DEBUG == 1 && OSAL_LOG == 1
#define SMS_LOGGING 1
#else
#define SMS_LOGGING 0
#endif
#endif

  /**********************/
 /** GLOBAL CONSTANTS **/
/**********************/

// SXI Application Definitions
#define SXI_DEFAULT_TIMEOUT_MSEC            (240)
#define SXI_CHANBROWSEIND_TIMEOUT_MSEC      (500)
#define SXI_PWRMODEIND_TIMEOUT_MSEC         (5000)
#define SXI_PKGIND_TIMEOUT_MSEC             (2000)

//The firmware update following definitions originate from SX-9845-0097 SXi
//Messages section 13.  Both the Packet Timeout and Erase timeout were
//increased from the specification to eliminate errors that had no consequences
//on success or failure of the programming.
#define SXI_FWUPDATE_CFG_TIMEOUT_MSEC       (500)
#define SXI_FWUPDATE_PROG_TIMEOUT_MSEC      (5000)
#define SXI_FWUPDATE_PACKET_TIMEOUT_MSEC    (5000)
#define SXI_FWUPDATE_ERASE_TIMEOUT_MSEC     (22000)

#define SXI_DEFAULT_RETRIES                 (3)

#define SXI_FWUPDATE_PACKET_SIZE            (256)
#define SXI_FWUPDATE_HEADER_SIZE            (64)


/* Firmware Update File position Definitions */
#define SXI_FWUPDATE_MOD_TYPE_A_POS         (62)
#define SXI_FWUPDATE_MOD_TYPE_B_POS         (61)
#define SXI_FWUPDATE_MOD_TYPE_C_POS         (60)

#define SXI_FWUPDATE_SW_REV_MAJOR_POS       (42)
#define SXI_FWUPDATE_SW_REV_MINOR_POS       (41)
#define SXI_FWUPDATE_SW_REV_INC_POS         (40)

#define SXI_FWUPDATE_EARLIEST_SW_REV_MAJOR_POS  (46)
#define SXI_FWUPDATE_EARLIEST_SW_REV_MINOR_POS  (45)
#define SXI_FWUPDATE_EARLIEST_SW_REV_INC_POS    (44)

#define SXI_FWUPDATE_LATEST_SW_REV_MAJOR_POS    (50)
#define SXI_FWUPDATE_LATEST_SW_REV_MINOR_POS    (49)
#define SXI_FWUPDATE_LATEST_SW_REV_INC_POS      (48)

// Minimum SXI Firmware version that supports Daylight Savings
// Time Observance
#define SXI_DST_CAPABLE_VERSION             (0x090202)

  /*********************/
 /** GLOBAL TYPEDEFS **/
/*********************/

typedef void * SXI_CONNECTION_ARG_HANDLE;
#define SXI_CONNECTION_ARG_INVALID_HANDLE (NULL)

typedef BOOLEAN (*SXI_POST_MODULE_EVENT_FUNCTION) (
            MODULE_OBJECT hModule,
            SMS_EVENT_TYPE_ENUM eEvent,
            EVENT_OPTIONS_TYPE tOptions,
            const void *pvData
                );

typedef BOOLEAN (*SXI_POST_DATA_PAYLOAD_EVENT_FUNCTION) (
        SMS_OBJECT hDemux,
        OSAL_BUFFER_HDL hInputPayload
                );

  /*****************************/
 /** GLOBAL STRUCT TEMPLATES **/
/*****************************/

// Structure used to add new data payload
// destinations (DSI and block pool for some DMIs)
typedef struct sxi_add_data_payload_dest_struct
{
    // The DSI it's all for
    SXIAPI_DSI tDSI;

    // The DMIs we'll be adding
    SXIAPI_DMI atNewDMIs[SXIAPI_DMI_CNT_MAX];

    // The size of the array above
    UN8 un8NumDMIs;

    // The size the block pool should be
    size_t tSuggestedOTABufferByteSize;

} SXI_ADD_DATA_PAYLOAD_DEST_STRUCT;

  /****************************/
 /** GLOBAL UNION TEMPLATES **/
/****************************/

  /**********************/
 /** GLOBAL VARIABLES **/
/**********************/

  /*******************/
 /** GLOBAL MACROS **/
/*******************/

  /***********************/
 /** GLOBAL PROTOTYPES **/
/***********************/

SXI_GMD_HDL SXI_hGMD (
    STI_HDL hControlCxn
        );

SXI_FSM_HDL SXI_hFSM (
    STI_HDL hControlCxn
        );

SXI_CONNECTION_ARG_HANDLE SXI_hInitConnectionArg(
    SXI_FSM_HDL hFSM,
    SXILL_PAYLOAD_TYPE tPayloadType,
    UN32 un32ResponseQueueSize,
    OSAL_OBJECT_HDL hDataPayloadDestinations
        );

STI_PROTOCOL_RESULT_CODE_ENUM SXI_eSendPayload(
    STI_HDL hSTI,
    OSAL_BUFFER_HDL hPayload,
    UN8 un8Retries,
    N32 n32Timeout,
    SXIAPI_STATUSCODE_ENUM *peStatusCode
        );

SXIAPI_TRANID SXI_tGetNextTransIDForConnection(
    STI_HDL hSTI
        );

SXILL_PAYLOAD_TYPE SXI_tGetTypeForConnection (
    STI_HDL hSTI
        );

void SXI_vFreeConnectionArg(
    SXI_CONNECTION_ARG_HANDLE hSXIConnectionArg
        );

BOOLEAN SXI_bLinkConnectionCallback(
    STI_HDL hSTI,
    STI_PROTOCOL_HDL hProtocol,
    STI_PROTOCOL_CALLBACK_MSG_STRUCT const *psCallback
        );

BOOLEAN SXI_bControlConnectionCallback(
    STI_HDL hSTI,
    STI_PROTOCOL_HDL hProtocol,
    STI_PROTOCOL_CALLBACK_MSG_STRUCT const *psCallback
        );

BOOLEAN SXI_bDataConnectionCallback(
    STI_HDL hSTI,
    STI_PROTOCOL_HDL hProtocol,
    STI_PROTOCOL_CALLBACK_MSG_STRUCT const *psCallback
        );

BOOLEAN SXI_bAudioConnectionCallback(
    STI_HDL hSTI,
    STI_PROTOCOL_HDL hProtocol,
    STI_PROTOCOL_CALLBACK_MSG_STRUCT const *psCallback
        );

void SXI_vReAllocateResponse(
    SXIAPI_RX_STRUCT *psResp
        );

void SXI_vFreeResponse(
    SXIAPI_RX_STRUCT *psResp
        );

BOOLEAN SXI_bDecodeDataPacket(
    OSAL_BUFFER_HDL hPayload,
    SXIAPI_DATA_PACKET_TYPE_ENUM *peType,
    SXIAPI_DMI *ptDMI
        );

N16 SXI_n16CompareDataDest (
    void *pvObj1,
    void *pvObj2
        );

void SXI_vFreeDataDest (
    void *pvObj
        );

#if SMS_LOGGING == 1

N32 SXI_n32SXiLogWritePayload (
    STI_HDL hSTI,
    OSAL_BUFFER_HDL hPayload,
    const char *pacInfoText
        );

#else

#if __STDC_VERSION__ >= 199901L

#define SXI_n32SXiLogWritePayload(...)

#else

N32 SXI_n32SXiLogWritePayloadNothing (
    STI_HDL hSTI,
    OSAL_BUFFER_HDL hPayload,
    const char *pacInfoText
        );
#define SXI_n32SXiLogWritePayload if(1);else SXI_n32SXiLogWritePayloadNothing

#endif

#endif

  /*****************************/
 /** GLOBAL INLINE FUNCTIONS **/
/*****************************/

#endif // SXI_H
