/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * PRIVATE HEADER
 *
 ******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/
#ifndef _SXMTRAFFIC_H_
#define _SXMTRAFFIC_H_

  /**************/
 /** INCLUDES **/
/**************/

#include <stdio.h>

#include "standard.h"
#include "osal.h"

#include "sms_api.h"

#include "traffic_interface.h"

#include "SXMTrafficRadioConstants.h"

  /***************/
 /** CONSTANTS **/
/***************/

// Object Debugging:
// If DEBUG_OBJECT isn't defined
// define it locally
#ifndef DEBUG_OBJECT
#define DEBUG_OBJECT 0
#endif

// Include the debug definitions
// header, which depends on how
// DEBUG_OBJECT is defined
#include "sms_debug_definitions.h"

/* Max message sizes (from SX-9845-0068)
*   Section 2.1.1 says:
*       Traffic data services messages will be contained within the SDTP payload...
*       As previously described, each SDTP packet will contain only one type
*       of traffic data message that will pertain to one traffic market. The
*       traffic market identifier message at the beginning of the SDTP payload
*       will inform the host system of what data type, or types, are encoded
*       into the SDTP packet.
*
*   Regardless of all of that, Pete has informed me that the requirements
*   for buffering traffic is very high, and that we need about 50k.  So,
*   there you go.
*/
#define TRAFFIC_BUFFER_BYTESIZE (50 * 1024)

// Array / Index constants used for manipulating SMS
// data service stream
#define TRAFFIC_INDICIDENT_DMI_INDEX (0)
#define TRAFFIC_SPEED_AND_FLOW_DMI_INDEX (1)
#define TRAFFIC_NUM_DMIS_CONFIGURED (2)

// Constants for parsing the low-band SDTP traffic header
#define TRAFFIC_SDTP_SYNC_BYTE                      0x81
#define TRAFFIC_SDTP_SYNC_BYTELEN                   1
#define TRAFFIC_SDTP_ALL_MESSAGES_TXED_BITLEN       1
#define TRAFFIC_SDTP_RESERVED_PLUS_M_W_FLAGS_BITLEN 5
#define TRAFFIC_SDTP_S_FLAG_BITLEN                  1
#define TRAFFIC_SDTP_I_FLAG_BITLEN                  1
#define TRAFFIC_SDTP_MSG_COUNT_BITLEN               8
#define TRAFFIC_SDTP_MSG_TYPE_BITLEN                2
#define TRAFFIC_SDTP_MARKET_ID_BYTELEN              1
#define TRAFFIC_SDTP_REST_OF_HEADER_BITLEN          6


  /**************/
 /** TYPEDEFS **/
/**************/

  /************/
 /** MACROS **/
/************/

  /****************/
 /** PROTOTYPES **/
/****************/

/* Object Private Prototypes */
static BOOLEAN bConfigureDataFilter(
    TRAFFIC_INTERFACE_OBJECT hTrafficData,
    TRAFFIC_SERVICE_OBJECT hTrafficService,
    BOOLEAN bAdd,
    TRAFFIC_MARKET tMarket
        );

static BOOLEAN bParseHeader(
    TRAFFIC_INTERFACE_OBJECT hTrafficData,
    OSAL_BUFFER_HDL *phPayload,
    BOOLEAN bNewPayload,
    TRAFFIC_LOCID_OBJECT *phTrafficID,
    TRAFFIC_MSG_TYPE_ENUM *peMsgType,
    TRAFFIC_MARKET_PROC_STATE_ENUM *peMarketProcState,
    size_t *ptNumAlertCBytes
        );

  /***************/
 /** VARIABLES **/
/***************/

const TRAFFIC_PLUGIN_INTERFACE_STRUCT GsTrafficIntf =
{
    /*.tDSI = */DSB_TRAFFIC_DSI,
    /*.tOTABufferByteSize = */TRAFFIC_BUFFER_BYTESIZE,
    /*.hInitParser = */NULL,
    /*.bConfigureDataFilter = */bConfigureDataFilter,
    /*.bParseTrafficServiceBits = */bParseHeader,
    /*.vUninitParser = */NULL
};

  /**********************/
 /** INLINE FUNCTIONS **/
/**********************/

#endif	// _SXMTRAFFIC_H_
