////////////////////////////////////////////////////////////////////////////////////////////////////
/// @file	rfd_common\rfd_time.h
///
/// @brief	Declares the rfd time class.
///
/// @remarks	Sirius XM Reliable File Delivery (RFD) SDK
///
/// @remarks	Copyright (c) 2013 Sirius XM Radio, Inc. All rights reserved.
////////////////////////////////////////////////////////////////////////////////////////////////////

#ifndef RFD_TIME_H
#define RFD_TIME_H

#include "rfd_config.h"

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

////////////////////////////////////////////////////////////////////////////////////////////////////
// Year 0 base for time reported by SXI (TimeInd SXI message)
#define RFD_SXI_YEAR0   2000

////////////////////////////////////////////////////////////////////////////////////////////////////
// Year 0 base for RFD Update File Metadata LIFE field
#define RFD_MDATA_LIFE_YEAR0    2009

////////////////////////////////////////////////////////////////////////////////////////////////////
// Maximum and Minimum values for the RFD MDATA Life
#define RFD_MDATA_LIFE_MAX_DAYS ((1<<RFD_FSET_MSG_LIFE_TIME_FIELD_NUM_BITS)-1)
#define RFD_MDATA_LIFE_MIN_DAYS 0

////////////////////////////////////////////////////////////////////////////////////////////////////
// Year 0 base for standard c library broken down time (base year used for struct tm, tm_year var).
// Note: This is *not* the Epoc base year used in time_t.
#define RFD_STD_LIB_BROKEN_DOWN_TIME_YEAR0  1900

typedef enum {
    RFD_SXI_TIME_MINUTE_RES = 0,
    RFD_SXI_TIME_HOUR_RES   = 1,
    RFD_SXI_TIME_DAY_RES    = 2,
    RFD_SXI_TIME_MONTH_RES  = 3,
    RFD_SXI_TIME_YEAR_RES   = 4
} RFD_SXI_TIME_RESOLUTION_ENUM;

time_t RFD_TIME_MakeSimpleCalendarTime( struct tm *brokentime );

double RFD_TIME_DiffSimpleCalendarTime (time_t time1, time_t time0);

RFD_STATUS RFD_TIME_SxiTime2StdCalendarTime(
                time_t * stdCalendarTimePtr,
                const RFD_SXI_TIME_INFO_STRUCT * sxiTime );

RFD_STATUS RFD_TIME_RfdLifeDays2StdCalendarTime(
                time_t * stdCalendarTimePtr,
                const INT32 rfdLifeTime );

BOOL RFD_TIME_IsEqualSxiTime(
            RFD_SXI_TIME_INFO_STRUCT * sxiTime1,
            RFD_SXI_TIME_INFO_STRUCT * sxiTime0,
            RFD_SXI_TIME_RESOLUTION_ENUM timeResolution );

void RFD_TIME_SetSxiEpocTime( RFD_SXI_TIME_INFO_STRUCT * sxiTimePtr );

RFD_STATUS RFD_TIME_DisplayYearMonthDay2RfdLifeDays(
                    INT32 year,
                    INT32 month,
                    INT32 day,
                    INT32 * rfdLifeDaysPtr );

BOOL RFD_TIME_IsSxiTimeFormatValid( const RFD_SXI_TIME_INFO_STRUCT * sxiTime );

#ifdef __cplusplus
}
#endif

#endif // RFD_TIME_H