////////////////////////////////////////////////////////////////////////////////////////////////////
/// @file	rfd_common\rfd_message_queue.h
///
/// @brief	Declares the rfd message queue class.
///
/// @remarks	Sirius XM Reliable File Delivery (RFD) SDK
///
/// @remarks	Copyright (c) 2009 Sirius XM Radio, Inc. All rights reserved.
////////////////////////////////////////////////////////////////////////////////////////////////////

#ifndef RFD_MESSAGE_QUEUE_H
#define RFD_MESSAGE_QUEUE_H

#include "rfd_config.h"
#include "rfd.h"

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#define RFD_MSG_QUEUE_SEMAPHORE_MAX_COUNT 256

typedef INT32 RFD_MSG_QUEUE_MSG_HEADER;

typedef struct {
	UINT32 headIndex;
	UINT32 tailIndex;
	INT32 semaphoreCount;
	UCHAR * buf;
	UINT32 bufSize;
	RFD_MUTEX_HANDLE mutexHandle;
	RFD_SEMAPHORE_HANDLE semaphoreHandle;

} RFD_MSG_QUEUE_STRUCT, *RFD_MSG_QUEUE_HANDLE;

///////////////////////////////////////////////////////////////////////////////
RFD_STATUS RFD_MSG_QUEUE_Create(RFD_MSG_QUEUE_HANDLE * messageQueueHandle, INT32 dataBufSize);
///////////////////////////////////////////////////////////////////////////////
RFD_STATUS RFD_MSG_QUEUE_Delete(RFD_MSG_QUEUE_HANDLE messageQueueHandle);
///////////////////////////////////////////////////////////////////////////////
RFD_STATUS RFD_MSG_QUEUE_WaitForMessage(RFD_MSG_QUEUE_HANDLE messageQueueHandle, INT32 timeoutMilliseconds);
///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
RFD_STATUS RFD_MSG_QUEUE_PutMessage(RFD_MSG_QUEUE_HANDLE messageQueueHandle, UCHAR * inputData, UINT32 inputDataSize);
///////////////////////////////////////////////////////////////////////////////
RFD_STATUS RFD_MSG_QUEUE_GetMessage(RFD_MSG_QUEUE_HANDLE messageQueueHandle,
									UCHAR * outputMsgBuf, UINT32 ouputMsgBufSize,
									UINT32 * messageSizePtr);
///////////////////////////////////////////////////////////////////////////////
UINT32 RFD_MSG_QUEUE_GetMessageOverheadSize(void);

#ifdef __cplusplus
}
#endif

#endif // RFD_MESSAGE_QUEUE_H