////////////////////////////////////////////////////////////////////////////////////////////////////
/// @file	rfd_common\rfd_crc.c
///
/// @brief	rfd crc class.
///
/// @remarks	Sirius XM Reliable File Delivery (RFD) SDK
///
/// @remarks	Copyright (c) 2009 Sirius XM Radio, Inc. All rights reserved.
////////////////////////////////////////////////////////////////////////////////////////////////////

#include "rfd.h"
#include "zlib.h"

///////////////////////////////////////////////////////////////////////////////
void RFD_ResetCrc(UINT32 * crc)
{
   *crc = crc32(0, Z_NULL, 0);
}

///////////////////////////////////////////////////////////////////////////////
void RFD_CalculateCrc(UINT32 * crc, UCHAR * buf, UINT32 length)
{
	*crc = crc32(*crc, buf, length);
}

///////////////////////////////////////////////////////////////////////////////////////////////
RFD_STATUS  RFD_CalculateFileCrc(const TCHAR fileNameBuf[], UINT32 *calculatedCrc)
{
	RFD_FILE * file;
	UCHAR * buf;
	UINT32 len;
	UINT32 crc = 0;
	RFD_STATUS status;

	// Creat read data buf
	buf = (UCHAR *) RFD_MALLOC(RFD_FILE_CRC_CALC_BUF_LEN * sizeof(UCHAR));
	if(buf == NULL) {
		return RFD_STATUS_ERROR_MEM_ALLOC;
	}

	// Open file
	if(RFD_FOPEN_S(&file, fileNameBuf, TEXT("rb"))) {
		RFD_FREE(buf);
		return RFD_STATUS_ERROR_FILE_OPEN;
	}

	// Reset crc
	RFD_ResetCrc(&crc);

	// Incrementally read file data and update crc.
    for (;;) {

		// Read data from file.
        len = (int)RFD_FREAD(buf, 1, RFD_FILE_CRC_CALC_BUF_LEN, file);

		if (RFD_FERROR(file)) {
			RFD_DPrint(TEXT("Error, during file read\n"));
			status = RFD_STATUS_ERROR_FILE_READ;
			break;
        }

		if (len == 0) {
			status = RFD_STATUS_OK;
			break;
		}

		// Update crc.
		RFD_CalculateCrc(&crc, buf, len);
    }

	// Close file.
	RFD_FCLOSE(file);

	// Free read data buf.
	RFD_FREE(buf);

	// Output parameter update
	*calculatedCrc = crc;

	return status;
}
