////////////////////////////////////////////////////////////////////////////////////////////////////
/// @file	rfd_common\rfd_config.h
///
/// @brief	Preprocessor definitions that control configuration of the overall RFD Solution.
///
/// @remarks	Sirius XM Reliable File Delivery (RFD) SDK
///
/// @remarks	Copyright (c) 2009 Sirius XM Radio, Inc. All rights reserved.
////////////////////////////////////////////////////////////////////////////////////////////////////

#ifndef RFD_CONFIG_H
#define RFD_CONFIG_H

#include "rfd_platform_port.h"

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

// DEBUG_PRINT_ENABLE :
// For debug support,
// Enables Printing of various indications to the console by the receiver.
#if 0
#define DEBUG_PRINT_ENABLE
#endif

// RFD_PRINT_MAX_BUF_SIZE
// RFD_DPrint() uses a temporary internal buffer to contain the print string.
// This definition sets the size of this buffer.
// The size can be increased if necessary e.g. if new calls to
// RFD_DPrint() are added that generate longer print strings.
#define RFD_PRINT_MAX_BUF_SIZE 512

// RFD_BAUDOT_CONVERSION_CP1252, RFD_BAUDOT_CONVERSION_ISO_IEC_8859_15, RFD_BAUDOT_CONVERSION_UNICODE
// Enable one of these definitions to specify the charater format supported by the Baudot conversion
// (for the RFD Metadata Name field).
// RFD_BAUDOT_CONVERSION_CP1252				: CP1252 (Windows Code Page number 1252)
// RFD_BAUDOT_CONVERSION_ISO_IEC_8859_15	: ISO/IEC 8859-15
// RFD_BAUDOT_CONVERSION_UNICODE			: Unicode 16-bits (UTF-16)
#if 1
#define RFD_BAUDOT_CONVERSION_CP1252
#elif 0
#define RFD_BAUDOT_CONVERSION_ISO_IEC_8859_15
#elif 0
#define RFD_BAUDOT_CONVERSION_UNICODE
#endif

#if 0
// RFD_ALT_SINGLE_THREAD_MODE_ENABLE
// Remove support for all functions related to threads and thread synchronization
// in support of the Alternate Single Threaded RFD operating mode.
#define RFD_ALT_SINGLE_THREAD_MODE_ENABLE
#endif

#ifdef __cplusplus
}
#endif

#endif // RFD_CONFIG_H