////////////////////////////////////////////////////////////////////////////////////////////////////
/// @file	rfd_common\rfd_codec_utils_xcc2.c
///
/// @brief	rfd codec utils extended-ecc2-code class.
///
/// @remarks	Sirius XM Reliable File Delivery (RFD) SDK
///
/// @remarks	Copyright (c) 2009 Sirius XM Radio, Inc. All rights reserved.
////////////////////////////////////////////////////////////////////////////////////////////////////

#include "rfd_codec_xcc.h"
#include "rfd_gf4_tables.h"

///////////////////////////////////////////////////////////////////////////////////////////////
#ifdef RFD_XCC1_CODE
	#undef RFD_XCC1_CODE
#endif

#define XCC_BITS_PER_ELEMENT 2
#define RFD_XCC2_CODE
#define RFD_CONSTRUCT_SRC_TYPE_COEFF_ROW   RFD_ConstructSrcTypeCoeffRowEcc2
#define RFD_CONSTRUCT_CHK_TYPE_COEFF_ROW   RFD_ConstructChkTypeCoeffRowEcc2
#define RFD_XCC_COEFF_LUT rfdEcc2Coeffs

/*********************************************************************
*
*       #include rfd_codec_utils_ecc1.c code
*
**********************************************************************
*
* The XCC2 codec utility code is in an other "C" file, shared with XCC1 code.
* This is done to avoid duplication of code.
*/
#include "rfd_codec_utils_xcc1.c"
