////////////////////////////////////////////////////////////////////////////////////////////////////
/// @file	rfd_common\rfd_baudot_tables.c
///
/// @brief	rfd baudot tables class.
///
/// @remarks	Sirius XM Reliable File Delivery (RFD) SDK
///
/// @remarks	Copyright (c) 2009 Sirius XM Radio, Inc. All rights reserved.
////////////////////////////////////////////////////////////////////////////////////////////////////

#include "rfd_baudot.h"


///////////////////////////////////////////////////////////////////////////////
const TCHAR baudotColumn_LTR_UC[RFD_BAUDOT_NUM_ROWS] =
{
	RFD_BAUDOT_CONTROL_CODE,	// row 0x00 - end control
	LATIN_CAPITAL_LETTER_E,		// row 0x01
	RFD_BAUDOT_CONTROL_CODE,	// row 0x02 - lower case control
	LATIN_CAPITAL_LETTER_A,		// row 0x03
	SPACE,						// row 0x04
	LATIN_CAPITAL_LETTER_S,		// row 0x05
	LATIN_CAPITAL_LETTER_I,		// row 0x06
	LATIN_CAPITAL_LETTER_U,		// row 0x07
	CARRIAGE_RETURN,			// row 0x08
	LATIN_CAPITAL_LETTER_D, 	// row 0x09
	LATIN_CAPITAL_LETTER_R, 	// row 0x0a
	LATIN_CAPITAL_LETTER_J, 	// row 0x0b
	LATIN_CAPITAL_LETTER_N, 	// row 0x0c
	LATIN_CAPITAL_LETTER_F, 	// row 0x0d
	LATIN_CAPITAL_LETTER_C, 	// row 0x0e
	LATIN_CAPITAL_LETTER_K, 	// row 0x0f
	LATIN_CAPITAL_LETTER_T, 	// row 0x10
	LATIN_CAPITAL_LETTER_Z, 	// row 0x11
	LATIN_CAPITAL_LETTER_L, 	// row 0x12
	LATIN_CAPITAL_LETTER_W, 	// row 0x13
	LATIN_CAPITAL_LETTER_H, 	// row 0x14
	LATIN_CAPITAL_LETTER_Y, 	// row 0x15
	LATIN_CAPITAL_LETTER_P, 	// row 0x16
	LATIN_CAPITAL_LETTER_Q, 	// row 0x17
	LATIN_CAPITAL_LETTER_O, 	// row 0x18
	LATIN_CAPITAL_LETTER_B, 	// row 0x19
	LATIN_CAPITAL_LETTER_G, 	// row 0x1a
	RFD_BAUDOT_CONTROL_CODE,	// row 0x1b - esc control
	LATIN_CAPITAL_LETTER_M, 	// row 0x1c
	LATIN_CAPITAL_LETTER_X, 	// row 0x1d
	LATIN_CAPITAL_LETTER_V, 	// row 0x1e
	RFD_BAUDOT_CONTROL_CODE 	// row 0x1f - fig control
};

///////////////////////////////////////////////////////////////////////////////
const TCHAR baudotColumn_LTR_LC[RFD_BAUDOT_NUM_ROWS] =
{
	RFD_BAUDOT_CONTROL_CODE,	// row 0x00 - end control
	LATIN_SMALL_LETTER_E,		// row 0x01
	RFD_BAUDOT_CONTROL_CODE,	// row 0x02 - upper case control
	LATIN_SMALL_LETTER_A,		// row 0x03
	SPACE,						// row 0x04
	LATIN_SMALL_LETTER_S,		// row 0x05
	LATIN_SMALL_LETTER_I,		// row 0x06
	LATIN_SMALL_LETTER_U,		// row 0x07
	CARRIAGE_RETURN,			// row 0x08
	LATIN_SMALL_LETTER_D, 		// row 0x09
	LATIN_SMALL_LETTER_R, 		// row 0x0a
	LATIN_SMALL_LETTER_J, 		// row 0x0b
	LATIN_SMALL_LETTER_N, 		// row 0x0c
	LATIN_SMALL_LETTER_F, 		// row 0x0d
	LATIN_SMALL_LETTER_C, 		// row 0x0e
	LATIN_SMALL_LETTER_K, 		// row 0x0f
	LATIN_SMALL_LETTER_T, 		// row 0x10
	LATIN_SMALL_LETTER_Z, 		// row 0x11
	LATIN_SMALL_LETTER_L, 		// row 0x12
	LATIN_SMALL_LETTER_W, 		// row 0x13
	LATIN_SMALL_LETTER_H, 		// row 0x14
	LATIN_SMALL_LETTER_Y, 		// row 0x15
	LATIN_SMALL_LETTER_P, 		// row 0x16
	LATIN_SMALL_LETTER_Q, 		// row 0x17
	LATIN_SMALL_LETTER_O, 		// row 0x18
	LATIN_SMALL_LETTER_B, 		// row 0x19
	LATIN_SMALL_LETTER_G, 		// row 0x1a
	RFD_BAUDOT_CONTROL_CODE,	// row 0x1b - esc control
	LATIN_SMALL_LETTER_M, 		// row 0x1c
	LATIN_SMALL_LETTER_X, 		// row 0x1d
	LATIN_SMALL_LETTER_V, 		// row 0x1e
	RFD_BAUDOT_CONTROL_CODE 	// row 0x1f - fig control
};


///////////////////////////////////////////////////////////////////////////////
const TCHAR baudotColumn_FIG[RFD_BAUDOT_NUM_ROWS] =
{
	RFD_BAUDOT_CONTROL_CODE,		// row 0x00 - end control
	DIGIT_THREE,					// row 0x01 - 3
	PLUS_SIGN,						// row 0x02 - +
	HYPHEN_MINUS,					// row 0x03 - -
	SPACE,							// row 0x04 -
	APOSTROPHE,						// row 0x05 - 
	DIGIT_EIGHT,					// row 0x06 - 8
	DIGIT_SEVEN,					// row 0x07 - 7
	CARRIAGE_RETURN,				// row 0x08 -
	DOLLAR_SIGN, 					// row 0x09 - $
	DIGIT_FOUR, 					// row 0x0a - 4
	ASTERISK, 						// row 0x0b - *
	COMMA, 							// row 0x0c - ,
	EXCLAMATION_MARK, 				// row 0x0d - !
	COLON, 							// row 0x0e - :
	LEFT_PARENTHESIS, 				// row 0x0f - (
	DIGIT_FIVE, 					// row 0x10 - 5
	PERCENT_SIGN, 					// row 0x11 - %
	RIGHT_PARENTHESIS, 				// row 0x12 - )
	DIGIT_TWO, 						// row 0x13 - 2
	NUMBER_SIGN, 					// row 0x14 - #
	DIGIT_SIX, 						// row 0x15 - 6
	DIGIT_ZERO, 					// row 0x16 - 0
	DIGIT_ONE, 						// row 0x17 - 1
	DIGIT_NINE, 					// row 0x18 - 9
	QUESTION_MARK, 					// row 0x19 - ?
	AMPERSAND, 						// row 0x1a - &
	RFD_BAUDOT_CONTROL_CODE,		// row 0x1b - esc control
	FULL_STOP, 						// row 0x1c - .
	SOLIDUS, 						/* row 0x1d - \ */
	COMMERCIAL_AT, 					// row 0x1e - @
	RFD_BAUDOT_CONTROL_CODE 		// row 0x1f - ltr control
};

///////////////////////////////////////////////////////////////////////////////
const TCHAR baudotColumn_UC_ESC[RFD_BAUDOT_NUM_ROWS] =
{
	LATIN_CAPITAL_LETTER_A_WITH_GRAVE		,		// row 0x00 - 
	LATIN_CAPITAL_LETTER_A_WITH_ACUTE		,		// row 0x01 - 
	LATIN_CAPITAL_LETTER_A_WITH_CIRCUMFLEX	,		// row 0x02 - 
	LATIN_CAPITAL_LETTER_A_WITH_TILDE		,		// row 0x03 - 
	LATIN_CAPITAL_LETTER_A_WITH_DIAERESIS	,		// row 0x04 - 
	LATIN_CAPITAL_LETTER_A_WITH_RING_ABOVE	,		// row 0x05 - 
	LATIN_CAPITAL_LETTER_AE					,		// row 0x06 - 
	LATIN_CAPITAL_LETTER_C_WITH_CEDILLA		,		// row 0x07 - 
	LATIN_CAPITAL_LETTER_E_WITH_GRAVE		,		// row 0x08 - 
	LATIN_CAPITAL_LETTER_E_WITH_ACUTE		, 		// row 0x09 - 
	LATIN_CAPITAL_LETTER_E_WITH_CIRCUMFLEX	, 		// row 0x0a - 
	LATIN_CAPITAL_LETTER_E_WITH_DIAERESIS	, 		// row 0x0b - 
	LATIN_CAPITAL_LETTER_I_WITH_GRAVE		, 		// row 0x0c - 
	LATIN_CAPITAL_LETTER_I_WITH_ACUTE		, 		// row 0x0d - 
	LATIN_CAPITAL_LETTER_I_WITH_CIRCUMFLEX	, 		// row 0x0e - 
	LATIN_CAPITAL_LETTER_I_WITH_DIAERESIS	, 		// row 0x0f - 
	LATIN_CAPITAL_LIGATURE_OE				, 		// row 0x10 - 
	LATIN_CAPITAL_LETTER_N_WITH_TILDE		, 		// row 0x11 - 
	LATIN_CAPITAL_LETTER_O_WITH_GRAVE		, 		// row 0x12 - 
	LATIN_CAPITAL_LETTER_O_WITH_ACUTE		, 		// row 0x13 - 
	LATIN_CAPITAL_LETTER_O_WITH_CIRCUMFLEX	, 		// row 0x14 - 
	LATIN_CAPITAL_LETTER_O_WITH_TILDE		, 		// row 0x15 - 
	LATIN_CAPITAL_LETTER_O_WITH_DIAERESIS	, 		// row 0x16 - 
	INVERTED_EXCLAMATION_MARK				, 		// row 0x17 - 
	LATIN_CAPITAL_LETTER_O_WITH_STROKE		, 		// row 0x18 - 
	LATIN_CAPITAL_LETTER_U_WITH_GRAVE		, 		// row 0x19 - 
	LATIN_CAPITAL_LETTER_U_WITH_ACUTE		, 		// row 0x1a - 
	LATIN_CAPITAL_LETTER_U_WITH_CIRCUMFLEX	,		// row 0x1b - 
	LATIN_CAPITAL_LETTER_U_WITH_DIAERESIS	, 		// row 0x1c - 
	LATIN_CAPITAL_LETTER_Y_WITH_ACUTE		, 		// row 0x1d - 
	COPYRIGHT_SIGN							, 		// row 0x1e - 
	LATIN_SMALL_LETTER_SHARP_S				 		// row 0x1f - 
};

///////////////////////////////////////////////////////////////////////////////
const TCHAR baudotColumn_LC_ESC[RFD_BAUDOT_NUM_ROWS] =
{
	LATIN_SMALL_LETTER_A_WITH_GRAVE			,		// row 0x00 - 
	LATIN_SMALL_LETTER_A_WITH_ACUTE			,		// row 0x01 - 
	LATIN_SMALL_LETTER_A_WITH_CIRCUMFLEX	,		// row 0x02 - 
	LATIN_SMALL_LETTER_A_WITH_TILDE			,		// row 0x03 - 
	LATIN_SMALL_LETTER_A_WITH_DIAERESIS		,		// row 0x04 - 
	LATIN_SMALL_LETTER_A_WITH_RING_ABOVE	,		// row 0x05 - 
	LATIN_SMALL_LETTER_AE					,		// row 0x06 - 
	LATIN_SMALL_LETTER_C_WITH_CEDILLA		,		// row 0x07 - 
	LATIN_SMALL_LETTER_E_WITH_GRAVE			,		// row 0x08 - 
	LATIN_SMALL_LETTER_E_WITH_ACUTE			, 		// row 0x09 - 
	LATIN_SMALL_LETTER_E_WITH_CIRCUMFLEX	, 		// row 0x0a - 
	LATIN_SMALL_LETTER_E_WITH_DIAERESIS		, 		// row 0x0b - 
	LATIN_SMALL_LETTER_I_WITH_GRAVE			, 		// row 0x0c - 
	LATIN_SMALL_LETTER_I_WITH_ACUTE			, 		// row 0x0d - 
	LATIN_SMALL_LETTER_I_WITH_CIRCUMFLEX	, 		// row 0x0e - 
	LATIN_SMALL_LETTER_I_WITH_DIAERESIS		, 		// row 0x0f - 
	LATIN_SMALL_LIGATURE_OE					, 		// row 0x10 - 
	LATIN_SMALL_LETTER_N_WITH_TILDE			, 		// row 0x11 - 
	LATIN_SMALL_LETTER_O_WITH_GRAVE			, 		// row 0x12 - 
	LATIN_SMALL_LETTER_O_WITH_ACUTE			, 		// row 0x13 - 
	LATIN_SMALL_LETTER_O_WITH_CIRCUMFLEX	, 		// row 0x14 - 
	LATIN_SMALL_LETTER_O_WITH_TILDE			, 		// row 0x15 - 
	LATIN_SMALL_LETTER_O_WITH_DIAERESIS		, 		// row 0x16 - 
	INVERTED_QUESTION_MARK					, 		// row 0x17 - 
	LATIN_SMALL_LETTER_O_WITH_STROKE		, 		// row 0x18 - 
	LATIN_SMALL_LETTER_U_WITH_GRAVE			, 		// row 0x19 - 
	LATIN_SMALL_LETTER_U_WITH_ACUTE			, 		// row 0x1a - 
	LATIN_SMALL_LETTER_U_WITH_CIRCUMFLEX	,		// row 0x1b - 
	LATIN_SMALL_LETTER_U_WITH_DIAERESIS		, 		// row 0x1c - 
	LATIN_SMALL_LETTER_Y_WITH_ACUTE			, 		// row 0x1d - 
	REGISTERED_SIGN							, 		// row 0x1e - 
	LATIN_SMALL_LETTER_Y_WITH_DIAERESIS				// row 0x1f - 
};

///////////////////////////////////////////////////////////////////////////////
const TCHAR baudotColumn_FIG_ESC[RFD_BAUDOT_NUM_ROWS] =
{
	QUOTATION_MARK,								// row 0x00 - 
	SEMICOLON,									// row 0x01 - ;
	LESS_THAN_SIGN,								// row 0x02 - <
	EQUALS_SIGN,								// row 0x03 - =
	GREATER_THAN_SIGN,							// row 0x04 - >
	LEFT_SQUARE_BRACKET,						// row 0x05 - [
	REVERSE_SOLIDUS,							/* row 0x06 - \ */
	RIGHT_SQUARE_BRACKET,						// row 0x07 - ]
	CIRCUMFLEX_ACCENT,							// row 0x08 - ^
	LOW_LINE, 									// row 0x09 - _
	GRAVE_ACCENT, 								// row 0x0a - `
	LEFT_CURLY_BRACKET, 						// row 0x0b - {
	VERTICAL_LINE, 								// row 0x0c - |
	RIGHT_CURLY_BRACKET, 						// row 0x0d - }
	TILDE, 										// row 0x0e - ~
	LEFT_POINTING_DOUBLE_ANGLE_QUOTATION_MARK, 	// row 0x0f - 
	RIGHT_POINTING_DOUBLE_ANGLE_QUOTATION_MARK, // row 0x10 - 
	CENT_SIGN, 									// row 0x11 - 
	RFD_BAUDOT_UNUSED_CODE, 					// row 0x12
	RFD_BAUDOT_UNUSED_CODE, 					// row 0x13
	RFD_BAUDOT_UNUSED_CODE, 					// row 0x14
	RFD_BAUDOT_UNUSED_CODE, 					// row 0x15
	RFD_BAUDOT_UNUSED_CODE, 					// row 0x16
	RFD_BAUDOT_UNUSED_CODE, 					// row 0x17
	RFD_BAUDOT_UNUSED_CODE, 					// row 0x18
	RFD_BAUDOT_UNUSED_CODE, 					// row 0x19
	RFD_BAUDOT_UNUSED_CODE, 					// row 0x1a
	RFD_BAUDOT_UNUSED_CODE,						// row 0x1b
	RFD_BAUDOT_UNUSED_CODE, 					// row 0x1c
	RFD_BAUDOT_UNUSED_CODE, 					// row 0x1d
	RFD_BAUDOT_UNUSED_CODE, 					// row 0x1e
	RFD_BAUDOT_UNUSED_CODE						// row 0x1f
};

///////////////////////////////////////////////////////////////////////////////
const TCHAR * baudotColumnNonEscape[BAUDOT_NUM_COLUMNS] = {
	baudotColumn_LTR_UC,
	baudotColumn_LTR_LC,
	baudotColumn_FIG
};

///////////////////////////////////////////////////////////////////////////////
const TCHAR * baudotColumnEscape[BAUDOT_NUM_COLUMNS] = {
	baudotColumn_UC_ESC,
	baudotColumn_LC_ESC,
	baudotColumn_FIG_ESC
};

///////////////////////////////////////////////////////////////////////////////
const unsigned int numValidRowsForBaudotColumnNonEscape[BAUDOT_NUM_COLUMNS] = {
	NUM_VALID_ROWS_FOR_BAUDOT_COL_LTR_UC,
	NUM_VALID_ROWS_FOR_BAUDOT_COL_LTR_LC,
	NUM_VALID_ROWS_FOR_BAUDOT_COL_LTR_FIG
};

///////////////////////////////////////////////////////////////////////////////
const unsigned int numValidRowsForBaudotColumnEscape[BAUDOT_NUM_COLUMNS] = {
	NUM_VALID_ROWS_FOR_BAUDOT_COL_UC_ESC,
	NUM_VALID_ROWS_FOR_BAUDOT_COL_LC_ESC,
	NUM_VALID_ROWS_FOR_BAUDOT_COL_FIG_ESC
};


///////////////////////////////////////////////////////////////////////////////
#ifdef RFD_BAUDOT_TEST_ENABLE // for testing
const TCHAR testTableCp1252[256] = {
	CHAR_NULL									,
	START_OF_HEADING							,
	START_OF_TEXT								,
	END_OF_TEXT									,
	END_OF_TRANSMISSION							,
	ENQUIRY										,
	ACKNOWLEDGE									,
	BELL										,
	BACKSPACE									,
	HORIZONTAL_TABULATION						,
	LINE_FEED									,
	VERTICAL_TABULATION							,
	FORM_FEED									,
	CARRIAGE_RETURN								,
	SHIFT_OUT									,
	SHIFT_IN									,
	DATA_LINK_ESCAPE							,
	DEVICE_CONTROL_ONE							,
	DEVICE_CONTROL_TWO							,
	DEVICE_CONTROL_THREE						,
	DEVICE_CONTROL_FOUR							,
	NEGATIVE_ACKNOWLEDGE						,
	SYNCHRONOUS_IDLE							,
	END_OF_TRANSMISSION_BLOCK					,
	CANCEL										,
	END_OF_MEDIUM								,
	SUBSTITUTE									,
	ESCAPE										,
	FILE_SEPARATOR								,
	GROUP_SEPARATOR								,
	RECORD_SEPARATOR							,
	UNIT_SEPARATOR								,
	SPACE										,
	EXCLAMATION_MARK							,
	QUOTATION_MARK								,
	NUMBER_SIGN									,
	DOLLAR_SIGN									,
	PERCENT_SIGN								,
	AMPERSAND									,
	APOSTROPHE									,
	LEFT_PARENTHESIS							,
	RIGHT_PARENTHESIS							,
	ASTERISK									,
	PLUS_SIGN									,
	COMMA										,
	HYPHEN_MINUS								,
	FULL_STOP									,
	SOLIDUS										,
	DIGIT_ZERO									,
	DIGIT_ONE									,
	DIGIT_TWO									,
	DIGIT_THREE									,
	DIGIT_FOUR									,
	DIGIT_FIVE									,
	DIGIT_SIX									,
	DIGIT_SEVEN									,
	DIGIT_EIGHT									,
	DIGIT_NINE									,
	COLON										,
	SEMICOLON									,
	LESS_THAN_SIGN								,
	EQUALS_SIGN									,
	GREATER_THAN_SIGN							,
	QUESTION_MARK								,
	COMMERCIAL_AT								,
	LATIN_CAPITAL_LETTER_A						,
	LATIN_CAPITAL_LETTER_B						,
	LATIN_CAPITAL_LETTER_C						,
	LATIN_CAPITAL_LETTER_D						,
	LATIN_CAPITAL_LETTER_E						,
	LATIN_CAPITAL_LETTER_F						,
	LATIN_CAPITAL_LETTER_G						,
	LATIN_CAPITAL_LETTER_H						,
	LATIN_CAPITAL_LETTER_I						,
	LATIN_CAPITAL_LETTER_J						,
	LATIN_CAPITAL_LETTER_K						,
	LATIN_CAPITAL_LETTER_L						,
	LATIN_CAPITAL_LETTER_M						,
	LATIN_CAPITAL_LETTER_N						,
	LATIN_CAPITAL_LETTER_O						,
	LATIN_CAPITAL_LETTER_P						,
	LATIN_CAPITAL_LETTER_Q						,
	LATIN_CAPITAL_LETTER_R						,
	LATIN_CAPITAL_LETTER_S						,
	LATIN_CAPITAL_LETTER_T						,
	LATIN_CAPITAL_LETTER_U						,
	LATIN_CAPITAL_LETTER_V						,
	LATIN_CAPITAL_LETTER_W						,
	LATIN_CAPITAL_LETTER_X						,
	LATIN_CAPITAL_LETTER_Y						,
	LATIN_CAPITAL_LETTER_Z						,
	LEFT_SQUARE_BRACKET							,
	REVERSE_SOLIDUS								,
	RIGHT_SQUARE_BRACKET						,
	CIRCUMFLEX_ACCENT							,
	LOW_LINE									,
	GRAVE_ACCENT								,
	LATIN_SMALL_LETTER_A						,
	LATIN_SMALL_LETTER_B						,
	LATIN_SMALL_LETTER_C						,
	LATIN_SMALL_LETTER_D						,
	LATIN_SMALL_LETTER_E						,
	LATIN_SMALL_LETTER_F						,
	LATIN_SMALL_LETTER_G						,
	LATIN_SMALL_LETTER_H						,
	LATIN_SMALL_LETTER_I						,
	LATIN_SMALL_LETTER_J						,
	LATIN_SMALL_LETTER_K						,
	LATIN_SMALL_LETTER_L						,
	LATIN_SMALL_LETTER_M						,
	LATIN_SMALL_LETTER_N						,
	LATIN_SMALL_LETTER_O						,
	LATIN_SMALL_LETTER_P						,
	LATIN_SMALL_LETTER_Q						,
	LATIN_SMALL_LETTER_R						,
	LATIN_SMALL_LETTER_S						,
	LATIN_SMALL_LETTER_T						,
	LATIN_SMALL_LETTER_U						,
	LATIN_SMALL_LETTER_V						,
	LATIN_SMALL_LETTER_W						,
	LATIN_SMALL_LETTER_X						,
	LATIN_SMALL_LETTER_Y						,
	LATIN_SMALL_LETTER_Z						,
	LEFT_CURLY_BRACKET							,
	VERTICAL_LINE								,
	RIGHT_CURLY_BRACKET							,
	TILDE										,
	CHAR_DELETE									,
	EURO_SIGN									,
	SPACE								, // undef
	SINGLE_LOW_9_QUOTATION_MARK					,
	LATIN_SMALL_LETTER_F_WITH_HOOK				,
	DOUBLE_LOW_9_QUOTATION_MARK					,
	HORIZONTAL_ELLIPSIS							,
	DAGGER										,
	DOUBLE_DAGGER								,
	MODIFIER_LETTER_CIRCUMFLEX_ACCENT			,
	PER_MILLE_SIGN								,
	LATIN_CAPITAL_LETTER_S_WITH_CARON			,
	SINGLE_LEFT_POINTING_ANGLE_QUOTATION_MARK	,
	LATIN_CAPITAL_LIGATURE_OE					,
	SPACE								, // undef
	LATIN_CAPITAL_LETTER_Z_WITH_CARON			,
	SPACE								, // undef
	SPACE								, // undef
	LEFT_SINGLE_QUOTATION_MARK					,
	APOSTROPHE									,
	LEFT_DOUBLE_QUOTATION_MARK					,
	RIGHT_DOUBLE_QUOTATION_MARK					,
	BULLET										,
	EN_DASH										,
	EM_DASH										,
	SMALL_TILDE									,
	TRADE_MARK_SIGN								,
	LATIN_SMALL_LETTER_S_WITH_CARON				,
	SINGLE_RIGHT_POINTING_ANGLE_QUOTATION_MARK	,
	LATIN_SMALL_LIGATURE_OE						,
	SPACE								, // undef
	LATIN_SMALL_LETTER_Z_WITH_CARON				,
	LATIN_CAPITAL_LETTER_Y_WITH_DIAERESIS		,
	NO_BREAK_SPACE								,
	INVERTED_EXCLAMATION_MARK					,
	CENT_SIGN									,
	POUND_SIGN									,
	CURRENCY_SIGN								,
	YEN_SIGN									,
	BROKEN_BAR									,
	SECTION_SIGN								,
	DIAERESIS									,
	COPYRIGHT_SIGN								,
	FEMININE_ORDINAL_INDICATOR					,
	LEFT_POINTING_DOUBLE_ANGLE_QUOTATION_MARK	,
	NOT_SIGN									,
	SOFT_HYPHEN									,
	REGISTERED_SIGN								,
	MACRON										,
	DEGREE_SIGN									,
	PLUS_MINUS_SIGN								,
	SUPERSCRIPT_TWO								,
	SUPERSCRIPT_THREE							,
	ACUTE_ACCENT								,
	MICRO_SIGN									,
	PILCROW_SIGN								,
	MIDDLE_DOT									,
	CEDILLA										,
	SUPERSCRIPT_ONE								,
	MASCULINE_ORDINAL_INDICATOR					,
	RIGHT_POINTING_DOUBLE_ANGLE_QUOTATION_MARK	,
	VULGAR_FRACTION_ONE_QUARTER					,
	VULGAR_FRACTION_ONE_HALF					,
	VULGAR_FRACTION_THREE_QUARTERS				,
	INVERTED_QUESTION_MARK						,
	LATIN_CAPITAL_LETTER_A_WITH_GRAVE			,
	LATIN_CAPITAL_LETTER_A_WITH_ACUTE			,
	LATIN_CAPITAL_LETTER_A_WITH_CIRCUMFLEX		,
	LATIN_CAPITAL_LETTER_A_WITH_TILDE			,
	LATIN_CAPITAL_LETTER_A_WITH_DIAERESIS		,
	LATIN_CAPITAL_LETTER_A_WITH_RING_ABOVE		,
	LATIN_CAPITAL_LETTER_AE						,
	LATIN_CAPITAL_LETTER_C_WITH_CEDILLA			,
	LATIN_CAPITAL_LETTER_E_WITH_GRAVE			,
	LATIN_CAPITAL_LETTER_E_WITH_ACUTE			,
	LATIN_CAPITAL_LETTER_E_WITH_CIRCUMFLEX		,
	LATIN_CAPITAL_LETTER_E_WITH_DIAERESIS		,
	LATIN_CAPITAL_LETTER_I_WITH_GRAVE			,
	LATIN_CAPITAL_LETTER_I_WITH_ACUTE			,
	LATIN_CAPITAL_LETTER_I_WITH_CIRCUMFLEX		,
	LATIN_CAPITAL_LETTER_I_WITH_DIAERESIS		,
	LATIN_CAPITAL_LETTER_ETH					,
	LATIN_CAPITAL_LETTER_N_WITH_TILDE			,
	LATIN_CAPITAL_LETTER_O_WITH_GRAVE			,
	LATIN_CAPITAL_LETTER_O_WITH_ACUTE			,
	LATIN_CAPITAL_LETTER_O_WITH_CIRCUMFLEX		,
	LATIN_CAPITAL_LETTER_O_WITH_TILDE			,
	LATIN_CAPITAL_LETTER_O_WITH_DIAERESIS		,
	MULTIPLICATION_SIGN							,
	LATIN_CAPITAL_LETTER_O_WITH_STROKE			,
	LATIN_CAPITAL_LETTER_U_WITH_GRAVE			,
	LATIN_CAPITAL_LETTER_U_WITH_ACUTE			,
	LATIN_CAPITAL_LETTER_U_WITH_CIRCUMFLEX		,
	LATIN_CAPITAL_LETTER_U_WITH_DIAERESIS		,
	LATIN_CAPITAL_LETTER_Y_WITH_ACUTE			,
	LATIN_CAPITAL_LETTER_THORN					,
	LATIN_SMALL_LETTER_SHARP_S					,
	LATIN_SMALL_LETTER_A_WITH_GRAVE				,
	LATIN_SMALL_LETTER_A_WITH_ACUTE				,
	LATIN_SMALL_LETTER_A_WITH_CIRCUMFLEX		,
	LATIN_SMALL_LETTER_A_WITH_TILDE				,
	LATIN_SMALL_LETTER_A_WITH_DIAERESIS			,
	LATIN_SMALL_LETTER_A_WITH_RING_ABOVE		,
	LATIN_SMALL_LETTER_AE						,
	LATIN_SMALL_LETTER_C_WITH_CEDILLA			,
	LATIN_SMALL_LETTER_E_WITH_GRAVE				,
	LATIN_SMALL_LETTER_E_WITH_ACUTE				,
	LATIN_SMALL_LETTER_E_WITH_CIRCUMFLEX		,
	LATIN_SMALL_LETTER_E_WITH_DIAERESIS			,
	LATIN_SMALL_LETTER_I_WITH_GRAVE				,
	LATIN_SMALL_LETTER_I_WITH_ACUTE				,
	LATIN_SMALL_LETTER_I_WITH_CIRCUMFLEX		,
	LATIN_SMALL_LETTER_I_WITH_DIAERESIS			,
	LATIN_SMALL_LETTER_ETH						,
	LATIN_SMALL_LETTER_N_WITH_TILDE				,
	LATIN_SMALL_LETTER_O_WITH_GRAVE				,
	LATIN_SMALL_LETTER_O_WITH_ACUTE				,
	LATIN_SMALL_LETTER_O_WITH_CIRCUMFLEX		,
	LATIN_SMALL_LETTER_O_WITH_TILDE				,
	LATIN_SMALL_LETTER_O_WITH_DIAERESIS			,
	DIVISION_SIGN								,
	LATIN_SMALL_LETTER_O_WITH_STROKE			,
	LATIN_SMALL_LETTER_U_WITH_GRAVE				,
	LATIN_SMALL_LETTER_U_WITH_ACUTE				,
	LATIN_SMALL_LETTER_U_WITH_CIRCUMFLEX		,
	LATIN_SMALL_LETTER_U_WITH_DIAERESIS			,
	LATIN_SMALL_LETTER_Y_WITH_ACUTE				,
	LATIN_SMALL_LETTER_THORN					,
	LATIN_SMALL_LETTER_Y_WITH_DIAERESIS
	};
#endif


































































