////////////////////////////////////////////////////////////////////////////////////////////////////
/// @file   rfd_common\_rfd_platform_port.h
///
/// @brief  Declares the private OSAL RFD members
///
/// @remarks    Sirius XM Reliable File Delivery (RFD) SDK v1.01
///
/// @remarks    Copyright (c) 2009 Sirius XM Radio, Inc. All rights reserved.
////////////////////////////////////////////////////////////////////////////////////////////////////
  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/
#ifndef _RFD_PLATFORM_PORT_H_
#define _RFD_PLATFORM_PORT_H_

#if defined(RFD_OSAL)

  /**************/
 /** INCLUDES **/
/**************/

#include "standard.h"
#include "osal.h"
#include "rfd_platform_port.h"

  /***************/
 /** CONSTANTS **/
/***************/
  /**************/
 /** TYPEDEFS **/
/**************/

// Platform-specific typedefs

typedef struct port_osal_thread_struct
{
    OSAL_OBJECT_HDL hTask;
    OSAL_OBJECT_HDL hSemThreadExit;
    RFD_THREAD_START_ROUTINE_PTR dwTaskHandler;
    void *pvTaskArg;
} PORT_OSAL_THREAD_STRUCT;

typedef struct port_osal_find_file_data_info_struct
{
    char acFullFilePath[RFD_MAX_PATH_LEN+1];
    char *pcFileName;
    UN8 un8Attr;
    size_t tFileSize;

} PORT_OSAL_RFD_FIND_FILE_DATA_INFO_STRUCT;

typedef struct port_osal_find_file_data_struct
{
    char acPathToSearch[RFD_MAX_PATH_LEN+1];
    char acPathSearchString[RFD_MAX_PATH_LEN+1];
    OSAL_OBJECT_HDL hDirItems;
    OSAL_LINKED_LIST_ENTRY hCurItem;
    PORT_OSAL_RFD_FIND_FILE_DATA_INFO_STRUCT sCurrItemFindFileDataInfo;
} PORT_OSAL_FIND_FILE_DATA_STRUCT;

  /************/
 /** MACROS **/
/************/

  /****************/
 /** PROTOTYPES **/
/****************/

static N32 n32LocalTaskHandler (
    void *pvArg
        );

static BOOLEAN bSetFindFileDataInfo (
    PORT_OSAL_RFD_FIND_FILE_DATA_INFO_STRUCT * psFindFileDataInfo,
    char * pcFileName, char * pcPathName
        );


  /***************/
 /** VARIABLES **/
/***************/

#if _WIN32 && (_MSC_VER < 1900)
#ifndef _CRT_ERRNO_DEFINED
int errno;
#endif
#endif

  /**********************/
 /** INLINE FUNCTIONS **/
/**********************/

#endif //#if defined(RFD_OSAL)

#endif	// _RFD_PLATFORM_PORT_H_
