////////////////////////////////////////////////////////////////////////////////////////////////////
/// @file	multifile_manager\mfm_util_fixed_field_identity_parser.h
///
/// @brief	Declares the fixed field parser mfm utilitiy class.
///
/// @remarks	Sirius XM Reliable File Delivery (RFD) SDK
///
/// @remarks	Copyright (c) 2013 Sirius XM Radio, Inc. All rights reserved.
////////////////////////////////////////////////////////////////////////////////////////////////////

#ifndef MFM_UTIL_FIXED_FIELD_PARSER_H
#define MFM_UTIL_FIXED_FIELD_PARSER_H

#include "rfd_config.h"

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

///////////////////////////////////////////////////////////////////////////////////////////////////
/// <!-- doxygen group start symbol, don't remove. -->
/// @addtogroup MfmAPI RFD Multifile Manager (MFM) API
/// @{
///////////////////////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////////////////////////
/// @brief
/// The range information that specifies the location of a fixed length field within
/// the RFD Metadata Name string.
////////////////////////////////////////////////////////////////////////////////////////////////////

typedef struct {

    /// @brief  The character offset (from begining of string, 0 relative) at which the field begins.
    UINT16 startOffset;

    /// @brief  The number of characters in the field.
    UINT16 numChars;

} MFM_FF_NAME_RANGE_INFO_STRUCT;

////////////////////////////////////////////////////////////////////////////////////////////////////
/// @brief
/// The Fixed Field MFM File Identity Parser Configuration
///
/// This structure specifies the mapping of MFM File Identity Info fields (Subname, VersionFrom
/// and VersionTo) into the RFD Metadata Name string. It is used by the
/// MFM_UTIL_FixedFieldFileIdentityParser() function to support MFM File Identity Info parsing for
/// RFD Medata Name fields comprising File Identity fields of fixed lengths.
////////////////////////////////////////////////////////////////////////////////////////////////////

typedef struct {

    ////////////////////////////////////////////////////////////////////////////////////////////////////
    /// @brief
    /// A *Common Name* field that must exist in all RFD Metadata Name instances. Set to NULL if the
    /// Data Service does not implement a *Common Name* field.
    ////////////////////////////////////////////////////////////////////////////////////////////////////

    TCHAR * commonNameString;

    ////////////////////////////////////////////////////////////////////////////////////////////////////
    /// @brief
    /// Range Info for the *Common Name* field. This is a *don't care* for Data Services that
    /// do not implement the *Common Name* field.
    ////////////////////////////////////////////////////////////////////////////////////////////////////

    MFM_FF_NAME_RANGE_INFO_STRUCT commonNameRange;

    ////////////////////////////////////////////////////////////////////////////////////////////////////
    /// @brief
    /// Range Info for the File Identity *SubName* field.
    ////////////////////////////////////////////////////////////////////////////////////////////////////

    MFM_FF_NAME_RANGE_INFO_STRUCT subnameRange;

    ////////////////////////////////////////////////////////////////////////////////////////////////////
    /// @brief
    /// Range Info for the File Identity *VersionFrom* field.
    ////////////////////////////////////////////////////////////////////////////////////////////////////

    MFM_FF_NAME_RANGE_INFO_STRUCT versionFromRange;

    ////////////////////////////////////////////////////////////////////////////////////////////////////
    /// @brief
    /// Range Info for the File Identity *VersionTo* field.
    ////////////////////////////////////////////////////////////////////////////////////////////////////

    MFM_FF_NAME_RANGE_INFO_STRUCT versionToRange;

    ////////////////////////////////////////////////////////////////////////////////////////////////////
    /// @brief
    /// The expected length in characters of the RFD Metadata Name. Set to 0 if the Data Service
    /// format allows for variable length RFD Metadata Name.
    ////////////////////////////////////////////////////////////////////////////////////////////////////

    UINT16 fixedNameLen;

    ////////////////////////////////////////////////////////////////////////////////////////////////////
    /// <!--
    /// @brief
    /// A default fill character that can be used for regenerating a Name type string from MFM File
    /// Identity Info. (
    ////////////////////////////////////////////////////////////////////////////////////////////////////
    /// TCHAR defaultFillChar;
    /// -->
    ////////////////////////////////////////////////////////////////////////////////////////////////////

} MFM_FF_FILE_IDENTITY_PARSER_CONFIG_STRUCT;

BOOL MFM_UTIL_FixedFieldFileIdentityParser (
            const TCHAR rfdMetadataName[],
            MFM_FILE_IDENTITY_STRUCT * fileIdentityInfo,
            const MFM_FF_FILE_IDENTITY_PARSER_CONFIG_STRUCT * nameParserConfig );

extern const MFM_FF_FILE_IDENTITY_PARSER_CONFIG_STRUCT gNonNavTrafficMfmFixedFieldFileIdentityParserConfig;

/////////////////////////////////////////////////////////////////////////////////////////////
/// <!-- doxygen group end symbol, don't remove. -->
/// @}  doxygen group end symbol, don't remove.
////////////////////////////////////////////////////////////////////////////////////////////////

#ifdef __cplusplus
}
#endif

#endif // MFM_UTIL_FIXED_FIELD_PARSER_H