/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
*
*
*
*
*
*	GLOBAL HEADER
*******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/
#ifndef OS_STDIO_H_
#define OS_STDIO_H_

  /**************/
 /** INCLUDES **/
/**************/

#include <stdarg.h>
#include <stdio.h>

  /**********************/
 /** GLOBAL CONSTANTS **/
/**********************/

  /*********************/
 /** GLOBAL TYPEDEFS **/
/*********************/

// Native OS interfaces
typedef struct os_native_interface {

#if (defined ANDROID) || (defined __INTEGRITY)
	FILE * _Stdin;
	FILE * _Stdout;
	FILE * _Stderr;
   // These two functions are needed in debug mode only for easier
	// printout without enabling Debug Output and turning DEBUG_OBJECT
	// on.
   int (*_Printf)(const char *format, ...);
   int (*_FPrintf)(FILE *stream, const char *format, ...);

#elif defined __QNX__
	FILE * _Stdin;
	FILE * _Stdout;
	FILE * _Stderr;
   int (*_Printf)(__const char *__restrict __format, ...);
   int (*_FPrintf)(FILE *__restrict __stream, __const char *__restrict __format, ...);

#else
	FILE ** _Stdin;
	FILE ** _Stdout;
	FILE ** _Stderr;
   int (*_Printf)(__const char *__restrict __format, ...);
   int (*_FPrintf)(FILE *__restrict __stream, __const char *__restrict __format, ...);

#endif

} OS_NATIVE_INTERFACE;

  /****************************/
 /** GLOBAL UNION TEMPLATES **/
/****************************/

  /**********************/
 /** GLOBAL VARIABLES **/
/**********************/

#if OSAL_REMOTE_CONSOLE == 1
extern int gSockfd;
extern int gConsoleSockfd;
#endif

// Saved pointers to native interfaces
extern const OS_NATIVE_INTERFACE GsNativeIntf;

  /*******************/
 /** GLOBAL MACROS **/
/*******************/
#define FAKE_STDIN    ((FILE*)0xF0000001)
#define FAKE_STDOUT   ((FILE*)0xF0000002)
#define FAKE_STDERR   ((FILE*)0xF0000003)

#ifndef EOK
#define EOK 0
#endif

  /***********************/
 /** GLOBAL PROTOTYPES **/
/***********************/

FILE *OS_FOpen(const char *pFileName, const char *pMode);
int OS_FClose(FILE *pFile);
size_t OS_FRead(void *pData, size_t tSize, size_t tNumber, FILE *pFile);
size_t OS_FWrite(const void *pData, size_t tSize, size_t tNumber,
    FILE *pFile);
long OS_FTell(FILE *pFile);
int OS_Ioctl( void *psFile, int iCmd, va_list *ptList );
int OS_FSeek(FILE *pFile, long lOffset, int iMode) ;
int OS_Remove(const char *sFileName) ;
int OS_Rename(const char *sOldName, const char *sNewName);
int OS_FFlush(FILE *pFile);
int OS_FError(FILE *pFile);
int OS_FEof(FILE *pFile);
void OS_Clearerr(FILE *pFile);
int OS_Fileno(FILE *pFile);

  /*****************************/
 /** GLOBAL INLINE FUNCTIONS **/
/*****************************/

#endif	// OS_STDIO_H_
