/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
*
*
*
*
*
*	GLOBAL HEADER
*******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/
#ifndef OS_MEM_H_
#define OS_MEM_H_

  /**************/
 /** INCLUDES **/
/**************/

#include "standard.h"

  /**********************/
 /** GLOBAL CONSTANTS **/
/**********************/

  /*********************/
 /** GLOBAL TYPEDEFS **/
/*********************/

  /****************************/
 /** GLOBAL UNION TEMPLATES **/
/****************************/

  /**********************/
 /** GLOBAL VARIABLES **/
/**********************/

  /*******************/
 /** GLOBAL MACROS **/
/*******************/

  /***********************/
 /** GLOBAL PROTOTYPES **/
/***********************/

BOOLEAN OS_bMemRead8 (
    const void *pvMemoryAddress,
    UN8 *pun8Value
        );

BOOLEAN OS_bMemWrite8 (
     void *pvMemoryAddress,
     UN8 un8Value
         );

BOOLEAN OS_bMemRead16 (
     const void *pvMemoryAddress,
     UN16 *pun16Value
         );

BOOLEAN OS_bMemWrite16 (
      void *pvMemoryAddress,
      UN16 un16Value
          );

BOOLEAN OS_bMemRead32 (
     const void *pvMemoryAddress,
     UN32 *pun32Value
         );

BOOLEAN OS_bMemWrite32 (
      void *pvMemoryAddress,
      UN32 un32Value
          );

BOOLEAN OS_bPortRead8 (
     const void *pvPortAddress,
     UN8 *pun8Value
         );

BOOLEAN OS_bPortWrite8 (
      void *pvPortAddress,
      UN8 un8Value
          );

BOOLEAN OS_bPortRead16 (
      const void *pvPortAddress,
      UN16 *pun16Value
          );

BOOLEAN OS_bPortWrite16 (
       void *pvPortAddress,
       UN16 un16Value
           );

BOOLEAN OS_bPortRead32 (
      const void *pvPortAddress,
      UN32 *pun32Value
          );

BOOLEAN OS_bPortWrite32 (
       void *pvPortAddress,
       UN32 un32Value
           );

BOOLEAN OS_bMemCpy (
      void *pvDst,
      const void *pvSrc,
      size_t tSize
          );

BOOLEAN OS_bMemSet (
      void *pvDst,
      UN8 un8Value,
      size_t tSize
          );

void *OS_pvMemoryAllocate(
      const char *pacName,
      size_t tSize,
      BOOLEAN bZeroInitialize,
      size_t *ptActualSizeAllocated
          );

void OS_vMemoryFree(
      void *pvMemoryAddress,
      size_t *ptNumBytesFreed
          );

UN32 OS_un32TotalSystemBytes( void );

  /*****************************/
 /** GLOBAL INLINE FUNCTIONS **/
/*****************************/

#endif	// OS_MEM_H_
