/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
*
*
*
*
*
*	GLOBAL HEADER
*******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/
#ifndef OS_H_
#define OS_H_

  /**************/
 /** INCLUDES **/
/**************/

#include "osal.h"

  /**********************/
 /** GLOBAL CONSTANTS **/
/**********************/

  /*********************/
 /** GLOBAL TYPEDEFS **/
/*********************/

  /****************************/
 /** GLOBAL UNION TEMPLATES **/
/****************************/

  /**********************/
 /** GLOBAL VARIABLES **/
/**********************/

// This is an external declaration for the OS-port interface
extern const OS_INTF_STRUCT OS;

// This is an external declaration for the File System Interface implemented
// by the included OS-port.
extern const OSAL_FILE_INTERFACE_STRUCT GsFSIntf;

  /*******************/
 /** GLOBAL MACROS **/
/*******************/

  /***********************/
 /** GLOBAL PROTOTYPES **/
/***********************/

extern void *OSALC_pvMemoryAllocate (
      const char *pacName,
      size_t tSize,
      BOOLEAN bZeroInitialize
          );

extern void OSALC_vMemoryFree (
      void *pvMemoryAddress
          );

  /*****************************/
 /** GLOBAL INLINE FUNCTIONS **/
/*****************************/

#endif	// OS_H_
