/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
*
*
*
*
*
* DESCRIPTION
*
* PRIVATE HEADER
*
*******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/
#ifndef _OS_GENERAL_H_
#define _OS_GENERAL_H_

  /**************/
 /** INCLUDES **/
/**************/

#include <signal.h>

#include "standard.h"
#include "os_general.h"

  /***************/
 /** CONSTANTS **/
/***************/

  /**************/
 /** TYPEDEFS **/
/**************/

typedef struct os_cpu_stat_struct {
    long unsigned int utime_ticks;
    long int cutime_ticks;
    long unsigned int stime_ticks;
    long int cstime_ticks;
    long unsigned int cpu_total_time;
    unsigned int cpu_num;
} OS_CPU_STAT_STRUCT;

typedef struct os_cpu_struct {
    // CPU utilization specific data
    OS_CPU_STAT_STRUCT sCPUInitialStat;
    UN8 un8CPUMin;
    UN8 un8CPUMax;
    UN8 un8CPUCurrent;
    BOOLEAN bCPUStatInitialized;
} OS_CPU_STRUCT;

  /***************/
 /** VARIABLES **/
/***************/

// CPU control structure
OS_CPU_STRUCT GsCPUCtrl;

// Global control structure
OS_GENERAL_STRUCT GsCtrl;

  /************/
 /** MACROS **/
/************/

  /****************/
 /** PROTOTYPES **/
/****************/

static void OS_vSuspendSignalHandler(
#ifdef __QNX__
    int iSignal,
    siginfo_t *ptSignalInfo,
    void *pvArg
#else
    int iSignal
#endif
        );

static void OS_vResumeSignalHandler(
#ifdef __QNX__
    int iSignal,
    siginfo_t *ptSignalInfo,
    void *pvArg
#else
    int iSignal
#endif
        );

static UN8 un8CalcCPUUsage(
    OS_CPU_STAT_STRUCT *psCurUsage,
    OS_CPU_STAT_STRUCT *psLastUsage
        );

static BOOLEAN bGetCPUUsage(OS_CPU_STAT_STRUCT *psResult);

#if OSAL_DEBUG == 1
static void vConfigureStdio( void );
#if OSAL_REMOTE_CONSOLE == 1
#else
static void vConfigureStdioParameters( int iFileId );
#endif
#if OSAL_REMOTE_CONSOLE == 1
static int iStartRemoteConsole( void );
#endif
#endif

  /**********************/
 /** INLINE FUNCTIONS **/
/**********************/

#endif	// _OS_GENERAL_H_
