/******************************************************************************/
/*                    Copyright (c) Sirius-XM Satellite Radio Inc.            */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius-XM Satellite Radio Inc.    */
/*                           Proprietary & Confidential                        */
/******************************************************************************/
/*******************************************************************************
*
*
*
*
*
*  GLOBAL HEADER
*******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/
#ifndef OSAL_TRACE_H_
#define OSAL_TRACE_H_

#ifdef __cplusplus
extern "C" {
#endif

  /**************/
 /** INCLUDES **/
/**************/
#include <time.h>
#include <stdio.h>
#include "standard.h"

  /**********************/
 /** GLOBAL CONSTANTS **/
/**********************/

   /*********************/
  /** GLOBAL TYPEDEFS **/
 /*********************/

   /****************************/
  /** GLOBAL STRUCT TEMPLATES **/
 /*****************************/

   /****************************/
  /** GLOBAL UNION TEMPLATES **/
 /****************************/

   /**********************/
  /** GLOBAL VARIABLES **/
 /**********************/

   /*******************/
  /** GLOBAL MACROS **/
 /*******************/
#if ((OSAL_DEBUG == 1) && (OSAL_TRACE_ENABLE == 1))
   #ifdef ANDROID

		//Android LogCat code follows
		#ifdef LOG_TAG
      #undef LOG_TAG
		#endif
      #define LOG_TAG      "SIRIUS"

		#include <utils/Log.h>

		#define TRACE_START()   LOGI("[%#8.8x] %s (%d): function enter", pthread_self(), __FUNCTION__, __LINE__);
		#define TRACE_END()     LOGI("[%#8.8x] %s (%d): function exit", pthread_self(), __FUNCTION__, __LINE__);

	#elif defined __QNX__

		#define TRACE_START()
		#define TRACE_END()

    #else

		#define TRACE_START()   fprintf( stderr, "[%#8.8x] %s (%d) enter\n", pthread_self(), __FUNCTION__, __LINE__);
		#define TRACE_END()     fprintf( stderr, "[%#8.8x] %s (%d) exit\n", pthread_self(), __FUNCTION__, __LINE__);

    #endif

#else

   #define TRACE_START()
   #define TRACE_END()

#endif //DEBUG==1

   /***********************/
  /** GLOBAL PROTOTYPES **/
 /***********************/

#ifdef __cplusplus
}
#endif

#endif /* OSAL_TRACE_H_ */

