/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
*
*
*
*
*
*	GLOBAL HEADER
*******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/
#ifndef OSAL_SEM_H_
#define OSAL_SEM_H_

  /**************/
 /** INCLUDES **/
/**************/
#include <stdlib.h>

#include "standard.h"

#include "osal.h"

/**********************/
 /** GLOBAL CONSTANTS **/
/**********************/

  /*********************/
 /** GLOBAL TYPEDEFS **/
/*********************/

  /****************************/
 /** GLOBAL UNION TEMPLATES **/
/****************************/

  /**********************/
 /** GLOBAL VARIABLES **/
/**********************/

  /*******************/
 /** GLOBAL MACROS **/
/*******************/

  /***********************/
 /** GLOBAL PROTOTYPES **/
/***********************/

OSAL_RETURN_CODE_ENUM OSAL_eSemCreate (
    OSAL_OBJECT_HDL *phSemObj,
    const char *pacName,
    UN32 un32InitialValue,
    UN32 un32Resources,
    UN32 un32Options
        );

OSAL_RETURN_CODE_ENUM OSAL_eSemDelete (
    OSAL_OBJECT_HDL hSemObj
        );

OSAL_RETURN_CODE_ENUM OSAL_eSemGive (
    OSAL_OBJECT_HDL hSemObj
        );

OSAL_RETURN_CODE_ENUM OSAL_eSemTake (
    OSAL_OBJECT_HDL hSemObj,
    N32 n32Timeout
        );

OSAL_OBJECT_HDL OSAL_hSemGetHandleByName (
    const char *pacName
        );

OSAL_RETURN_CODE_ENUM OSAL_eSemGetInfo (
    OSAL_OBJECT_HDL hSemObj,
    OSAL_SEM_INFO_STRUCT *psSemInfo
        );

OSAL_RETURN_CODE_ENUM OSAL_eSemList ( void );

#if (OSAL_DEBUG == 1)

BOOLEAN OSALS_bPrintSemaphore ( void *pvData, void *pvArg );

#endif /* (OSAL_DEBUG == 1) */

/*****************************/
 /** GLOBAL INLINE FUNCTIONS **/
/*****************************/

#endif	// OSAL_SEM_H_
