/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
*
*
*
*
*
*	GLOBAL HEADER
*******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/
#ifndef OSAL_MONITOR_H_
#define OSAL_MONITOR_H_

  /**************/
 /** INCLUDES **/
/**************/
#include <stdlib.h>

#include "standard.h"

#include "osal.h"

  /**********************/
 /** GLOBAL CONSTANTS **/
/**********************/

  /*********************/
 /** GLOBAL TYPEDEFS **/
/*********************/

  /****************************/
 /** GLOBAL UNION TEMPLATES **/
/****************************/

  /**********************/
 /** GLOBAL VARIABLES **/
/**********************/

  /*******************/
 /** GLOBAL MACROS **/
/*******************/

  /***********************/
 /** GLOBAL PROTOTYPES **/
/***********************/

BOOLEAN OSALM_bTaskInstall(
    OSAL_TASK_PRIORITY_ENUM ePriority,
    const OSAL_MONITOR_HANDLER_STRUCT *psMonitorHandlers
        );

void OSALM_vTaskUninstall( void );

OSAL_RETURN_CODE_ENUM OSALM_eTaskRegister (
    UN16 un16ReportingInterval,
    OSAL_SLEEP_HANDLER tSleepHandler,
    OSAL_WAKEUP_HANDLER tWakeupHandler,
    OSAL_SHUTDOWN_HANDLER tShutdownHandler,
    void *pvHandlerArgument
        );

OSAL_RETURN_CODE_ENUM OSALM_eTaskUnregister ( void );

OSAL_RETURN_CODE_ENUM OSALM_eTaskReport (
    N32 n32Status
        );

void OSALM_vReportError (
    OSAL_RETURN_CODE_ENUM eErrorCode
        );

  /*****************************/
 /** GLOBAL INLINE FUNCTIONS **/
/*****************************/

#endif	// OSAL_MONITOR_H_
