/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
*
*
*
*
*
*	GLOBAL HEADER
*******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/
#ifndef OSAL_MEM_H_
#define OSAL_MEM_H_

  /**************/
 /** INCLUDES **/
/**************/
#include <stdlib.h>

#include "standard.h"

#include "osal.h"

  /**********************/
 /** GLOBAL CONSTANTS **/
/**********************/

  /*********************/
 /** GLOBAL TYPEDEFS **/
/*********************/

  /****************************/
 /** GLOBAL UNION TEMPLATES **/
/****************************/

  /**********************/
 /** GLOBAL VARIABLES **/
/**********************/

/*******************/
 /** GLOBAL MACROS **/
/*******************/

  /***********************/
 /** GLOBAL PROTOTYPES **/
/***********************/

BOOLEAN OSAL_bMemRead8 (
    const void *pvMemoryAddress,
    UN8 *pun8Value
        );

BOOLEAN OSAL_bMemWrite8 (
     void *pvMemoryAddress,
     UN8 un8Value
         );

BOOLEAN OSAL_bMemRead16 (
     const void *pvMemoryAddress,
     UN16 *pun16Value
         );

BOOLEAN OSAL_bMemWrite16 (
      void *pvMemoryAddress,
      UN16 un16Value
          );

BOOLEAN OSAL_bMemRead32 (
     const void *pvMemoryAddress,
     UN32 *pun32Value
         );

BOOLEAN OSAL_bMemWrite32 (
      void *pvMemoryAddress,
      UN32 un32Value
          );

BOOLEAN OSAL_bPortRead8 (
     const void *pvPortAddress,
     UN8 *pun8Value
         );

BOOLEAN OSAL_bPortWrite8 (
      void *pvPortAddress,
      UN8 un8Value
          );

BOOLEAN OSAL_bPortRead16 (
      const void *pvPortAddress,
      UN16 *pun16Value
          );

BOOLEAN OSAL_bPortWrite16 (
       void *pvPortAddress,
       UN16 un16Value
           );

BOOLEAN OSAL_bPortRead32 (
      const void *pvPortAddress,
      UN32 *pun32Value
          );

BOOLEAN OSAL_bPortWrite32 (
       void *pvPortAddress,
       UN32 un32Value
           );

BOOLEAN OSAL_bMemCpy (
      void *pvDst,
      const void *pvSrc,
      size_t tSize
          );

BOOLEAN OSAL_bMemSet (
      void *pvDst,
      UN8 un8Value,
      size_t tSize
          );

void *OSAL_pvMemoryAllocate(
      const char *pacName,
      size_t tSize,
      BOOLEAN bZeroInitialize
          );

void OSAL_vMemoryFree(
      void *pvMemoryAddress
          );

OSAL_RETURN_CODE_ENUM OSAL_eMemoryList (
	const char *pacFilterText
		);

void OSALM_vPrintMemoryBlock(void *pvObj);

  /*****************************/
 /** GLOBAL INLINE FUNCTIONS **/
/*****************************/

#endif	// OSAL_MEM_H_
