/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
*
*
*
*
*
*	GLOBAL HEADER
*******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/
#ifndef OSAL_LOG_H_
#define OSAL_LOG_H_

  /**************/
 /** INCLUDES **/
/**************/
#include "standard.h"

#include "osal.h"

  /**********************/
 /** GLOBAL CONSTANTS **/
/**********************/

  /*********************/
 /** GLOBAL TYPEDEFS **/
/*********************/

  /****************************/
 /** GLOBAL UNION TEMPLATES **/
/****************************/

  /**********************/
 /** GLOBAL VARIABLES **/
/**********************/

  /*******************/
 /** GLOBAL MACROS **/
/*******************/

  /***********************/
 /** GLOBAL PROTOTYPES **/
/***********************/

OSAL_RETURN_CODE_ENUM OSAL_eLogCreate(
    OSAL_OBJECT_HDL *phLog,
    const char *pacName,
    N32 n32Size,
    UN32 un32Options
        );

OSAL_RETURN_CODE_ENUM OSAL_eLogDelete(
    OSAL_OBJECT_HDL hLog
        );

N32 OSAL_n32LogWrite(
    OSAL_OBJECT_HDL hLog,
    const char *pcFormat,
    ...
        );

N32 OSAL_n32VLogWrite(
    OSAL_OBJECT_HDL hLog,
    const char *pcFormat,
    va_list *ptArgList
        );

N32 OSAL_n32LogRead(
    OSAL_OBJECT_HDL hLog,
    char *pcDest,
    N32 n32Position,
    N32 n32Length
        );

OSAL_RETURN_CODE_ENUM OSAL_eLogClear(
    OSAL_OBJECT_HDL hLog
        );

void OSAL_vLogDisable( OSAL_OBJECT_HDL hLog );

void OSAL_vLogEnable( OSAL_OBJECT_HDL hLog );

void OSAL_vLogPersist( OSAL_OBJECT_HDL hLog, BOOLEAN bPersist );

OSAL_OBJECT_HDL OSAL_hLogGetHandleByName (
    const char *pacName
        );

OSAL_RETURN_CODE_ENUM OSAL_eLogGetInfo (
    OSAL_OBJECT_HDL hLog,
    OSAL_LOG_INFO_STRUCT *psLogInfo
        );

OSAL_RETURN_CODE_ENUM OSAL_eLogList  ( BOOLEAN bVerbose );

OSAL_RETURN_CODE_ENUM OSAL_eLogIterate  (
    OSAL_LOG_ITERATOR_HANDLER pbIterator,
    void *pvIteratorArg
        );

  /*****************************/
 /** GLOBAL INLINE FUNCTIONS **/
/*****************************/

#endif	// OSAL_LOG_H_
