/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/*                           Proprietary & Confidential	                      */
/******************************************************************************/
/*******************************************************************************
*
*
*
*
*
*DESCRIPTION
*
*       This module will contain all the OSAL int APIs.
*
*******************************************************************************/

#if OSAL_INTERRUPT == 1

#include <stdlib.h>
#include <stdio.h>

#include "standard.h"

#include "osal_version.h"

#include "osal.h"

#include "osal_core.h"
#include "_osal_int.h"

/*******************************************************************************
*
*   OSAL_eIntCreate
*
*******************************************************************************/
OSAL_RETURN_CODE_ENUM OSAL_eIntCreate (
    OSAL_OBJECT_HDL *phIntObj,
    const char *pacName,
    UN32 un32InterruptNumber,
    OSAL_INTERRUPT_HANDLER tInterruptHandler,
    const void *pvInterruptHandlerArg
        )
{
    OSAL_RETURN_CODE_ENUM eReturnCode = OSAL_ERROR_UNSUPPORTED_API;

    return eReturnCode;
}

/*******************************************************************************
*
*   OSAL_eIntDelete
*
*******************************************************************************/
OSAL_RETURN_CODE_ENUM OSAL_eIntDelete (
    OSAL_OBJECT_HDL hIntObj
        )
{
    OSAL_RETURN_CODE_ENUM eReturnCode = OSAL_ERROR_UNSUPPORTED_API;

    return eReturnCode;
}

/*******************************************************************************
*
*   OSAL_eIntEnable
*
*******************************************************************************/
OSAL_RETURN_CODE_ENUM OSAL_eIntEnable (
    OSAL_OBJECT_HDL hIntObj
        )
{
    OSAL_RETURN_CODE_ENUM eReturnCode = OSAL_ERROR_UNSUPPORTED_API;

    return eReturnCode;
}

/*******************************************************************************
*
*   OSAL_eIntDisable
*
*******************************************************************************/
OSAL_RETURN_CODE_ENUM OSAL_eIntDisable (
    OSAL_OBJECT_HDL hIntObj
        )
{
    OSAL_RETURN_CODE_ENUM eReturnCode = OSAL_ERROR_UNSUPPORTED_API;

    return eReturnCode;
}

/*******************************************************************************
*
*   OSAL_eIntAcknowledge
*
*******************************************************************************/
OSAL_RETURN_CODE_ENUM OSAL_eIntAcknowledge (
    OSAL_OBJECT_HDL hIntObj
        )
{
    OSAL_RETURN_CODE_ENUM eReturnCode = OSAL_ERROR_UNSUPPORTED_API;

    return eReturnCode;
}

/*******************************************************************************
*
*   OSAL_hIntGetHandleByName
*
*******************************************************************************/
OSAL_OBJECT_HDL OSAL_hIntGetHandleByName (
    const char *pacName
        )
{
    OSAL_OBJECT_HDL hObjectHdl = OSAL_INVALID_OBJECT_HDL;
    OSAL_OBJECT_STRUCT *psObj;

    // Call OS specific API
    //hObjectHdl = OS.hIntGetHandleByName(pacName);

    psObj = OSALC_psFindObjectFromName(OSAL_OBJECT_TYPE_INTERRUPT, pacName);
    if(psObj != NULL)
    {
        hObjectHdl = psObj->sHeader.hObject;
    }

    return hObjectHdl;
}

/*******************************************************************************
*
*   OSAL_eIntGetInfo
*
*******************************************************************************/
OSAL_RETURN_CODE_ENUM OSAL_eIntGetInfo (
    OSAL_OBJECT_HDL hIntObj,
    OSAL_INT_INFO_STRUCT *psIntInfo
        )
{
    OSAL_RETURN_CODE_ENUM eReturnCode = OSAL_ERROR_UNSUPPORTED_API;

    return eReturnCode;
}

/*******************************************************************************
*
*   OSAL_eIntList
*
*******************************************************************************/
OSAL_RETURN_CODE_ENUM OSAL_eIntList ( void )
{
    OSAL_RETURN_CODE_ENUM eReturnCode = OSAL_ERROR_UNSUPPORTED_API;
    OSAL_STATISTICS_STRUCT sStatistics;

    // Get the object's statistics
    OSALC_vGetObjectStatistics(OSAL_OBJECT_TYPE_INTERRUPT, &sStatistics);

    // Print statistics
    printf("Current = %u, Minimum = %u, Maximum = %u\n",
           sStatistics.un32Current,
           sStatistics.un32Minimum,
           sStatistics.un32Maximum );

    return eReturnCode;
}

#endif /* OSAL_INTERRUPT == 1 */

