/******************************************************************************/
/*                    Copyright (c) Sirius-XM Satellite Radio Inc.            */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius-XM Satellite Radio Inc.    */
/*                           Proprietary & Confidential	                      */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * This is the FIXED Object header file.
 *
 ******************************************************************************/

#ifndef FIXED_OBJ_H_
#define FIXED_OBJ_H_

#ifdef __cplusplus
extern "C" {
#endif


  /**********************/
 /** GLOBAL CONSTANTS **/
/**********************/

  /*********************/
 /** GLOBAL TYPEDEFS **/
/*********************/

  /****************************/
 /** GLOBAL STRUCT TEMPLATES **/
/*****************************/

  /****************************/
 /** GLOBAL UNION TEMPLATES **/
/****************************/

  /**********************/
 /** GLOBAL VARIABLES **/
/**********************/

  /*******************/
 /** GLOBAL MACROS **/
/*******************/

  /***********************/
 /** GLOBAL PROTOTYPES **/
/***********************/
OSAL_FIXED_OBJECT FIXED_hCreate (
    N32 n32WholeValue,
    N32 n32FractionalValue,
    UN8 un8Pow10
        );

OSAL_FIXED_OBJECT FIXED_hCreateFromFixed(
    N32 n32FixedValue,
    UN8 un8NumFractionalBits
        );

OSAL_FIXED_OBJECT FIXED_hCreateInMemory (
    N32 n32FixedValue,
    UN8 un8NumFractionalBits,
    void *pvMemory
        );

OSAL_FIXED_OBJECT FIXED_hDuplicate (
    OSAL_FIXED_OBJECT hFixed
        );

OSAL_FIXED_OBJECT FIXED_hDuplicateInMemory (
    OSAL_FIXED_OBJECT hFixed,
    void *pvMemory
        );

BOOLEAN FIXED_bCopyToMemory (
    OSAL_FIXED_OBJECT hFixed,
    void *pvMemory
        );

void FIXED_vDestroy (
    OSAL_FIXED_OBJECT hFixed
        );

N32 FIXED_n32Value (
    OSAL_FIXED_OBJECT hFixed
        );

UN8 FIXED_un8NumFractionalBits (
    OSAL_FIXED_OBJECT hFixed
        );

N32 FIXED_n32ScaledValue (
    OSAL_FIXED_OBJECT hFixed,
    UN8 un8NumFractionalBits
        );

N32 FIXED_n32Ceiling (
    OSAL_FIXED_OBJECT hFixed
        );

N32 FIXED_n32Floor (
    OSAL_FIXED_OBJECT hFixed
        );

OSAL_RETURN_CODE_ENUM FIXED_eAdd (
    OSAL_FIXED_OBJECT hFixed1,
    OSAL_FIXED_OBJECT hFixed2,
    OSAL_FIXED_OBJECT hResult
        );

OSAL_RETURN_CODE_ENUM FIXED_eSubtract (
    OSAL_FIXED_OBJECT hFixed1,
    OSAL_FIXED_OBJECT hFixed2,
    OSAL_FIXED_OBJECT hResult
        );

OSAL_RETURN_CODE_ENUM FIXED_eMultiply (
    OSAL_FIXED_OBJECT hFixed1,
    OSAL_FIXED_OBJECT hFixed2,
    OSAL_FIXED_OBJECT hResult
        );

OSAL_RETURN_CODE_ENUM FIXED_eDivide (
    OSAL_FIXED_OBJECT hFixedNumerator,
    OSAL_FIXED_OBJECT hFixedDenominator,
    OSAL_FIXED_OBJECT hResult
        );

OSAL_RETURN_CODE_ENUM FIXED_eDegreeToRadian (
    OSAL_FIXED_OBJECT hFixed,
    OSAL_FIXED_OBJECT hResult
        );

OSAL_RETURN_CODE_ENUM FIXED_eRadianToDegree (
    OSAL_FIXED_OBJECT hFixed,
    OSAL_FIXED_OBJECT hResult
        );

OSAL_RETURN_CODE_ENUM FIXED_eSin (
    OSAL_FIXED_OBJECT hFixed,
    OSAL_FIXED_OBJECT hResult
        );

OSAL_RETURN_CODE_ENUM FIXED_eASin (
    OSAL_FIXED_OBJECT hFixed,
    OSAL_FIXED_OBJECT hResult
        );

OSAL_RETURN_CODE_ENUM FIXED_eCos (
    OSAL_FIXED_OBJECT hFixed,
    OSAL_FIXED_OBJECT hResult
        );

OSAL_RETURN_CODE_ENUM FIXED_eACos (
    OSAL_FIXED_OBJECT hFixed,
    OSAL_FIXED_OBJECT hResult
        );

OSAL_RETURN_CODE_ENUM FIXED_eATan (
    OSAL_FIXED_OBJECT hFixed,
    OSAL_FIXED_OBJECT hResult
        );

OSAL_RETURN_CODE_ENUM FIXED_eATan2 (
    OSAL_FIXED_OBJECT hFixedY,
    OSAL_FIXED_OBJECT hFixedX,
    OSAL_FIXED_OBJECT hResult
        );

OSAL_RETURN_CODE_ENUM FIXED_eAbs (
    OSAL_FIXED_OBJECT hFixed,
    OSAL_FIXED_OBJECT hResult
        );

OSAL_RETURN_CODE_ENUM FIXED_eSqrt (
    OSAL_FIXED_OBJECT hFixed,
    OSAL_FIXED_OBJECT hResult
        );

OSAL_RETURN_CODE_ENUM FIXED_ePow (
    OSAL_FIXED_OBJECT hFixed,
    UN8 un8Power,
    OSAL_FIXED_OBJECT hResult
        );

N16 FIXED_n16Compare (
    OSAL_FIXED_OBJECT hFixed1,
    OSAL_FIXED_OBJECT hFixed2
        );

OSAL_RETURN_CODE_ENUM FIXED_eEval(
    OSAL_FIXED_OBJECT hResult,
    void *pvData,
    size_t tDataSize,
    const char *pacExpr,
    ...
        );

N32 FIXED_n32FWrite (
    OSAL_FIXED_OBJECT hFixed,
    FILE *psFile
        );

OSAL_FIXED_OBJECT FIXED_hFRead (
    FILE *psFile
        );

N32 FIXED_n32FPrintf (
    OSAL_FIXED_OBJECT hFixed,
    FILE *psFile,
    BOOLEAN bIsTerse
        );


#ifdef __cplusplus
}
#endif

#endif /* FIXED_OBJ_H_ */
