/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * PRIVATE HEADER
 *
 ******************************************************************************/

#ifndef OSAL_DEVICES_H_
#define OSAL_DEVICES_H_

#include <stdarg.h>
#include <stdlib.h>
#include <stdio.h>

#include "standard.h"

#include "osal_stdio.h"

  /**********************/
 /** GLOBAL CONSTANTS **/
/**********************/

/*
    Device Driver handle definition (one per instance, open())

    An object of DEV_HDL is returned to the caller of the API DEV_hOpen()
    and must be supplied by the caller to each of the DEV_xxx() APIs which
    take a device handle. The caller should check for handle validity by
    comparing it to DEV_INVALID_HDL.
*/

typedef void * DEV_HDL;
#define DEV_INVALID_HDL ((DEV_HDL)0)

  /*********************/
 /** GLOBAL TYPEDEFS **/
/*********************/

  /*****************************/
 /** GLOBAL STRUCT TEMPLATES **/
/*****************************/

  /****************************/
 /** GLOBAL UNION TEMPLATES **/
/****************************/

  /*******************/
 /** GLOBAL MACROS **/
/*******************/

  /***********************/
 /** GLOBAL PROTOTYPES **/
/***********************/

// A method to register a device driver
N32 DEV_n32RegNode(
    const char *pcDevName,
    const OSAL_DEV_INTERFACE_STRUCT *psInterface,
    const void *pvProperties,
    size_t tPropertySize
        );

// A method to uninitialize a device driver
BOOLEAN DEV_bUnRegNode(
    const char *pcDevName
        );

// Open a connection to a device driver
DEV_HDL DEV_hOpen(
    const char *pcDevName,
    const void *pvArg
        );

// Close a connection to a device driver
N32 DEV_n32Close(
    DEV_HDL hDevice
        );

// Read from the device
size_t DEV_tRead(
    char *pcDst,
    size_t tSize,
    size_t tNumObjs,
    DEV_HDL hDevice
        );

// Write to a device
size_t DEV_tWrite(
    const char *pcSrc,
    size_t tSize,
    size_t tNumObjs,
    DEV_HDL hDevice
        );

// Send device specific commands
N32 DEV_n32Ioctl(
    DEV_HDL hDevice,
    N32 n32Cmd,
    ...
        );

// Send device specific commands (with variable arg list pointer)
N32 DEV_n32vIoctl(
    DEV_HDL hDevice,
    N32 n32Cmd,
    va_list *ptList
        );

// Seek through a device
N32 DEV_n32Seek(
    DEV_HDL hDevice,
    N32 n32Offset,
    N8 n8Mode
        );

// retreive the error status
N32 DEV_n32Eof(
    DEV_HDL hDevice
        );

// retreive the eof status
N32 DEV_n32Error(
    DEV_HDL hDevice
        );

// clear the error and eof status
void DEV_vClearerror(
    DEV_HDL hDevice
        );

  /**********************/
 /** GLOBAL VARIABLES **/
/**********************/

#endif /* OSAL_DEVICES_H_ */
