/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
*
*
*
*
*
*	GLOBAL HEADER
*******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/
#ifndef DEBUG_TASK_H_
#define DEBUG_TASK_H_

  /**************/
 /** INCLUDES **/
/**************/

#include "standard.h"

#include "osal.h"

  /**********************/
 /** GLOBAL CONSTANTS **/
/**********************/

#define DEBUG_TASK_NAME "Debug Task"

  /*********************/
 /** GLOBAL TYPEDEFS **/
/*********************/

  /*****************************/
 /** GLOBAL STRUCT TEMPLATES **/
/*****************************/

  /****************************/
 /** GLOBAL UNION TEMPLATES **/
/****************************/

  /**********************/
 /** GLOBAL VARIABLES **/
/**********************/

  /*******************/
 /** GLOBAL MACROS **/
/*******************/

  /***********************/
 /** GLOBAL PROTOTYPES **/
/***********************/

// Task Installation/Removal
OSAL_RETURN_CODE_ENUM DEBUG_eTaskInstall( OSAL_TASK_PRIORITY_ENUM ePriority );
void DEBUG_vTaskUninstall( void );
OSAL_RETURN_CODE_ENUM DEBUG_eTaskChangePriority( OSAL_TASK_PRIORITY_ENUM eNewPriority );

// API Functions
OSAL_RETURN_CODE_ENUM DEBUG_eRegisterDebughandler(
    const char *pacName,
    OSAL_DEBUG_HANDLER hCallBackFunc,
    const void *pvArg);
OSAL_RETURN_CODE_ENUM DEBUG_eUnRegisterDebughandler( void );
void DEBUG_vEnableOutputThisTask( void );
void DEBUG_vDisableOutputThisTask( void );
void DEBUG_vCtrlOutputThisTask( BOOLEAN );
BOOLEAN DEBUG_bUpdateName( const char *pacName );
void DEBUG_vExitingDebughandler(void);
char *DEBUG_pacSetCommandLineText( char *pacText );

#if OSAL_DEBUG == 1

void DEBUG_vDebugHandler( char *pcCmdLine, const void *pvArg );

#endif /* OSAL_DEBUG == 1 */

  /*****************************/
 /** GLOBAL INLINE FUNCTIONS **/
/*****************************/

#endif	// DEBUG_TASK_H_
