/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 *   GLOBAL HEADER
 ******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/

#ifndef OSAL_CRC_H_
#define OSAL_CRC_H_

#include "standard.h"

#include "osal.h"

  /**********************/
 /** GLOBAL CONSTANTS **/
/**********************/

  /*********************/
 /** GLOBAL TYPEDEFS **/
/*********************/

typedef struct osal_crc_info_struct
{
    char acName[OSAL_MAX_OBJECT_NAME_LENGTH_WITH_NULL];

    OSAL_CRC_TYPE_ENUM eCRCType;
    size_t tReferenceCount;
    UN8 *pun8LookupTable;
    void *pvCRCData;

} OSAL_CRC_INFO_STRUCT;

  /**********************/
 /** GLOBAL VARIABLES **/
/**********************/

  /*******************/
 /** GLOBAL MACROS **/
/*******************/

  /***********************/
 /** GLOBAL PROTOTYPES **/
/***********************/

N16 OSAL_n16CompareCRC (
    void *pvObj,
    void *pvInfo
        );

/* Prototypes for requesting use / release of a CRC */
OSAL_RETURN_CODE_ENUM OSAL_eGetCRC (
    OSAL_OBJECT_HDL *phCRC,
    OSAL_CRC_TYPE_ENUM eCRCType
        );

OSAL_RETURN_CODE_ENUM OSAL_eReleaseCRC (
    OSAL_OBJECT_HDL hCRC
        );

/* CRC computation related */
BOOLEAN OSAL_bInitializeCRC (
    OSAL_OBJECT_HDL hCRC,
    OSAL_CRC_RESULT *ptInitialValue
        );

OSAL_CRC_RESULT OSAL_tComputeCRC (
    OSAL_OBJECT_HDL hCRC,
    OSAL_CRC_RESULT tInputCRC,
    OSAL_BUFFER_HDL hBuffer,
    size_t tByteOffset,
    size_t tNumBytesToProcess,
    size_t *ptBytesProcessed
        );

OSAL_RETURN_CODE_ENUM OSAL_eCRCList ( void );

#if (OSAL_DEBUG == 1)

BOOLEAN OSALS_bPrintCRC ( void *pvData, void *pvArg );

#endif /* (OSAL_DEBUG == 1) */

  /*****************************/
 /** GLOBAL INLINE FUNCTIONS **/
/*****************************/

#endif /* OSAL_CRC_H_ */
