/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/

/*********************************/
/** PREVENT REDUNDANT INCLUSION **/
/*********************************/
#ifndef _OSAL_TIMER_H_
#define _OSAL_TIMER_H_

/**************/
/** INCLUDES **/
/**************/
#include <stdlib.h>

#include "standard.h"
#include "osal_timer.h"

/***************/
/** CONSTANTS **/
/***************/

#define OSALT_TASK_OPTIONS				(OSAL_TASK_OPTION_NONE)
#define OSALT_TASK_STACK_SIZE  		    (1024)
#define OSALT_REPORTING_INTERVAL        (10) // seconds

/**************/
/** TYPEDEFS **/
/**************/

typedef struct osalt_delta_accumulator_struct
{
    // Timer number index
    UN32 un32TimerNumber;

    // Accumulated time remaining up to linked
    // list entry specified below
    UN32 un32TimeRemaining;

    // Linked list entry to accumulate time up to
    // and including.
    OSAL_LINKED_LIST_ENTRY hThisEntry;

} OSALT_DELTA_ACCUMULATOR_STRUCT;

typedef struct osalt_task_control_struct
{
    // Install Complete Semaphore
    OSAL_OBJECT_HDL hInstallSemaphore;

    // Task Handle
    OSAL_OBJECT_HDL hTask;

    // Timer Semaphore Handle
    OSAL_OBJECT_HDL hTimerSem;

    // Time data structure access semaphore
    OSAL_OBJECT_HDL hTimerDataSem;

    // Active timer linked list
    OSAL_OBJECT_HDL hActiveTimerList;

    // A timer owned by the timer-task to report to the task monitor
    OSAL_OBJECT_HDL hReportTimer;

    // Notification handle
    OSAL_TIME_NOTIFICATION_OBJECT hNotificationHandle;

} OSALT_TASK_CONTROL_STRUCT;

/***************/
/** VARIABLES **/
/***************/

static OSALT_TASK_CONTROL_STRUCT gsTimerTaskControl =
{
    OSAL_INVALID_OBJECT_HDL,
    OSAL_INVALID_OBJECT_HDL,
    OSAL_INVALID_OBJECT_HDL,
    OSAL_INVALID_OBJECT_HDL,
    OSAL_INVALID_OBJECT_HDL,
    OSAL_INVALID_OBJECT_HDL,
    OSAL_TIME_NOTIFICATION_INVALID_OBJECT
};

/************/
/** MACROS **/
/************/

/****************/
/** PROTOTYPES **/
/****************/

static UN32 OSALT_un32GetMsecElapsed( BOOLEAN bReset );
static void OSALT_vHandleTimer ( OSAL_TIMER_INFO_STRUCT *psTimer );
static N32 OSALT_n32Task ( void *pvArg );
static BOOLEAN OSALT_bTaskInitialize( void );
static void OSALT_vTaskUninitialize( void );
static void OSALT_vMarkInactivate(void *pvData);

static OSAL_RETURN_CODE_ENUM OSALT_eRemoveFromActiveList (
    OSAL_TIMER_INFO_STRUCT *psTimer,
    BOOLEAN bModifyList  );
static OSAL_RETURN_CODE_ENUM OSALT_eAddToActiveList (
    OSAL_TIMER_INFO_STRUCT *psTimer );
static void OSALT_vLockTimerData( void );
static void OSALT_vUnlockTimerData( void );
static BOOLEAN OSALT_bAccumulateDelta ( void *pvData, void *pvArg );
static BOOLEAN OSALT_bReProcessAbsoluteTimer ( void *pvData, void *pvArg );
static OSAL_RETURN_CODE_ENUM OSALT_eComputeAbsoluteTimer (
    OSAL_TIMER_INFO_STRUCT *psTimer, UN32 un32CurrentTime );
static void OSALT_vReProcessAbsoluteTimers(
    OSAL_TIME_UPDATE_MASK tUpdateMask,
    void *pvArg
        );
static void OSALT_vSleepHandler( void *pvArg );
static void OSALT_vWakeupHandler( void *pvArg );
static void OSALT_vShutdownHandler( void *pvArg );
static void OSALT_vReportHandler( OSAL_OBJECT_HDL hTimer, void *pvArg );

static OSAL_RETURN_CODE_ENUM OSALT_eInsertTimer(
    OSAL_OBJECT_HDL hTimerList,
    OSAL_TIMER_INFO_STRUCT *psTimer
        );

#if OSAL_DEBUG == 1

static void OSALT_vDebugHandler( char *pcCmdLine, const void *pvArg );
static void OSALT_vTimerCallback ( OSAL_OBJECT_HDL hTimer, void *pvArg );
static void OSALT_vActiveTimerList ( void );
static BOOLEAN OSALT_bPrintActiveTimer ( void *pvData, void *pvArg );
static BOOLEAN OSALT_bPrintTimer ( void *pvData, void *pvArg );

#if OSAL_OBJECT_TRACKING == 1

static BOOLEAN OSALT_bPrintTimerObject ( void *pvData, void *pvArg );

#endif /* OSAL_OBJECT_TRACKING == 1 */
#endif /* OSAL_DEBUG == 1 */

/**********************/
/** INLINE FUNCTIONS **/
/**********************/

#endif	// _OSAL_TIMER_H_
