/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/

/*********************************/
/** PREVENT REDUNDANT INCLUSION **/
/*********************************/
#ifndef _OSAL_TIME_H_
#define _OSAL_TIME_H_

/**************/
/** INCLUDES **/
/**************/
#include <stdlib.h>

#include "standard.h"
#include "osal.h"
#include "osal_time.h"

/***************/
/** CONSTANTS **/
/***************/

#define YEAR0                   1900
#define EPOCH_YR                1970
#define SECS_DAY                (24L * 60L * 60L)
#define LEAPYEAR(year)          (!((year) % 4) && (((year) % 100) || !((year) % 400)))
#define YEARSIZE(year)          (LEAPYEAR(year) ? 366 : 365)

#define TIME_MAX                0xFFFFFFFFFFFFFFFFULL

/**************/
/** TYPEDEFS **/
/**************/

typedef struct osalt_update_handler_entry_struct
{
    // Update handler
    OSAL_TIME_UPDATE_HANDLER vHandler;

    // Update handler argument
    void *pvHandlerArg;

    // Update handler mask
    OSAL_TIME_UPDATE_MASK tUpdateMask;

    // Linked list entry (this)
    OSAL_LINKED_LIST_ENTRY hThisEntry;

} OSALT_UPDATE_HANDLER_ENTRY_STRUCT;

typedef struct osalt_callback_shim_struct
{
    // Update handler mask
    OSAL_TIME_UPDATE_MASK tUpdateMask;

} OSALT_CALLBACK_SHIM_STRUCT;

typedef struct osalt_time_bias_struct
{
    // Up time bias. Avoids us from modifying system time
    UN32 un32UpTimeSeconds;

    // Offset for Daylight Saving Time (seconds)
    // Maximum is 60 minutes or 60*60 seconds
    UN32 un32DST_Seconds;

    // Difference in seconds between GMT and local time
    // Maximum is +/- 12 hours, 12*60 minutes, 12*60*60 seconds
    // which is +/- 43,200 seconds
    N32 n32GMT_Seconds;

} OSALT_TIME_BIAS_STRUCT;

typedef struct osalt_current_struct
{
    // Time current settings mutex
    OSAL_OBJECT_HDL hMutex;

    // Flag to indicate if time has ever been set.
    BOOLEAN bTimeValid;

    // Time bias
    OSALT_TIME_BIAS_STRUCT sBias;

} OSALT_TIME_CURRENT_STRUCT;

typedef struct osalt_time_control_struct
{
    // Current time settings structure
    OSALT_TIME_CURRENT_STRUCT sCurrent;

    // Update handler list mutex
    OSAL_OBJECT_HDL hListMutex;

    // Update handler linked list
    OSAL_OBJECT_HDL hList;

} OSALT_TIME_CONTROL_STRUCT;

/***************/
/** VARIABLES **/
/***************/

static const int gytab[2][12] =
{
    {31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31},
    {31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31}
};

static OSALT_TIME_CONTROL_STRUCT gsTimeControl =
{
    {
        OSAL_INVALID_OBJECT_HDL,
        FALSE,
        {
            0,
            0,
            0
        }
    },
    OSAL_INVALID_OBJECT_HDL,
    OSAL_INVALID_OBJECT_HDL
};

/************/
/** MACROS **/
/************/

/****************/
/** PROTOTYPES **/
/****************/

static BOOLEAN bGetTimeBias( OSALT_TIME_BIAS_STRUCT *psBias );

static void vSetTimeBias( OSALT_TIME_BIAS_STRUCT const *psBias );

static BOOLEAN bSetTimeCallbackShim (
    void *pvData, void *pvArg
        );

/**********************/
/** INLINE FUNCTIONS **/
/**********************/

#endif	// _OSAL_TIME_H_
