/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
*
*
*
*
*
*	LOCAL HEADER
*******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/
#ifndef _OSAL_MEM_H_
#define _OSAL_MEM_H_

  /**************/
 /** INCLUDES **/
/**************/
#include <stdlib.h>
#include "standard.h"

#include "osal_mem.h"
#include "osal.h"

  /***************/
 /** CONSTANTS **/
/***************/

  /**************/
 /** TYPEDEFS **/
/**************/

typedef struct osalm_statistics_struct
{
    UN32 un32CurrentAllocatedBlocks;
    UN32 un32CurrentActualAllocatedBlocks;
    UN32 un32CurrentUserBytes;
    UN32 un32CurrentActualBytes;
    UN32 un32MaxAllocatedBlocks;
    UN32 un32MaxActualAllocatedBlocks;
    UN32 un32MaxUserBytes;
    UN32 un32MaxActualBytes;
    UN32 un32TotalSystemBytes;

 } OSALM_STATISTICS_STRUCT;

 typedef struct osalm_iterator_data_struct
 {
    OSALM_STATISTICS_STRUCT *psStatistics;
    const char *pcFilter;

 } OSALM_ITERATOR_DATA_STRUCT;

  /***************/
 /** VARIABLES **/
/***************/

  /************/
 /** MACROS **/
/************/

  /****************/
 /** PROTOTYPES **/
/****************/

#if (OSAL_DEBUG == 1) && (OSAL_OBJECT_TRACKING == 1)

static BOOLEAN bPrintMemoryBlock ( void *pvData, void *pvArg );

#endif /* (OSAL_DEBUG == 1) && (OSAL_OBJECT_TRACKING == 1) */

  /**********************/
 /** INLINE FUNCTIONS **/
/**********************/

#endif	// _OSAL_MEM_H_
