/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
*
*
*
*
*
*	LOCAL HEADER
*******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/
#ifndef _OSAL_LOG_H_
#define _OSAL_LOG_H_

  /**************/
 /** INCLUDES **/
/**************/
#include "standard.h"

#include "osal_log.h"
#include "osal_core.h"

  /***************/
 /** CONSTANTS **/
/***************/

  /**************/
 /** TYPEDEFS **/
/**************/

typedef struct osall_print_struct
{
    BOOLEAN bVerbose;
    UN32 un32LogNumber;

} OSALL_PRINT_STRUCT;

typedef struct osall_iterator_struct
{
    // Global log statistics
    OSAL_STATISTICS_STRUCT sStatistics;

    // Log specific info
    UN32 un32LogNumber;
    OSAL_LOG_INFO_STRUCT sLog;

    // Caller's arg
    OSAL_LOG_ITERATOR_HANDLER pbIterator;
    void *pvIteratorArg;

} OSALL_ITERATOR_STRUCT;

  /***************/
 /** VARIABLES **/
/***************/

  /************/
 /** MACROS **/
/************/

  /****************/
 /** PROTOTYPES **/
/****************/

#if (OSAL_LOG == 1) && (OSAL_DEBUG == 1) && (OSAL_OBJECT_TRACKING == 1)
static BOOLEAN OSALL_bPrintLog ( void *pvData, void *pvArg );
static BOOLEAN OSALL_bIterateLog ( void *pvData, void *pvArg );
#endif /* (OSAL_LOG == 1) && (OSAL_DEBUG == 1) && (OSAL_OBJECT_TRACKING == 1) */

  /**********************/
 /** INLINE FUNCTIONS **/
/**********************/

#endif	// _OSAL_LOG_H_
