/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * PRIVATE HEADER
 *
 ******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/
#ifndef _FIXED_OBJ_H_
#define _FIXED_OBJ_H_

  /**************/
 /** INCLUDES **/
/**************/

#include <stdio.h>

#include "standard.h"
#include "osal.h"

#include "osal_fixed.h"


  /***************/
 /** CONSTANTS **/
/***************/

#ifndef DEBUG_OBJECT
#define DEBUG_OBJECT 0
#endif

#ifndef DEBUG_MATH
#define DEBUG_MATH 0    // Compares FIXED API values to standard
                        // standard math library calls and logs errors
#endif

#if DEBUG_MATH == 1
// Define used to log an error.  If the absolute difference between the FIXED API result
// and the standard math library is greater than this, then log the error
#define DEBUG_MATH_ERROR_THRESHOLD  0.00001f
#endif

// If debugging is not enabled, just #define out the functions...

#if DEBUG_OBJECT == 0
// TODO: fix this with Bug #4809
#ifdef printf
#undef printf
#endif

static int i32NullPrintf( const char *pcNothing, ... ) { return 0 ; }
#define printf i32NullPrintf
#endif

#define FIXED_OBJECT_NAME "OSAL_FIXED_OBJECT"

// CORDIC constants
// Generated using CORDIC function found at
// http://www.dcs.gla.ac.uk/~jhw/cordic/
#define CORDIC_1K 0x26DD3B6A
#define NUM_CORDIC_TABLE_ENTRIES 32

// Always leave a bit for a signed value
#define TOTAL_NUM_BITS (30)

// Number of bits to shift prior to division
#define DIV_SHIFT_NUM_BITS (32)

// Bit format for the various trig functions
// This is needed to match the format of the values
// in our CORDIC table.
#define FRACTIONAL_BITS_FOR_TRIG (30)
#define MAX_FRACTIONAL_BITS_FOR_SQRT (30)

#define FIXED_ATAN_VALID_LOW    ((N32)(-0.68f * (1 << FRACTIONAL_BITS_FOR_TRIG)))
#define FIXED_ATAN_VALID_HIGH   ((N32)(0.68f * (1 << FRACTIONAL_BITS_FOR_TRIG)))

// Epsilon value (precision) used in ATAN2 approximation
//#define FIXED_ATAN2_EPSILON_VALUE        ((N32)(0.0001f * (1 << FRACTIONAL_BITS_FOR_TRIG)))
#define FIXED_ATAN2_LINEAR_START         (N32)(0.8f * (1 << FRACTIONAL_BITS_FOR_TRIG))
#define FIXED_ATAN2_LINEAR_MULTIPLIER    (2000)
#define FIXED_ATAN2_LINEAR_NUM_ELEMENTS  (400)


// Pi in a 3b29 unsigned format
// Used by numerous functions.  Kept in 3b29 format
// for max precision
#define PI_FRACTIONAL_BITS (29)
#define FX3B29_PI ((N32)(3.141592653589793f * (1 << PI_FRACTIONAL_BITS)))
#define FX3B29_NEG_PI ((N32)(-3.141592653589793f * (1 << PI_FRACTIONAL_BITS)))
#define FX3B29_PI_OVER_2 ((N32)((3.141592653589793f/2) * (1 << PI_FRACTIONAL_BITS)))
#define FX3B29_NEG_PI_OVER_2 ((N32)((-3.141592653589793f/2) * (1 << PI_FRACTIONAL_BITS)))
#define FX3B29_PI_OVER_180 ((N32)((3.141592653589793f/180) * (1 << (PI_FRACTIONAL_BITS + 1))))

// Commands in expression
#define FIXED_EVAL_OPERAND_FIXED_CMD '%'
#define FIXED_EVAL_OPERAND_N32_CMD 'd'
#define FIXED_EVAL_OPERAND_TOREG_CMD '<'
#define FIXED_EVAL_ADD_CMD '+'
#define FIXED_EVAL_SUB_CMD '-'
#define FIXED_EVAL_MUL_CMD '*'
#define FIXED_EVAL_DIV_CMD '/'
#define FIXED_EVAL_SIN_CMD 's'
#define FIXED_EVAL_POW_CMD '^'
#define FIXED_EVAL_COS_CMD 'c'
#define FIXED_EVAL_ABS_CMD 'a'
#define FIXED_EVAL_ATAN_CMD 't'
#define FIXED_EVAL_ATAN2_CMD 'u'
#define FIXED_EVAL_ASIN_CMD 'e'
#define FIXED_EVAL_ACOS_CMD 'f'
#define FIXED_EVAL_SQRT_CMD 'q'
#define FIXED_EVAL_DEG2RAD_CMD 'r'
#define FIXED_EVAL_RAD2DEG_CMD 'R'
#define FIXED_EVAL_REG_FIRST '0'
#define FIXED_EVAL_REG_LAST '9'

// Defines max number of "registers"
#define FIXED_EVAL_REGISTERS_COUNT (FIXED_EVAL_REG_LAST - FIXED_EVAL_REG_FIRST + 1)


  /**************/
 /** TYPEDEFS **/
/**************/

// Main object info struct
typedef struct fixed_obj_struct
{
    N32        n32Value;
    UN8        un8NumFractionalBits;
} FIXED_OBJECT_STRUCT;

// Verify that the size matches.
//Would throw a compiler error if it doesn't
COMPILE_TIME_ASSERT(
    (sizeof(FIXED_OBJECT_STRUCT)/sizeof(OSAL_FIXED_OBJECT_DATA))
        == OSAL_FIXED_OBJECT_SIZE,
    OSAL_FIXED_OBJECT_SIZE_IsWrong);


// An enumeration that specifies what part of the
// cordic result to return
typedef enum fixed_obj_cordic_eval_type_enum
{
    FIXED_OBJ_CORDIC_EVAL_TYPE_SIN = 0,
    FIXED_OBJ_CORDIC_EVAL_TYPE_COS
} FIXED_OBJ_CORDIC_EVAL_TYPE_ENUM;

// Typedef for math functions
typedef OSAL_RETURN_CODE_ENUM (*OSAL_FIXED_MATH_UNARY_FUNC) (
    OSAL_FIXED_OBJECT hFixed,
    OSAL_FIXED_OBJECT hResult
        );

typedef OSAL_RETURN_CODE_ENUM (*OSAL_FIXED_MATH_BINARY_FUNC) (
    OSAL_FIXED_OBJECT hFixed1,
    OSAL_FIXED_OBJECT hFixed2,
    OSAL_FIXED_OBJECT hResult
        );

  /************/
 /** MACROS **/
/************/

// A macro to get to a "one" in the specified bin point format
#define BIN_POINT_VALUE(binPoint)   ((UN32)1 << ((UN8)binPoint))

  /****************/
 /** PROTOTYPES **/
/****************/

/*  Private Prototypes */
static N64 n64FixedMultiply (
    N32 n32Value1,
    UN8 un8NumFractionalBits1,
    N32 n32Value2,
    UN8 un8NumFractionalBits2,
    UN8 *pun8NumResultFractionalBits
        );

static N64 n64FixedDivide (
    N32 n32Numerator,
    UN8 un8NumFractionalNumeratorBits,
    N32 n32Denominator,
    UN8 un8NumFractionalDenominatorBits,
    UN8 *pun8NumResultFractionalBits
        );

static UN32 un32FixedSqrt (
    UN32 n32Value,
    UN8 un8NumFractionalBits
        );

static OSAL_RETURN_CODE_ENUM eAtanImpl_fixed (
    OSAL_FIXED_OBJECT hFixedX,
    OSAL_FIXED_OBJECT hResult
        );

static OSAL_RETURN_CODE_ENUM eATan2 (
    OSAL_FIXED_OBJECT hFixedY,
    OSAL_FIXED_OBJECT hFixedX,
    OSAL_FIXED_OBJECT hResult
        );

static BOOLEAN bIsValidCORDICATan(
    OSAL_FIXED_OBJECT hFixed
        );

static N32 n32FixedATan (
    N32 n32Value
        );

static N32 n32CordicEval (
    N32 n32Radian,
    FIXED_OBJ_CORDIC_EVAL_TYPE_ENUM eCordicEvalType
        );

static OSAL_RETURN_CODE_ENUM eAdjustResult (
    FIXED_OBJECT_STRUCT *psObj,
    N64 n64Result,
    UN8 un8ResultBits
        );

static UN8 un8NumWholeBitsNeeded (
    N32 n32WholeValue
        );

static N32 n32ScaleFixed(
    FIXED_OBJECT_STRUCT *psObj,
    UN8 un8ScaleBits
        );

static N64 n64ScaleFixed(
    FIXED_OBJECT_STRUCT *psObj,
    UN8 un8ScaleBits
        );

static OSAL_RETURN_CODE_ENUM ePowForEval (
    OSAL_FIXED_OBJECT hFixed,
    OSAL_FIXED_OBJECT hPower,
    OSAL_FIXED_OBJECT hResult
        );

#if (DEBUG_MATH == 1)

static void vValidateResult(
    float fValue,
    FIXED_OBJECT_STRUCT *psObjResult,
    const char *pcFunctionName);

#endif

  /***************/
 /** VARIABLES **/
/***************/

static const FIXED_OBJECT_STRUCT gsPi =
{
    FX3B29_PI,
    PI_FRACTIONAL_BITS
};

static const FIXED_OBJECT_STRUCT gsNegPi =
{
    FX3B29_NEG_PI,
    PI_FRACTIONAL_BITS
};

static const FIXED_OBJECT_STRUCT gsPiOverTwo =
{
    FX3B29_PI_OVER_2,
    PI_FRACTIONAL_BITS
};

static const FIXED_OBJECT_STRUCT gsNegPiOverTwo =
{
    FX3B29_NEG_PI_OVER_2,
    PI_FRACTIONAL_BITS
};

static const FIXED_OBJECT_STRUCT gsZero =
{
    0,
    0
};

static const FIXED_OBJECT_STRUCT gsOne =
{
    1,
    0
};

static const FIXED_OBJECT_STRUCT gsNegOne =
{
    -1,
    0
};

static const FIXED_OBJECT_STRUCT gs9 =
{
    9,
    0
};

static const FIXED_OBJECT_STRUCT gs55 =
{
    55,
    0
};

static const FIXED_OBJECT_STRUCT gs90 =
{
    90,
    0
};

static const FIXED_OBJECT_STRUCT gs105 =
{
    105,
    0
};

// Generated using CORDIC function found at
// http://www.dcs.gla.ac.uk/~jhw/cordic/
// S:\EmbeddedSoftware\SMS\CORDIC Resources
static const N32 gan32CoridcTable [NUM_CORDIC_TABLE_ENTRIES] =
{
    0x3243F6A8, 0x1DAC6705, 0x0FADBAFC, 0x07F56EA6,
    0x03FEAB76, 0x01FFD55B, 0x00FFFAAA, 0x007FFF55,
    0x003FFFEA, 0x001FFFFD, 0x000FFFFF, 0x0007FFFF,
    0x0003FFFF, 0x0001FFFF, 0x0000FFFF, 0x00007FFF,
    0x00003FFF, 0x00001FFF, 0x00000FFF, 0x000007FF,
    0x000003FF, 0x000001FF, 0x000000FF, 0x0000007F,
    0x0000003F, 0x0000001F, 0x0000000F, 0x00000008,
    0x00000004, 0x00000002, 0x00000001, 0x00000000,
};

static const FIXED_OBJECT_STRUCT gsAtanLinearStart =
{
    FIXED_ATAN2_LINEAR_START,
    FRACTIONAL_BITS_FOR_TRIG
};

static const FIXED_OBJECT_STRUCT gsAtanLinearMultiplier =
{
    FIXED_ATAN2_LINEAR_MULTIPLIER,
    0
};

// Table of arctangent values from FIXED_ATAN2_LINEAR_START to 1
// prepared for FIXED conversion with FRACTIONAL_BITS_FOR_TRIG
// fractional bits
static const N32 gan32AtanTable [FIXED_ATAN2_LINEAR_NUM_ELEMENTS + 1] =
{
    724497570,
    724824850,
    725151971,
    725478932,
    725805734,
    726132376,
    726458859,
    726785183,
    727111347,
    727437352,
    727763198,
    728088884,
    728414412,
    728739781,
    729064990,
    729390041,
    729714933,
    730039666,
    730364240,
    730688656,
    731012913,
    731337012,
    731660952,
    731984734,
    732308357,
    732631822,
    732955128,
    733278277,
    733601267,
    733924099,
    734246773,
    734569290,
    734891648,
    735213848,
    735535891,
    735857776,
    736179503,
    736501072,
    736822484,
    737143739,
    737464836,
    737785775,
    738106557,
    738427182,
    738747650,
    739067960,
    739388114,
    739708110,
    740027950,
    740347632,
    740667158,
    740986527,
    741305739,
    741624794,
    741943693,
    742262435,
    742581020,
    742899449,
    743217722,
    743535839,
    743853799,
    744171603,
    744489250,
    744806742,
    745124078,
    745441257,
    745758281,
    746075149,
    746391861,
    746708417,
    747024818,
    747341063,
    747657152,
    747973086,
    748288864,
    748604487,
    748919955,
    749235268,
    749550425,
    749865427,
    750180274,
    750494966,
    750809503,
    751123885,
    751438113,
    751752185,
    752066103,
    752379866,
    752693475,
    753006929,
    753320228,
    753633373,
    753946364,
    754259201,
    754571883,
    754884411,
    755196785,
    755509005,
    755821071,
    756132983,
    756444741,
    756756345,
    757067796,
    757379093,
    757690236,
    758001226,
    758312062,
    758622745,
    758933274,
    759243650,
    759553873,
    759863943,
    760173859,
    760483623,
    760793233,
    761102691,
    761411996,
    761721147,
    762030146,
    762338993,
    762647687,
    762956228,
    763264616,
    763572853,
    763880937,
    764188868,
    764496647,
    764804274,
    765111749,
    765419072,
    765726243,
    766033262,
    766340129,
    766646844,
    766953407,
    767259819,
    767566079,
    767872188,
    768178145,
    768483950,
    768789605,
    769095108,
    769400459,
    769705660,
    770010709,
    770315607,
    770620354,
    770924951,
    771229396,
    771533691,
    771837834,
    772141828,
    772445670,
    772749362,
    773052904,
    773356295,
    773659535,
    773962626,
    774265566,
    774568356,
    774870995,
    775173485,
    775475825,
    775778015,
    776080055,
    776381945,
    776683685,
    776985276,
    777286717,
    777588009,
    777889151,
    778190144,
    778490987,
    778791681,
    779092226,
    779392621,
    779692868,
    779992966,
    780292914,
    780592714,
    780892365,
    781191867,
    781491220,
    781790425,
    782089481,
    782388388,
    782687148,
    782985758,
    783284221,
    783582535,
    783880701,
    784178719,
    784476588,
    784774310,
    785071884,
    785369310,
    785666588,
    785963718,
    786260701,
    786557536,
    786854224,
    787150764,
    787447156,
    787743401,
    788039499,
    788335450,
    788631254,
    788926910,
    789222420,
    789517782,
    789812998,
    790108066,
    790402988,
    790697764,
    790992392,
    791286874,
    791581210,
    791875399,
    792169441,
    792463338,
    792757088,
    793050692,
    793344149,
    793637461,
    793930627,
    794223647,
    794516521,
    794809249,
    795101831,
    795394268,
    795686559,
    795978705,
    796270705,
    796562560,
    796854269,
    797145833,
    797437252,
    797728526,
    798019655,
    798310638,
    798601477,
    798892171,
    799182720,
    799473124,
    799763384,
    800053499,
    800343470,
    800633296,
    800922977,
    801212514,
    801501907,
    801791156,
    802080261,
    802369221,
    802658037,
    802946710,
    803235238,
    803523623,
    803811864,
    804099961,
    804387915,
    804675725,
    804963392,
    805250915,
    805538295,
    805825531,
    806112625,
    806399575,
    806686382,
    806973046,
    807259567,
    807545945,
    807832180,
    808118273,
    808404223,
    808690030,
    808975694,
    809261216,
    809546596,
    809831833,
    810116928,
    810401881,
    810686692,
    810971360,
    811255886,
    811540271,
    811824513,
    812108614,
    812392573,
    812676390,
    812960066,
    813243600,
    813526992,
    813810243,
    814093353,
    814376321,
    814659148,
    814941834,
    815224379,
    815506783,
    815789046,
    816071168,
    816353149,
    816634989,
    816916688,
    817198247,
    817479666,
    817760944,
    818042081,
    818323078,
    818603935,
    818884651,
    819165227,
    819445663,
    819725960,
    820006116,
    820286132,
    820566008,
    820845745,
    821125342,
    821404799,
    821684117,
    821963295,
    822242334,
    822521233,
    822799993,
    823078614,
    823357095,
    823635438,
    823913641,
    824191706,
    824469631,
    824747418,
    825025066,
    825302575,
    825579946,
    825857178,
    826134271,
    826411226,
    826688043,
    826964722,
    827241262,
    827517664,
    827793928,
    828070053,
    828346041,
    828621891,
    828897603,
    829173178,
    829448614,
    829723913,
    829999075,
    830274099,
    830548985,
    830823734,
    831098346,
    831372821,
    831647158,
    831921358,
    832195422,
    832469348,
    832743137,
    833016790,
    833290306,
    833563685,
    833836927,
    834110033,
    834383003,
    834655835,
    834928532,
    835201092,
    835473516,
    835745804,
    836017956,
    836289972,
    836561852,
    836833596,
    837105204,
    837376676,
    837648013,
    837919214,
    838190279,
    838461209,
    838732004,
    839002663,
    839273187,
    839543576,
    839813829,
    840083948,
    840353931,
    840623779,
    840893493,
    841163072,
    841432516,
    841701825,
    841971000,
    842240040,
    842508945,
    842777717,
    843046353,
    843314856
};

  /**********************/
 /** INLINE FUNCTIONS **/
/**********************/

#endif    // _FIXED_OBJ_H_
