/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
*
*
*
*
*
*    LOCAL HEADER
*******************************************************************************/
#if OSAL_DEBUG == 1

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/
#ifndef _OSAL_DEBUG_H_
#define _OSAL_DEBUG_H_

  /**************/
 /** INCLUDES **/
/**************/
#include <stdlib.h>
#include "standard.h"

#include "osal_debug.h"

  /***************/
 /** CONSTANTS **/
/***************/


#define OSALD_MAXIMUM_PATH_LEN (256)

#define LOAD_TASK_PREFIX "DEBUG CPU LOAD TASK"
#define LOAD_TASK_IDX_DIGITS (2)
#define MAX_CPU_LOAD_PERIOD_MS (1000)
#define MAX_CPU_LOAD_TASKS (99)
#define MAX_CPU_LOAD_TASK_NAME_SIZE (sizeof(LOAD_TASK_PREFIX) + LOAD_TASK_IDX_DIGITS + 1)
#define SEC_TO_MSEC (1000)
#define PCT_TO_DC (1.0f / 100.0f)

  /**************/
 /** TYPEDEFS **/
/**************/

//
// Each cpu load task needs access to information about
// our duty cycle and period. The debug handlers also need
// to know how many tasks to create & stop. We make life
// a little easier by creating a struct to hold the info...
//

typedef struct cpu_load_info {
    UN8     un8NumTasks;
    UN8     un8LoadPct;
    UN8     un8Priority;
    UN16    un16PeriodMs;
    BOOLEAN bConsumeCPU;
} CPU_LOAD_INFO_STRUCT;

  /***************/
 /** VARIABLES **/
/***************/

static CPU_LOAD_INFO_STRUCT gsCpuLoadInfo =
{
   /* .un8NumTasks = */     0,
   /* .un8LoadPct = */      0,
   /* .un8Priority = */     0,
   /* .un16PeriodMs = */    0,
   /* .bConsumeCPU = */     FALSE
};

  /************/
 /** MACROS **/
/************/

  /****************/
 /** PROTOTYPES **/
/****************/

static OSAL_DEBUG_STATE_ENUM OSALD_eDebugMainMenuHandler (
        char *pcCmdLine, const void *pvArg );

static void OSALD_vLoadCpu( void );
static void OSALD_vUnLoadCpu( void );
static N32 OSALD_n32CpuLoadTask( void *pvArg );

#if OSAL_TEST == 1
static OSAL_DEBUG_STATE_ENUM OSALD_eDebugTestMenuHandler(
       char *pcCmdLine, const void *pvArg );
static N32 OSALD_n32Task( void *pvArg );
static void OSALD_vSleepHandler( void *pvArg );
static void OSALD_vWakeupHandler( void *pvArg );
static void OSALD_vShutdownHandler( void *pvArg );
static void OSALD_vDebugTaskHandler( char *pcCmdLine, const void *pvArg );
static void OSALD_vToggleLed ( OSAL_OBJECT_HDL hTimer, void *pvArg );
#endif /* OSAL_TEST == 1 */

#if OSAL_FILE_SYSTEM == 1
static OSAL_DEBUG_STATE_ENUM OSALD_eDebugFSMenuHandler (
        char *pcCmdLine, char *pcWorkingDir );
static void OSALD_GeneratePath(
        char *pcWorkingDir, const char *pcTarget, char *pcDestBuffer );
#endif // OSAL_FILE_SYSTEM == 1

#if OSAL_FIXED_MATH == 1
static OSAL_DEBUG_STATE_ENUM OSALD_eDebugFixedMenuHandler (
        char *pcCmdLine, const void *pvArg );
#endif /* OSAL_FIXED_MATH == 1 */

  /**********************/
 /** INLINE FUNCTIONS **/
/**********************/

#endif  // _OSAL_DEBUG_H_
#endif  // OSAL_DEBUG == 1
