/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
*
*
*
*
*
*	LOCAL HEADER
*******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/
#ifndef _OSAL_CORE_H_
#define _OSAL_CORE_H_

  /**************/
 /** INCLUDES **/
/**************/
#include <stdlib.h>
#include "standard.h"
#include "osal_core.h"

  /***************/
 /** CONSTANTS **/
/***************/

#if OSAL_OBJECT_TRACKING == 1
#define OSALC_DEBUG_MANAGE TRUE // Manage only when DEBUG is ON
#else
#define OSALC_DEBUG_MANAGE FALSE // Don't manage when DEBUG is OFF
#endif

  /**************/
 /** TYPEDEFS **/
/**************/

typedef struct osalc_priority_map_struct
{
    OSAL_TASK_PRIORITY_ENUM ePriority;
    const char *pacText;

} OSALC_PRIORITY_MAP_STRUCT;

typedef struct osalc_objects_struct
{
    OSAL_OBJECT_TYPE_ENUM eType;
    size_t tSize;
    BOOLEAN bManage;
    BOOLEAN bCanShare;
    BOOLEAN bZeroInitialize;
    OSAL_LL_COMPARE_HANDLER n16Compare;
    UN32 un32Options;

} OSALC_OBJECTS_STRUCT;

  /***************/
 /** VARIABLES **/
/***************/

#if OSAL_OBJECT_TRACKING == 1
static N16 OSALC_n16CompareObjectNames( void *pvObj1, void *pvObj2);
static N16 OSALC_n16CompareObjectToName( void *pvObj1, void *pvName);
#else
#define OSALC_n16CompareObjectNames (NULL)
#endif

// Array of Object Information Sizes. Note the order these object types
// are in this array MUST be the same as the order in the enum definition
const OSALC_OBJECTS_STRUCT gasObjects[OSAL_OBJECT_TYPE_SIZE] = {

    {OSAL_OBJECT_TYPE_TASK, sizeof(OSAL_TASK_INFO_STRUCT),
        TRUE, FALSE, FALSE, OSALC_n16CompareObjectNames,
        OSAL_LL_OPTION_USE_PRE_ALLOCATED_ELEMENTS | OSAL_LL_OPTION_UNIQUE},
    {OSAL_OBJECT_TYPE_QUEUE, sizeof(OSAL_QUEUE_PRIVATE_INFO_STRUCT),
        OSALC_DEBUG_MANAGE, FALSE, FALSE, OSALC_n16CompareObjectNames,
        OSAL_LL_OPTION_USE_PRE_ALLOCATED_ELEMENTS | OSAL_LL_OPTION_UNIQUE},
    {OSAL_OBJECT_TYPE_SEM, sizeof(OSAL_SEM_INFO_STRUCT),
        OSALC_DEBUG_MANAGE, FALSE, FALSE, OSALC_n16CompareObjectNames,
        OSAL_LL_OPTION_USE_PRE_ALLOCATED_ELEMENTS | OSAL_LL_OPTION_UNIQUE},
    {OSAL_OBJECT_TYPE_TIMER, sizeof(OSAL_TIMER_INFO_STRUCT),
        OSALC_DEBUG_MANAGE, FALSE, FALSE, OSALC_n16CompareObjectNames,
        OSAL_LL_OPTION_USE_PRE_ALLOCATED_ELEMENTS | OSAL_LL_OPTION_UNIQUE},
    {OSAL_OBJECT_TYPE_MEMORY, sizeof(OSAL_MEMORY_INFO_STRUCT),
        OSALC_DEBUG_MANAGE, FALSE, FALSE, NULL,
        OSAL_LL_OPTION_USE_PRE_ALLOCATED_ELEMENTS},
    {OSAL_OBJECT_TYPE_LINKED_LIST, sizeof(OSAL_LL_INFO_STRUCT),
        FALSE, FALSE, FALSE, OSALC_n16CompareObjectNames,
        OSAL_LL_OPTION_USE_PRE_ALLOCATED_ELEMENTS | OSAL_LL_OPTION_UNIQUE},

#if OSAL_INTERRUPT == 1
    {OSAL_OBJECT_TYPE_INTERRUPT, sizeof(OSAL_INTERRUPT_INFO_STRUCT),
        TRUE, FALSE, FALSE, OSALC_n16CompareObjectNames,
        OSAL_LL_OPTION_USE_PRE_ALLOCATED_ELEMENTS | OSAL_LL_OPTION_UNIQUE},
#endif /* OSAL_INTERRUPT == 1 */

#if OSAL_LOG == 1
    {OSAL_OBJECT_TYPE_LOG, sizeof(OSAL_LOG_INFO_STRUCT),
        TRUE, FALSE, FALSE, OSALC_n16CompareObjectNames,
        OSAL_LL_OPTION_USE_PRE_ALLOCATED_ELEMENTS | OSAL_LL_OPTION_UNIQUE},
#endif /* OSAL_LOG == 1 */

#if OSAL_BUFFER == 1
    {OSAL_OBJECT_TYPE_BLOCK_POOL, sizeof(OSAL_BLOCK_POOL_PRIVATE_INFO_STRUCT),
        TRUE, FALSE, FALSE, OSALC_n16CompareObjectNames,
        OSAL_LL_OPTION_USE_PRE_ALLOCATED_ELEMENTS | OSAL_LL_OPTION_UNIQUE},
#endif /* OSAL_BUFFER == 1 */

#if OSAL_CRC == 1
    {OSAL_OBJECT_TYPE_CRC, sizeof(OSAL_CRC_INFO_STRUCT),
        TRUE, TRUE, TRUE, OSAL_n16CompareCRC,
        OSAL_LL_OPTION_USE_PRE_ALLOCATED_ELEMENTS | OSAL_LL_OPTION_UNIQUE},
#endif /* OSAL_CRC == 1 */

};

static const OSALC_PRIORITY_MAP_STRUCT gsPriorityMap[] =
{
    { OSAL_TASK_PRIORITY_LOWEST, MACRO_TO_STRING(OSAL_TASK_PRIORITY_LOWEST) },
    { OSAL_TASK_PRIORITY_LOW, MACRO_TO_STRING(OSAL_TASK_PRIORITY_LOW) },
    { OSAL_TASK_PRIORITY_MEDIUM, MACRO_TO_STRING(OSAL_TASK_PRIORITY_MEDIUM) },
    { OSAL_TASK_PRIORITY_HIGH, MACRO_TO_STRING(OSAL_TASK_PRIORITY_HIGH) },
    { OSAL_TASK_PRIORITY_HIGHEST, MACRO_TO_STRING(OSAL_TASK_PRIORITY_HIGHEST) },
    { OSAL_TASK_PRIORITY_INVALID, MACRO_TO_STRING(OSAL_TASK_PRIORITY_INVALID) }
};

static BOOLEAN OSALC_bRegisterDrivers(void *pvArg);
static void OSALC_vUnregisterDrivers(void *pvArg);
static BOOLEAN OSALC_bStartHandler(const void *pvArg);
static void OSALC_vMonitorErrorHandler(
    OSAL_RETURN_CODE_ENUM eErrorCode,
    const OSAL_TASK_INFO_STRUCT *psTaskInfo,
    void *pvArg
        );
static void OSALC_vHeartBeatHandler(void *pvArg);
static void OSALC_vWatchdogStartHandler(void *pvArg);
static void OSALC_vWatchdogStopHandler(void *pvArg);
static void OSALC_vWatchdogKickHandler(void *pvArg);

static const OSAL_START_HANDLER_STRUCT gsDefaultStartHandlers =
{
    // OSAL Device Driver Registration
    /*.bRegisterDrivers = */OSALC_bRegisterDrivers,
    /*.vUnregisterDrivers = */OSALC_vUnregisterDrivers,
    /*.pvRegisterDriversHandlerArg = */NULL,

    // OSAL Bootstrap(Start)
    /*.bStartHandler = */OSALC_bStartHandler,
    /*.pvStartHandlerArg = */NULL,

    {
        // OSAL Monitoring
        /*.vMonitorErrorHandler = */OSALC_vMonitorErrorHandler,
        /*.pvMonitorErrorHandlerArg = */NULL,

        // OSAL Heart Beat
        /*.vHeartBeatHandler = */OSALC_vHeartBeatHandler,
        /*.pvHeartBeatHandlerArg = */NULL,

        // OSAL Watchdog
        /*.vWatchdogStartHandler = */OSALC_vWatchdogStartHandler,
        /*.vWatchdogStopHandler = */OSALC_vWatchdogStopHandler,
        /*.vWatchdogKickHandler = */OSALC_vWatchdogKickHandler,
        /*.pvWatchdogHandlerArg = */NULL
    }

};

static OSALC_STRUCT gsCore;

  /************/
 /** MACROS **/
/************/

  /****************/
 /** PROTOTYPES **/
/****************/

static void OSALC_vDestroyObject( OSAL_OBJECT_HDL hObj );

static UN32 OSALC_un32ComputeMagicNumber(const OSAL_OBJECT_STRUCT *psObj);

static void OSALC_vQualifyStartHandlers(
    const OSAL_START_HANDLER_STRUCT *psStartHandlers );

  /**********************/
 /** INLINE FUNCTIONS **/
/**********************/

#endif	// _OSAL_CORE_H_
