/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/
#ifndef _OSAL_H_
#define _OSAL_H_

  /**************/
 /** INCLUDES **/
/**************/
#include <stdlib.h>
#include <stdio.h>

#include "standard.h"

#include "osal_general.h"
#include "osal_task.h"
#include "osal_queue.h"
#include "osal_sem.h"
#include "osal_time.h"
#include "osal_timer.h"
#include "osal_mem.h"
#include "osal_ll.h"
#include "osal_debughandler.h"
#include "osal_stdio.h"
#include "osal_core.h"
#include "osal_monitor.h"

// leaving this here because interrupt is not part of the api struct
#if OSAL_INTERRUPT == 1
#include "osal_int.h"
#endif /* OSAL_INTERRUPT == 1 */


#include "osal_log.h"
#include "osal_buf.h"
#include "osal_crc.h"
#include "osal_devices.h"
#include "osal_fs.h"
#include "osal_fixed.h"


#include "osal.h"

  /***************/
 /** CONSTANTS **/
/***************/

  /**************/
 /** TYPEDEFS **/
/**************/

  /***************/
 /** VARIABLES **/
/***************/

  /************/
 /** MACROS **/
/************/

  /****************/
 /** PROTOTYPES **/
/****************/

/*
    OSAL API Object Definition
*/

const OSAL_API_STRUCT OSAL =
{
    /*
        General APIs
    */
    /*.tConfigInfo = */ OSAL_tConfigInfo,
    /*.bStart = */OSAL_bStart,
    /*.bSleep = */OSAL_bSleep,
    /*.bWakeup = */OSAL_bWakeup,
    /*.bShutdown = */OSAL_bShutdown,
    /*.vEnterCriticalSection = */OSAL_vEnterCriticalSection,
    /*.vExitCriticalSection = */OSAL_vExitCriticalSection,
    /*.eEnterTaskSafeSection = */OSAL_eEnterTaskSafeSection,
    /*.eExitTaskSafeSection = */OSAL_eExitTaskSafeSection,
    /*.eGetUtilizationCPU = */OSAL_eGetUtilizationCPU,
    /*.vResetUtilizationCPU = */OSAL_vResetUtilizationCPU,
    /*.pacGetReturnCodeName = */OSAL_pacGetReturnCodeName,
    /*.pacGetVersion = */OSAL_pacGetVersion,
    /*.pacGetObjectName = */OSAL_pacGetObjectName,
    /*.vReportError = */OSALM_vReportError,

    /*
        Task Management APIs
    */

    /*.eTaskCreate = */OSAL_eTaskCreate,
    /*.eTaskDelete = */OSAL_eTaskDelete,
    /*.eTaskSuspend = */OSAL_eTaskSuspend,
    /*.eTaskResume = */OSAL_eTaskResume,
    /*.eTaskDelay = */OSAL_eTaskDelay,
    /*.vTaskYield = */OSAL_vTaskYield,
    /*.eTaskChangePriority = */OSAL_eTaskChangePriority,
    /*.eTaskRegister = */OSAL_eTaskRegister,
    /*.eTaskUnregister = */OSAL_eTaskUnregister,
    /*.eTaskReport = */OSAL_eTaskReport,
    /*.hTaskGetHandle = */OSAL_hTaskGetHandle,
    /*.hTaskGetHandleByName = */OSAL_hTaskGetHandleByName,
    /*.eTaskGetInfo = */OSAL_eTaskGetInfo,
    /*.bTaskGetId = */OSAL_bTaskGetId,
    /*.eTaskList = */OSAL_eTaskList,

    /*
        Task Communication APIs
    */

    /*.eQueueCreate = */OSAL_eQueueCreate,
    /*.eQueueDelete = */OSAL_eQueueDelete,
    /*.eQueueGet = */OSAL_eQueueGet,
    /*.eQueuePut = */OSAL_eQueuePut,
    /*.hQueueGetHandleByName = */OSAL_hQueueGetHandleByName,
    /*.eQueueGetInfo = */OSAL_eQueueGetInfo,
    /*.eQueueList = */OSAL_eQueueList,
    /*.eMessageAllocate = */OSAL_eMessageAllocate,
    /*.eMessageFree = */OSAL_eMessageFree,

    /*
        Task Synchronization APIs
    */

    /*.eSemCreate = */OSAL_eSemCreate,
    /*.eSemDelete = */OSAL_eSemDelete,
    /*.eSemGive = */OSAL_eSemGive,
    /*.eSemTake = */OSAL_eSemTake,
    /*.hSemGetHandleByName = */OSAL_hSemGetHandleByName,
    /*.eSemGetInfo = */OSAL_eSemGetInfo,
    /*.eSemList = */OSAL_eSemList,

    /*
        Timer Management APIs
    */

    /*.eTimerCreate = */OSAL_eTimerCreate,
    /*.eTimerDelete = */OSAL_eTimerDelete,
    /*.eTimerSetHandler = */OSAL_eTimerSetHandler,
    /*.eTimerSetHandlerArg = */OSAL_eTimerSetHandlerArg,
    /*.eTimerStartRelative = */OSAL_eTimerStartRelative,
    /*.eTimerStartAbsolute = */OSAL_eTimerStartAbsolute,
    /*.eTimerStop = */OSAL_eTimerStop,
    /*.eTimerRemaining = */OSAL_eTimerRemaining,
    /*.hTimerGetHandleByName = */OSAL_hTimerGetHandleByName,
    /*.eTimerGetInfo = */OSAL_eTimerGetInfo,
    /*.eTimerList = */OSAL_eTimerList,

    /*
        Time Management APIs
    */

    /*.eTimeSet = */OSAL_eTimeSet,
    /*.eTimeSetGMToffset = */OSAL_eTimeSetGMToffset,
    /*.eTimeSetDSTadjustment = */OSAL_eTimeSetDSTadjustment,
    /*.eTimeSetRegisterNotification = */OSAL_eTimeSetRegisterNotification,
    /*.eTimeSetUnRegisterNotification = */OSAL_eTimeSetUnRegisterNotification,
    /*.eTimeGet = */OSAL_eTimeGet,
    /*.eTimeGetLocal = */OSAL_eTimeGetLocal,
    /*.eTimeGetGMToffset = */OSAL_eTimeGetGMToffset,
    /*.eTimeGetDSTadjustment = */OSAL_eTimeGetDSTadjustment,
    /*.vTimeUp = */OSAL_vTimeUp,
    /*.gmtimer_r = */OSAL_gmtime_r,
    /*.localtime_r = */OSAL_localtime_r,
    /*.mktime = */OSAL_mktime,
    /*.difftime = */OSAL_difftime,
    /*.asctime_r = */OSAL_asctime_r,
    /*.ctime_r = */OSAL_ctime_r,

    /*
        Memory Management and Interface APIs
    */

    /*.bMemRead8 = */OSAL_bMemRead8,
    /*.bMemWrite8 = */OSAL_bMemWrite8,
    /*.bMemRead16 = */OSAL_bMemRead16,
    /*.bMemWrite16 = */OSAL_bMemWrite16,
    /*.bMemRead32 = */OSAL_bMemRead32,
    /*.bMemWrite32 = */OSAL_bMemWrite32,
    /*.bPortRead8 = */OSAL_bPortRead8,
    /*.bPortWrite8 = */OSAL_bPortWrite8,
    /*.bPortRead16 = */OSAL_bPortRead16,
    /*.bPortWrite16 = */OSAL_bPortWrite16,
    /*.bPortRead32 = */OSAL_bPortRead32,
    /*.bPortWrite32 = */OSAL_bPortWrite32,
    /*.bMemCpy = */OSAL_bMemCpy,
    /*.bMemSet = */OSAL_bMemSet,
    /*.pvMemoryAllocate = */OSAL_pvMemoryAllocate,
    /*.vMemoryFree = */OSAL_vMemoryFree,
    /*.bMemoryUsage = */OSALC_bMemoryUsage,
    /*.eMemoryList = */OSAL_eMemoryList,

    /*
        Linked List APIs
    */

    /*.eLinkedListCreate = */OSAL_eLinkedListCreate,
    /*.eLinkedListDelete = */OSAL_eLinkedListDelete,
    /*.eLinkedListAdd = */OSAL_eLinkedListAdd,
    /*.eLinkedListReplaceEntry = */OSAL_eLinkedListReplaceEntry,
    /*.eLinkedListAddBeforeEntry = */OSAL_eLinkedListAddBeforeEntry,
    /*.eLinkedListAddAfterEntry = */OSAL_eLinkedListAddAfterEntry,
    /*.eLinkedListRemove = */OSAL_eLinkedListRemove,
    /*.eLinkedListSearch = */OSAL_eLinkedListSearch,
    /*.eLinkedListLinearSearch = */OSAL_eLinkedListLinearSearch,
    /*.eLinkedListSort = */OSAL_eLinkedListSort,
    /*.eLinkedListRemoveAll = */OSAL_eLinkedListRemoveAll,
    /*.pvLinkedListThis = */OSAL_pvLinkedListThis,
    /*.hLinkedListFirst = */OSAL_hLinkedListFirst,
    /*.hLinkedListLast = */OSAL_hLinkedListLast,
    /*.hLinkedListNext = */OSAL_hLinkedListNext,
    /*.hLinkedListPrev = */OSAL_hLinkedListPrev,
    /*.eLinkedListIterate = */OSAL_eLinkedListIterate,
    /*.eLinkedListItems = */OSAL_eLinkedListItems,
    /*.eLinkedListProtect = */OSAL_eLinkedListProtect,
    /*.eLinkedListUnprotect = */OSAL_eLinkedListUnprotect,
    /*.eLinkedListLock = */OSAL_eLinkedListLock,
    /*.eLinkedListUnlock = */OSAL_eLinkedListUnlock,
    /*.pvLinkedListMemoryAllocate = */OSAL_pvLinkedListMemoryAllocate,
    /*.vLinkedListMemoryFree = */OSAL_vLinkedListMemoryFree,

    /*
        Debug APIs
    */
    /*.eDebugRegister = */DEBUG_eRegisterDebughandler,
    /*.eDebugUnregister = */DEBUG_eUnRegisterDebughandler,
    /*.bOutputEnabledThisTask = */OSALT_bTaskDebugIsEnabled,
    /*.vEnableOutputThisTask = */DEBUG_vEnableOutputThisTask,
    /*.vDisableOutputThisTask = */DEBUG_vDisableOutputThisTask,
    /*.vControlOutputThisTask = */DEBUG_vCtrlOutputThisTask,
    /*.bDebugUpdateName = */DEBUG_bUpdateName,
    /*.vDebugExitHandler = */DEBUG_vExitingDebughandler,
    /*.pacSetDebugCommandLineText = */DEBUG_pacSetCommandLineText,

    /*
        Logging APIs
    */
    /*.eLogCreate = */OSAL_eLogCreate,
    /*.eLogDelete = */OSAL_eLogDelete,
    /*.n32LogWrite = */OSAL_n32LogWrite,
    /*.n32VLogWrite = */OSAL_n32VLogWrite,
    /*.n32LogRead = */OSAL_n32LogRead,
    /*.eLogClear = */OSAL_eLogClear,
    /*.vLogDisable = */OSAL_vLogDisable,
    /*.vLogEnable = */OSAL_vLogEnable,
    /*.vLogPersist = */OSAL_vLogPersist,
    /*.hLogGetHandleByName = */OSAL_hLogGetHandleByName,
    /*.eLogGetInfo = */OSAL_eLogGetInfo,
    /*.eLogList = */OSAL_eLogList,
    /*.eLogIterate = */OSAL_eLogIterate,

    /*
        Buffer APIs
    */
    /*.eBlockPoolCreate = */OSAL_eBlockPoolCreate,
    /*.eBlockPoolDelete = */OSAL_eBlockPoolDelete,
    /*.hBufferAllocate = */OSAL_hBufferAllocate,
    /*.eBufferFree = */OSAL_eBufferFree,
    /*.tBufferGetSize = */OSAL_tBufferGetSize,
    /*.tBufferGetSizeInBits = */OSAL_tBufferGetSizeInBits,
    /*.eBufferBlocksIterate = */ OSAL_eBufferBlocksIterate,
    /*.tBufferPeek = */OSAL_tBufferPeek,
    /*.tBufferPeekBits = */OSAL_tBufferPeekBits,
    /*.tBufferReadHead = */OSAL_tBufferReadHead,
    /*.tBufferReadHeadBits = */OSAL_tBufferReadHeadBits,
    /*.tBufferReadTail = */OSAL_tBufferReadTail,
    /*.tBufferSeekHead = */OSAL_tBufferSeekHead,
    /*.tBufferSeekHeadBits = */OSAL_tBufferSeekHeadBits,
    /*.tBufferSeekTail = */OSAL_tBufferSeekTail,
    /*.hBufferReadBlock = */OSAL_hBufferReadBlock,
    /*.eBufferReleaseBlock = */OSAL_eBufferReleaseBlock,
    /*.eBufferAppend = */OSAL_eBufferAppend,
    /*.eBufferWriteToFile = */OSAL_eBufferWriteToFile,
    /*.tBufferWriteHead = */OSAL_tBufferWriteHead,
    /*.tBufferWriteTail = */OSAL_tBufferWriteTail,
    /*.tBufferWriteTailBits = */OSAL_tBufferWriteTailBits,
    /*.hBufferGetBlock = */OSAL_hBufferGetBlock,
    /*.eBufferWriteBlock = */OSAL_eBufferWriteBlock,
    /*.hBufferGetHandleByName = */OSAL_hBlockPoolGetHandleByName,
    /*.eBlockPoolGetInfo = */OSAL_eBlockPoolGetInfo,
    /*.eBlockPoolList = */OSAL_eBlockPoolList,
    /*.tBufferReadString = */ OSAL_tBufferReadString,
    /*.bBufferReadBitsToUN16 = */OSAL_bBufferReadBitsToUN16,
    /*.bBufferReadBitsToN16 = */OSAL_bBufferReadBitsToN16,
    /*.bBufferReadBitsToUN32 = */OSAL_bBufferReadBitsToUN32,
    /*.bBufferReadBitsToN32 = */OSAL_bBufferReadBitsToN32,
    /*.bBufferReadBitsToUN64 = */OSAL_bBufferReadBitsToUN64,
    /*.bBufferReadBitsToN64 = */OSAL_bBufferReadBitsToN64,
    /*.bBufferPeekBitsToUN16 = */OSAL_bBufferPeekBitsToUN16,
    /*.bBufferPeekBitsToN16 = */OSAL_bBufferPeekBitsToN16,
    /*.bBufferPeekBitsToUN32 = */OSAL_bBufferPeekBitsToUN32,
    /*.bBufferPeekBitsToN32 = */OSAL_bBufferPeekBitsToN32,
    /*.bBufferPeekBitsToUN64 = */OSAL_bBufferPeekBitsToUN64,
    /*.bBufferPeekBitsToN64 = */OSAL_bBufferPeekBitsToN64,

    /* CRC APIs */
    /*.eGetCRC = */OSAL_eGetCRC,
    /*.eReleaseCRC = */OSAL_eReleaseCRC,
    /*.bInitializeCRC = */OSAL_bInitializeCRC,
    /*.tComputeCRC = */OSAL_tComputeCRC,
    /*.eCRCList = */OSAL_eCRCList,


    /* Device Framework APIs */
    /*.n32RegNode = */DEV_n32RegNode,
    /*.bUnRegNode = */DEV_bUnRegNode,

    /*
        File System APIs
    */
    /*.bFileSystemStart = */OSAL_bFileSystemStart,
    /*.bFileSystemStop = */OSAL_bFileSystemStop,
    /*.vFileSystemVolumes = */OSAL_vFileSystemVolumes,
    /*.bFileSystemVolumeInfo = */OSAL_bFileSystemVolumeInfo,
    /*.bFileSystemDirectory = */OSAL_bFileSystemDirectory,
    /*.bFileSystemMakeDir = */OSAL_bFileSystemMakeDir,
    /*.bFileSystemRemoveDir = */OSAL_bFileSystemRemoveDir,
    /*.eFileSystemGetDirItems = */OSAL_eFileSystemGetDirItems,
    /*.eFileSystemReleaseDirItems = */OSAL_eFileSystemReleaseDirItems,
    /*.bFileSystemTruncateFile = */OSAL_bFileSystemTruncateFile,
    /*.bFileSystemGetFileSize = */OSAL_bFileSystemGetFileSize,
    /*.bFileSystemGetFileAttributes = */OSAL_bFileSystemGetFileAttributes,
    /*.bFileSystemSetFileAttributes = */OSAL_bFileSystemSetFileAttributes,
    /*.bFileSystemSetTempPath = */OSAL_bFileSystemSetTempPath,
    /*.tFileSystemGetTempPath = */OSAL_tFileSystemGetTempPath,
    /*.bFileSystemSyncFile = */OSAL_bFileSystemSyncFile,
    /*.bFileSystemUnconditionalFileUnlink = */OSAL_bFileSystemUnconditionalFileUnlink,

    /*
        ANSI-C file/stdio APIs
    */
    /*.psFopen = */OSAL_psFopen,
    /*.iFclose = */OSAL_iFclose,
    /*.tFread = */OSAL_tFread,
    /*.tFwrite = */OSAL_tFwrite,
    /*.lFtell = */OSAL_lFtell,
    /*.iIoctl = */OSAL_iIoctl,
    /*.iFseek = */OSAL_iFseek,
    /*.iRemove = */OSAL_iRemove,
    /*.iRename = */OSAL_iRename,
    /*.iCopyFile = */OSAL_iCopyFile,
    /*.iFflush = */OSAL_iFflush,
    /*.iFeof = */OSAL_iFeof,
    /*.iFerror = */OSAL_iFerror,
    /*.vClearerr = */OSAL_vClearerr,

    /*.iFgetc = */OSAL_iFgetc,
    /*.pcFgets = */OSAL_pcFgets,
    /*.iFputc = */OSAL_iFputc,
    /*.iFputs = */OSAL_iFputs,
    /*.iFPrintf = */OSAL_iFPrintf,
    /*.vDump = */OSAL_vDump,


    /*.iPrintf = */OSAL_iPrintf,
    /*.iPutchar = */OSAL_iPutchar,
    /*.iPuts = */OSAL_iPuts,
    /*.iGetchar = */OSAL_iGetchar,
    /*.pcGets = */OSAL_pcGets,

};

const OSAL_FIXED_INTERFACE_STRUCT OSAL_FIXED =
{
    /*.hCreate = */FIXED_hCreate,
    /*.hCreateFromFixed = */FIXED_hCreateFromFixed,
    /*.hCreateInMemory = */FIXED_hCreateInMemory,
    /*.hDuplicate = */FIXED_hDuplicate,
    /*.hDuplicateInMemory = */FIXED_hDuplicateInMemory,
    /*.bCopyToMemory = */FIXED_bCopyToMemory,
    /*.vDestroy = */FIXED_vDestroy,
    /*.n32Value = */FIXED_n32Value,
    /*.un8NumFractionalBits = */FIXED_un8NumFractionalBits,
    /*.n32ScaledValue = */FIXED_n32ScaledValue,
    /*.n32Ceiling = */FIXED_n32Ceiling,
    /*.n32Floor = */FIXED_n32Floor,
    /*.eAdd = */FIXED_eAdd,
    /*.eSubtract = */FIXED_eSubtract,
    /*.eMultiply = */FIXED_eMultiply,
    /*.eDivide = */FIXED_eDivide,
    /*.eDegreeToRadian = */FIXED_eDegreeToRadian,
    /*.eRadianToDegree = */FIXED_eRadianToDegree,
    /*.eSin = */FIXED_eSin,
    /*.eASin = */FIXED_eASin,
    /*.eCos = */FIXED_eCos,
    /*.eACos = */FIXED_eACos,
    /*.eATan = */FIXED_eATan,
    /*.eATan2 = */FIXED_eATan2,
    /*.eAbs = */FIXED_eAbs,
    /*.eSqrt = */FIXED_eSqrt,
    /*.ePow = */FIXED_ePow,
    /*.eEval = */FIXED_eEval,
    /*.n16Compare = */FIXED_n16Compare,
    /*.n32FWrite = */FIXED_n32FWrite,
    /*.hFRead = */FIXED_hFRead,
    /*.n32FPrintf = */FIXED_n32FPrintf
};


  /**********************/
 /** INLINE FUNCTIONS **/
/**********************/

#endif	// _OSAL_H_
