/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * PRIVATE HEADER
 *  This is a generic SRH header file for all SRH devices.
 *  This file need not, and should not be modified to accommodate specific
 *  SRH devices.
 *
 ******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/
#ifndef _SRH_H_
#define _SRH_H_

  /**************/
 /** INCLUDES **/
/**************/

#include <standard.h>
#include "osal.h"

#include "srh.h"

  /***************/
 /** CONSTANTS **/
/***************/

  /**************/
 /** TYPEDEFS **/
/**************/

// SRH public data structure. This is a local structure for which a
// single instance is created and accessible to ALL instances of SRMs
typedef struct srh_public_struct
{
    // Physical Configuration of the SRH
    SRH_DEVICE_STRUCT *psPhy;

} SRH_PUBLIC_STRUCT;

// SRH private data structure. This is a local structure for which a
// new instance is created and accessible only by an SRH instance which
// created it.
typedef struct srh_private_struct
{
    // File handle to the port this instance represents
    FILE *psFile;

} SRH_PRIVATE_STRUCT;

  /************/
 /** MACROS **/
/************/

#define VERIFY_DEVICE_GROUP(tDeviceGroup) \
    (((tDeviceGroup) == DEVICE_GROUP_NOT_PROVISIONED) || \
     (((tDeviceGroup) >= DEVICE_GROUP_MIN) && \
      ((tDeviceGroup) <= DEVICE_GROUP_MAX)) \
         )

  /****************/
 /** PROTOTYPES **/
/****************/

static BOOLEAN _bInit (
                        const char *pcDevName,
                        void const *pvProperties,
                        void **ppvPublicData
                        );

static void _vExit (
                        void const *pvProperties,
                        void *pvPublicData
                        );

static N32 _n32Open (
                        OSAL_DEV_INFO_STRUCT *psDeviceInfo,
                        const void *pvArg
                        );

static N32 _n32Close (
                        OSAL_DEV_INFO_STRUCT *psDeviceInfo
                        );

static size_t _tRead (
                        const OSAL_DEV_INFO_STRUCT *psDeviceInfo,
                        char *pcDst,
                        size_t tSize,
                        size_t tNumObjs
                        );

static size_t _tWrite (
                        const OSAL_DEV_INFO_STRUCT *psDeviceInfo,
                        const char *pcSrc,
                        size_t tSize,
                        size_t tNumObjs
                        );

static N32 _n32Ioctl (
                        const OSAL_DEV_INFO_STRUCT *psDeviceInfo,
                        N32 n32Cmd,
                        va_list *ptList
                        );

static FILE *_psParseArg (
    SRH_DEVICE_STRUCT *psPhy,
    const char *pcArg
    );

static BOOLEAN _bVerifyUniqueNames (
    SRH_DEVICE_STRUCT *psPhy
    );

static SRH_DEVICE_SRM_MAP_STRUCT *_psFindSRMInSRH (
    char *pacSRMName,
    SRH_DEVICE_STRUCT *psPhy,
    UN8 *pun8Index
    );

static BOOLEAN _bProcessPortMode (
    const char *pacPortMode,
    SRH_DEVICE_PORT_TUPLE_STRUCT *psTuple
    );

  /***************/
 /** VARIABLES **/
/***************/

// Declaration (external) for the SRM driver interface
const OSAL_DEV_INTERFACE_STRUCT GsSRHInterface =
{
    /*.bInit =*/    _bInit,
    /*.vExit =*/    _vExit,
    /*.n32Open =*/  _n32Open,
    /*.n32Close =*/ _n32Close,
    /*.tRead =*/    _tRead,
    /*.tWrite =*/   _tWrite,
    /*.n32Ioctl =*/ _n32Ioctl
};

  /**********************/
 /** INLINE FUNCTIONS **/
/**********************/

#endif	// _SRM_H_
