/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * PRIVATE HEADER
 *
 ******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/
#ifndef _SIO_SHIM_H_
#define _SIO_SHIM_H_

  /**************/
 /** INCLUDES **/
/**************/

#include "standard.h"
#include "osal.h"

#include "sio_shim.h"

  /***************/
 /** CONSTANTS **/
/***************/

// Default mode to open device with (known good mode).
#define SIO_SHIM_DEFAULT_MODE "57600,N,8,1"

  /**************/
 /** TYPEDEFS **/
/**************/

// Serial I/O shim device public data structure. This is a local structure
// for which a single instance is created and accessible to ALL instances
// of this driver.
typedef struct sio_shim_public_struct
{
    // Serial Device File Handle (shim'd)
    FILE *psFile;

    // Comm Assigned?
    BOOLEAN bCommAssigned;

} SIO_SHIM_PUBLIC_STRUCT;

  /************/
 /** MACROS **/
/************/

  /****************/
 /** PROTOTYPES **/
/****************/

static BOOLEAN _bInit (
                        const char *pcDevName,
                        void const *pvProperties,
                        void **ppvPublicData
                        );

static void _vExit (
                        void const *pvProperties,
                        void *pvPublicData
                        );

static N32 _n32Open (
                        OSAL_DEV_INFO_STRUCT *psDeviceInfo,
                        const void *pvArg
                        );

static N32 _n32Close (
                        OSAL_DEV_INFO_STRUCT *psDeviceInfo
                        );

static size_t _tRead (
                        const OSAL_DEV_INFO_STRUCT *psDeviceInfo,
                        char *pcDst,
                        size_t tSize,
                        size_t tNumObjs
                        );

static size_t _tWrite (
                        const OSAL_DEV_INFO_STRUCT *psDeviceInfo,
                        const char *pcSrc,
                        size_t tSize,
                        size_t tNumObjs
                        );

static N32 _n32Ioctl (
                        const OSAL_DEV_INFO_STRUCT *psDeviceInfo,
                        N32 n32Cmd,
                        va_list *ptList
                        );

  /***************/
 /** VARIABLES **/
/***************/

// Declaration (external) for the Serial-I/O Shim driver interface
const OSAL_DEV_INTERFACE_STRUCT GsSioInterface =
{
    _bInit,
    _vExit,
    _n32Open,
    _n32Close,
    _tRead,
    _tWrite,
    _n32Ioctl
};

  /**********************/
 /** INLINE FUNCTIONS **/
/**********************/

#endif	// _SIO_SHIM_H_
