/******************************************************************************/
/*                    Copyright (c) Sirius XM Radio, Inc.                     */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius XM Radio, Inc.             */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 * PRIVATE HEADER
 *
 ******************************************************************************/

  /*********************************/
 /** PREVENT REDUNDANT INCLUSION **/
/*********************************/
#ifndef _MEM_BUFFER_H_
#define _MEM_BUFFER_H_

  /**************/
 /** INCLUDES **/
/**************/

#include "standard.h"
#include "osal.h"
#include "mem_buffer.h"

  /***************/
 /** CONSTANTS **/
/***************/

  /**************/
 /** TYPEDEFS **/
/**************/

typedef enum mem_buffer_mode_enum
{
    MEM_BUFFER_MODE_READ = 0,
    MEM_BUFFER_MODE_WRITE,
    MEM_BUFFER_MODE_INVALID

} MEM_BUFFER_MODE_ENUM;

typedef struct mem_buffer_private_struct
{
    // The mode for this connection
    MEM_BUFFER_MODE_ENUM eMode;

    // Timeout value for blocking operations
    N32 n32Timeout;

    N32 n32Error;

} MEM_BUFFER_PRIVATE_STRUCT;

typedef struct mem_buffer_public_struct
{
    // The block pool for the buffer.  Block pool properties
    // are defined by the properties when the device is registerd
    OSAL_OBJECT_HDL hBlockPool;

    // The buffer that reads and writes happen on.
    OSAL_OBJECT_HDL hBuffer;

    // Pointers to enforce the one read and one write connection
    MEM_BUFFER_PRIVATE_STRUCT *psReadConnection;
    MEM_BUFFER_PRIVATE_STRUCT *psWriteConnection;

} MEM_BUFFER_PUBLIC_STRUCT;

  /************/
 /** MACROS **/
/************/

  /****************/
 /** PROTOTYPES **/
/****************/

static BOOLEAN _bInit (
                        const char *pcDevName,
                        void const *pvProperties,
                        void **ppvPublicData
                        );

static void _vExit (
                        void const *pvProperties,
                        void *pvPublicData
                        );

static N32 _n32Open (
                        OSAL_DEV_INFO_STRUCT *psDeviceInfo,
                        const void *pvArg
                        );

static N32 _n32Close (
                        OSAL_DEV_INFO_STRUCT *psDeviceInfo
                        );

static size_t _tRead (
                        const OSAL_DEV_INFO_STRUCT *psDeviceInfo,
                        char *pcDst,
                        size_t tSize,
                        size_t tNumObjs
                        );

static size_t _tWrite (
                        const OSAL_DEV_INFO_STRUCT *psDeviceInfo,
                        const char *pcSrc,
                        size_t tSize,
                        size_t tNumObjs
                        );

static N32 _n32Ioctl (
                        const OSAL_DEV_INFO_STRUCT *psDeviceInfo,
                        N32 n32Cmd,
                        va_list *ptList
                        );

static BOOLEAN _bParseArg (
    const char *pcArg,
    MEM_BUFFER_MODE_ENUM *peMode
    );

  /***************/
 /** VARIABLES **/
/***************/

// Declaration (external) for the Posix Serial driver interface
const OSAL_DEV_INTERFACE_STRUCT GsMemBufferInterface =
{
    /*.bInit =*/    _bInit,
    /*.vExit =*/    _vExit,
    /*.n32Open =*/  _n32Open,
    /*.n32Close =*/ _n32Close,
    /*.tRead =*/    _tRead,
    /*.tWrite =*/   _tWrite,
    /*.n32Ioctl =*/ _n32Ioctl
};

  /**********************/
 /** INLINE FUNCTIONS **/
/**********************/

#endif	// _MEM_BUFFER_H_
