/******************************************************************************/
/*                    Copyright (c) Sirius-XM Satellite Radio Inc.            */
/*                            All Rights Reserved                             */
/*         Licensed Materials - Property of Sirius-XM Satellite Radio Inc.    */
/*                           Proprietary & Confidential	                      */
/******************************************************************************/
/*******************************************************************************
 *
 * DESCRIPTION
 *
 *  This is the common Serial Communications Device Driver header which is
 *  common to all serial communication ports.
 *
 ******************************************************************************/

#ifndef COM_H_
#define COM_H_

#ifdef __cplusplus
extern "C" {
#endif


  /**************/
 /** INCLUDES **/
/**************/

#include <standard.h>

#include "osal.h"
#include "devices.h"

  /**********************/
 /** GLOBAL CONSTANTS **/
/**********************/

/* COM 'device' ioctl id's */
#define COM_IOCTL_SET_SIGNALS           (DEV_IOCTL_COM + 0)
#define COM_IOCTL_GET_SIGNALS           (DEV_IOCTL_COM + 1)
#define COM_IOCTL_CLR_SIGNALS           (DEV_IOCTL_COM + 2)
#define COM_IOCTL_SET_RTO               (DEV_IOCTL_COM + 3)
#define COM_IOCTL_SET_WTO               (DEV_IOCTL_COM + 4)
#define COM_IOCTL_GET_STATISTICS        (DEV_IOCTL_COM + 5)
#define COM_IOCTL_RESET_STATISTICS      (DEV_IOCTL_COM + 6)
#define COM_IOCTL_DUMP_STATISTICS       (DEV_IOCTL_COM + 7)
#define COM_IOCTL_SET_SIGNAL_CALLBACK   (DEV_IOCTL_COM + 8)
#define COM_IOCTL_CHANGE_SETTINGS       (DEV_IOCTL_COM + 9)

/* Signals */
#define  COM_SIGNAL_RTS        (0x01)
#define  COM_SIGNAL_CTS        (0x02)
#define  COM_SIGNAL_DSR        (0x04)
#define  COM_SIGNAL_DCD        (0x08)
#define  COM_SIGNAL_DTR        (0x10)
#define  COM_SIGNAL_RI         (0x20)

  /*********************/
 /** GLOBAL TYPEDEFS **/
/*********************/

/* Common COM Serial Device Statistics */
typedef struct com_ioctl_statistics_struct
{
    // Statistics
    UN32 un32TxBytes;
    UN32 un32RxBytes;
    UN32 un32BufferOverflows;
    UN32 un32Interrupts;
    UN32 un32OverrunErrors;
    UN32 un32FramingErrors;
    UN32 un32ParityErrors;
    UN32 un32BreakErrors;
    UN32 un32Errors;

} COM_IOCTL_STATISTICS_STRUCT;

/* COM Singal Event Callback */
typedef void (*COM_SIGNAL_CALLBACK_HDLR)(
    UN8 un8SignalMask, UN8 un8SignalState, void *pvArg);

  /*****************************/
 /** GLOBAL STRUCT TEMPLATES **/
/*****************************/

  /****************************/
 /** GLOBAL UNION TEMPLATES **/
/****************************/

  /**********************/
 /** GLOBAL VARIABLES **/
/**********************/

  /*******************/
 /** GLOBAL MACROS **/
/*******************/

  /***********************/
 /** GLOBAL PROTOTYPES **/
/***********************/


#ifdef __cplusplus
}
#endif

#endif /* COM_H */
